/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.AccrueType;
import com.tapsterrock.mpx.CurrencySymbolPosition;
import com.tapsterrock.mpx.DateFormat;
import com.tapsterrock.mpx.DateOrder;
import com.tapsterrock.mpx.Day;
import com.tapsterrock.mpx.EarnedValueMethod;
import com.tapsterrock.mpx.LocaleData;
import com.tapsterrock.mpx.MPXCurrency;
import com.tapsterrock.mpx.MPXDate;
import com.tapsterrock.mpx.MPXDuration;
import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXPercentage;
import com.tapsterrock.mpx.MPXRate;
import com.tapsterrock.mpx.MPXRecord;
import com.tapsterrock.mpx.NumericBoolean;
import com.tapsterrock.mpx.Record;
import com.tapsterrock.mpx.ScheduleFrom;
import com.tapsterrock.mpx.TaskType;
import com.tapsterrock.mpx.TimeFormat;
import com.tapsterrock.mpx.TimeUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class ProjectHeader
extends MPXRecord {
    private String m_currencySymbol;
    private CurrencySymbolPosition m_symbolPosition;
    private Integer m_currencyDigits;
    private char m_thousandsSeparator;
    private char m_decimalSeparator;
    private boolean m_updateCurrencyFormat;
    static final int CURRENCY_SETTINGS_RECORD_NUMBER = 10;
    private TimeUnit m_defaultDurationUnits;
    private NumericBoolean m_defaultDurationIsFixed;
    private TimeUnit m_defaultWorkUnits;
    private Float m_defaultHoursInDay;
    private Float m_defaultHoursInWeek;
    private MPXRate m_defaultStandardRate;
    private MPXRate m_defaultOvertimeRate;
    private NumericBoolean m_updatingTaskStatusUpdatesResourceStatus;
    private NumericBoolean m_splitInProgressTasks;
    private DateOrder m_dateOrder;
    private TimeFormat m_timeFormat;
    private Date m_defaultStartTime;
    private char m_dateSeparator;
    private char m_timeSeparator;
    private String m_amText;
    private String m_pmText;
    private DateFormat m_dateFormat;
    private DateFormat m_barTextDateFormat;
    private String m_projectTitle;
    private String m_company;
    private String m_manager;
    private String m_calendarName;
    private MPXDate m_startDate;
    private MPXDate m_finishDate;
    private ScheduleFrom m_scheduleFrom;
    private MPXDate m_currentDate;
    private String m_comments;
    private MPXCurrency m_cost;
    private MPXCurrency m_baselineCost;
    private MPXCurrency m_actualCost;
    private MPXDuration m_work;
    private MPXDuration m_baselineWork;
    private MPXDuration m_actualWork;
    private MPXPercentage m_work2;
    private MPXDuration m_duration;
    private MPXDuration m_baselineDuration;
    private MPXDuration m_actualDuration;
    private MPXPercentage m_percentageComplete;
    private MPXDate m_baselineStart;
    private MPXDate m_baselineFinish;
    private MPXDate m_actualStart;
    private MPXDate m_actualFinish;
    private MPXDuration m_startVariance;
    private MPXDuration m_finishVariance;
    private String m_subject;
    private String m_author;
    private String m_keywords;
    private Date m_defaultEndTime;
    private boolean m_projectExternallyEdited;
    private String m_category;
    private Integer m_minutesPerDay;
    private Integer m_daysPerMonth;
    private Integer m_minutesPerWeek;
    private boolean m_fiscalYearStart;
    private EarnedValueMethod m_defaultTaskEarnedValueMethod;
    private boolean m_removeFileProperties;
    private boolean m_moveCompletedEndsBack;
    private boolean m_newTasksEstimated;
    private boolean m_spreadActualCost;
    private boolean m_multipleCriticalPaths;
    private boolean m_autoAddNewResourcesAndTasks;
    private Date m_lastSaved;
    private Date m_statusDate;
    private boolean m_moveRemainingStartsBack;
    private boolean m_autolink;
    private boolean m_microsoftProjectServerURL;
    private boolean m_honorConstraints;
    private boolean m_adminProject;
    private boolean m_insertedProjectsLikeSummary;
    private String m_name;
    private boolean m_spreadPercentComplete;
    private boolean m_moveCompletedEndsForward;
    private boolean m_editableActualCosts;
    private String m_uniqueID;
    private Integer m_revision;
    private boolean m_newTasksEffortDriven;
    private boolean m_moveRemainingStartsForward;
    private boolean m_actualsInSync;
    private TaskType m_defaultTaskType;
    private EarnedValueMethod m_earnedValueMethod;
    private Date m_creationDate;
    private Date m_extendedCreationDate;
    private AccrueType m_defaultFixedCostAccrual;
    private Integer m_criticalSlackLimit;
    private Integer m_baselineForEarnedValue;
    private Integer m_fiscalYearStartMonth;
    private boolean m_newTaskStartIsProjectStart;
    private Day m_weekStartDay;
    private boolean m_updateDateTimeFormats;
    private static final char DEFAULT_DATE_SEPARATOR = '/';
    private static final char DEFAULT_TIME_SEPARATOR = ':';
    private static final Double DEFAULT_COST = new Double(0.0);
    private static final Integer DEFAULT_CRITICAL_SLACK_LIMIT = new Integer(0);
    private static final Integer DEFAULT_BASELINE_FOR_EARNED_VALUE = new Integer(0);
    private static final Integer DEFAULT_FISCAL_YEAR_START_MONTH = new Integer(1);
    private static final Day DEFAULT_WEEK_START_DAY = Day.MONDAY;
    private static final MPXDuration DEFAULT_WORK = MPXDuration.getInstance(0, TimeUnit.HOURS);
    private static final MPXPercentage DEFAULT_WORK2 = MPXPercentage.getInstance(0.0);
    private static final MPXDuration DEFAULT_DURATION = MPXDuration.getInstance(0, TimeUnit.DAYS);
    private static final ScheduleFrom DEFAULT_SCHEDULE_FROM = ScheduleFrom.START;
    private static final Integer DEFAULT_PERCENT_COMPLETE = new Integer(0);
    private static final String DEFAULT_CALENDAR_NAME = "Standard";
    private static final Integer DEFAULT_MINUTES_PER_DAY = new Integer(480);
    private static final Integer DEFAULT_DAYS_PER_MONTH = new Integer(20);
    private static final Integer DEFAULT_MINUTES_PER_WEEK = new Integer(2400);
    static final int DEFAULT_SETTINGS_RECORD_NUMBER = 11;
    static final int DATE_TIME_SETTINGS_RECORD_NUMBER = 12;
    static final int PROJECT_HEADER_RECORD_NUMBER = 30;

    ProjectHeader(MPXFile file) {
        super(file, 0);
        this.setLocale(file.getLocale());
        this.setDefaultDurationUnits(TimeUnit.DAYS);
        this.setDefaultDurationIsFixed(false);
        this.setDefaultWorkUnits(TimeUnit.HOURS);
        this.setDefaultHoursInDay(new Float(8.0f));
        this.setDefaultHoursInWeek(new Float(40.0f));
        this.setDefaultStandardRate(new MPXRate(10.0, TimeUnit.HOURS));
        this.setDefaultOvertimeRate(new MPXRate(15.0, TimeUnit.HOURS));
        this.setUpdatingTaskStatusUpdatesResourceStatus(true);
        this.setSplitInProgressTasks(false);
        this.setProjectTitle("Project1");
        this.setCompany(null);
        this.setManager(null);
        this.setCalendarName(DEFAULT_CALENDAR_NAME);
        this.setStartDate(null);
        this.setFinishDate(null);
        this.setScheduleFrom(DEFAULT_SCHEDULE_FROM);
        this.setCurrentDate(new Date());
        this.setComments(null);
        this.setCost(DEFAULT_COST);
        this.setBaselineCost(DEFAULT_COST);
        this.setActualCost(DEFAULT_COST);
        this.setWork(DEFAULT_WORK);
        this.setBaselineWork(DEFAULT_WORK);
        this.setActualWork(DEFAULT_WORK);
        this.setWork2(DEFAULT_WORK2);
        this.setDuration(DEFAULT_DURATION);
        this.setBaselineDuration(DEFAULT_DURATION);
        this.setActualDuration(DEFAULT_DURATION);
        this.setPercentageComplete(DEFAULT_PERCENT_COMPLETE);
        this.setBaselineStart(null);
        this.setBaselineFinish(null);
        this.setActualStart(null);
        this.setActualFinish(null);
        this.setStartVariance(DEFAULT_DURATION);
        this.setFinishVariance(DEFAULT_DURATION);
        this.setSubject(null);
        this.setAuthor(null);
        this.setKeywords(null);
        this.setProjectExternallyEdited(false);
        this.setMinutesPerDay(DEFAULT_MINUTES_PER_DAY);
        this.setDaysPerMonth(DEFAULT_DAYS_PER_MONTH);
        this.setMinutesPerWeek(DEFAULT_MINUTES_PER_WEEK);
        this.setFiscalYearStart(false);
        this.setDefaultTaskEarnedValueMethod(EarnedValueMethod.PERCENT_COMPLETE);
        this.setNewTasksEstimated(true);
        this.setAutoAddNewResourcesAndTasks(true);
        this.setAutolink(true);
        this.setMicrosoftProjectServerURL(true);
        this.setDefaultTaskType(TaskType.FIXED_UNITS);
        this.setDefaultFixedCostAccrual(AccrueType.END);
        this.setCriticalSlackLimit(DEFAULT_CRITICAL_SLACK_LIMIT);
        this.setBaselineForEarnedValue(DEFAULT_BASELINE_FOR_EARNED_VALUE);
        this.setFiscalYearStartMonth(DEFAULT_FISCAL_YEAR_START_MONTH);
        this.setNewTaskStartIsProjectStart(true);
        this.setWeekStartDay(DEFAULT_WEEK_START_DAY);
    }

    void updateDefaultSettings(Record record) throws MPXException {
        this.setDefaultDurationUnits(record.getTimeUnit(0));
        this.setNumericBooleanDefaultDurationIsFixed(record.getNumericBoolean(1));
        this.setDefaultWorkUnits(record.getTimeUnit(2));
        this.setDefaultHoursInDay(record.getFloat(3));
        this.setDefaultHoursInWeek(record.getFloat(4));
        this.setDefaultStandardRate(record.getRate(5));
        this.setDefaultOvertimeRate(record.getRate(6));
        this.setNumericBooleanUpdatingTaskStatusUpdatesResourceStatus(record.getNumericBoolean(7));
        this.setNumericBooleanSplitInProgressTasks(record.getNumericBoolean(8));
    }

    public TimeUnit getDefaultDurationUnits() {
        return this.m_defaultDurationUnits;
    }

    public void setDefaultDurationUnits(TimeUnit units) {
        this.m_defaultDurationUnits = units;
    }

    private NumericBoolean getNumericBooleanDefaultDurationIsFixed() {
        return this.m_defaultDurationIsFixed;
    }

    private void setNumericBooleanDefaultDurationIsFixed(NumericBoolean fixed) {
        this.m_defaultDurationIsFixed = fixed;
    }

    public boolean getDefaultDurationIsFixed() {
        return this.m_defaultDurationIsFixed.booleanValue();
    }

    public void setDefaultDurationIsFixed(boolean fixed) {
        this.m_defaultDurationIsFixed = NumericBoolean.getInstance(fixed);
    }

    public TimeUnit getDefaultWorkUnits() {
        return this.m_defaultWorkUnits;
    }

    public void setDefaultWorkUnits(TimeUnit units) {
        this.m_defaultWorkUnits = units;
    }

    public Float getDefaultHoursInDay() {
        return this.m_defaultHoursInDay;
    }

    public void setDefaultHoursInDay(Float hours) {
        this.m_defaultHoursInDay = hours;
    }

    public Float getDefaultHoursInWeek() {
        return this.m_defaultHoursInWeek;
    }

    public void setDefaultHoursInWeek(Float hours) {
        this.m_defaultHoursInWeek = hours;
    }

    public MPXRate getDefaultStandardRate() {
        return this.m_defaultStandardRate;
    }

    public void setDefaultStandardRate(MPXRate rate) {
        this.m_defaultStandardRate = rate;
    }

    public MPXRate getDefaultOvertimeRate() {
        return this.m_defaultOvertimeRate;
    }

    public void setDefaultOvertimeRate(MPXRate rate) {
        this.m_defaultOvertimeRate = rate;
    }

    private NumericBoolean getNumericBooleanUpdatingTaskStatusUpdatesResourceStatus() {
        return this.m_updatingTaskStatusUpdatesResourceStatus;
    }

    public void setNumericBooleanUpdatingTaskStatusUpdatesResourceStatus(NumericBoolean flag) {
        this.m_updatingTaskStatusUpdatesResourceStatus = flag;
    }

    public boolean getUpdatingTaskStatusUpdatesResourceStatus() {
        return this.m_updatingTaskStatusUpdatesResourceStatus.booleanValue();
    }

    public void setUpdatingTaskStatusUpdatesResourceStatus(boolean flag) {
        this.m_updatingTaskStatusUpdatesResourceStatus = NumericBoolean.getInstance(flag);
    }

    private NumericBoolean getNumericBooleanSplitInProgressTasks() {
        return this.m_splitInProgressTasks;
    }

    private void setNumericBooleanSplitInProgressTasks(NumericBoolean flag) {
        this.m_splitInProgressTasks = flag;
    }

    public boolean getSplitInProgressTasks() {
        return this.m_splitInProgressTasks.booleanValue();
    }

    public void setSplitInProgressTasks(boolean flag) {
        this.m_splitInProgressTasks = NumericBoolean.getInstance(flag);
    }

    void setLocale(Locale locale) {
        this.m_updateCurrencyFormat = false;
        this.setCurrencySymbol(LocaleData.getString(locale, "CURRENCY_SYMBOL"));
        this.setSymbolPosition((CurrencySymbolPosition)LocaleData.getObject(locale, "CURRENCY_SYMBOL_POSITION"));
        this.setCurrencyDigits(LocaleData.getInteger(locale, "CURRENCY_DIGITS"));
        this.setThousandsSeparator(LocaleData.getChar(locale, "CURRENCY_THOUSANDS_SEPARATOR"));
        this.setDecimalSeparator(LocaleData.getChar(locale, "CURRENCY_DECIMAL_SEPARATOR"));
        this.m_updateCurrencyFormat = true;
        this.updateCurrencyFormats();
        this.m_updateDateTimeFormats = false;
        this.setDateOrder((DateOrder)LocaleData.getObject(locale, "DATE_ORDER"));
        this.setTimeFormat((TimeFormat)LocaleData.getObject(locale, "TIME_FORMAT"));
        this.setIntegerDefaultStartTime(LocaleData.getInteger(locale, "DEFAULT_START_TIME"));
        this.setDateSeparator(LocaleData.getChar(locale, "DATE_SEPARATOR"));
        this.setTimeSeparator(LocaleData.getChar(locale, "TIME_SEPARATOR"));
        this.setAMText(LocaleData.getString(locale, "AM_TEXT"));
        this.setPMText(LocaleData.getString(locale, "PM_TEXT"));
        this.setDateFormat((DateFormat)LocaleData.getObject(locale, "DATE_FORMAT"));
        this.setBarTextDateFormat((DateFormat)LocaleData.getObject(locale, "DATE_FORMAT"));
        this.m_updateDateTimeFormats = true;
        this.updateDateTimeFormats();
    }

    void updateDateTimeSettings(Record record) {
        this.m_updateDateTimeFormats = false;
        this.setDateOrder(record.getDateOrder(0));
        this.setTimeFormat(record.getTimeFormat(1));
        this.setIntegerDefaultStartTime(record.getInteger(2));
        this.setDateSeparator(record.getCharacter(3));
        this.setTimeSeparator(record.getCharacter(4));
        this.setAMText(record.getString(5));
        this.setPMText(record.getString(6));
        this.setDateFormat(record.getDateFormat(7));
        this.setBarTextDateFormat(record.getDateFormat(8));
        this.m_updateDateTimeFormats = true;
        this.updateDateTimeFormats();
    }

    private void updateDateTimeFormats() {
        if (this.m_updateDateTimeFormats) {
            String datePattern = "";
            String dateTimePattern = "";
            String timePattern = this.getTimeElement();
            char datesep = this.getDateSeparator();
            int dateOrderValue = this.getDateOrder().getValue();
            switch (dateOrderValue) {
                case 1: {
                    datePattern = "dd" + datesep + "MM" + datesep + "yy";
                    break;
                }
                case 0: {
                    datePattern = "MM" + datesep + "dd" + datesep + "yy";
                    break;
                }
                case 2: {
                    datePattern = "yy" + datesep + "MM" + datesep + "dd";
                }
            }
            block5 : switch (this.getDateFormat().getValue()) {
                case 0: {
                    switch (dateOrderValue) {
                        case 1: {
                            dateTimePattern = "dd" + datesep + "MM" + datesep + "yy " + timePattern;
                            break;
                        }
                        case 0: {
                            dateTimePattern = "MM" + datesep + "dd" + datesep + "yy " + timePattern;
                            break;
                        }
                        case 2: {
                            dateTimePattern = "yy" + datesep + "MM" + datesep + "dd " + timePattern;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (dateOrderValue) {
                        case 1: {
                            dateTimePattern = "dd" + datesep + "MM" + datesep + "yy";
                            break;
                        }
                        case 0: {
                            dateTimePattern = "MM" + datesep + "dd" + datesep + "yy";
                            break;
                        }
                        case 2: {
                            dateTimePattern = "yy" + datesep + "MM" + datesep + "dd";
                        }
                    }
                    break;
                }
                case 2: {
                    switch (dateOrderValue) {
                        case 1: {
                            dateTimePattern = "dd MMMMM yyyy " + timePattern;
                            break;
                        }
                        case 0: {
                            dateTimePattern = "MMMMM dd yyyy " + timePattern;
                            break;
                        }
                        case 2: {
                            dateTimePattern = "yyyy MMMMM dd " + timePattern;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (dateOrderValue) {
                        case 1: {
                            dateTimePattern = "dd MMMMM yyyy";
                            break;
                        }
                        case 0: {
                            dateTimePattern = "MMMMM dd yyyy";
                            break;
                        }
                        case 2: {
                            dateTimePattern = "yyyy MMMMM dd";
                        }
                    }
                    break;
                }
                case 4: {
                    switch (dateOrderValue) {
                        case 1: {
                            dateTimePattern = "dd MMM " + timePattern;
                            break;
                        }
                        case 0: {
                            dateTimePattern = " MMM dd " + timePattern;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (dateOrderValue) {
                        case 1: {
                            dateTimePattern = "dd MMM ''yy";
                            break;
                        }
                        case 0: {
                            dateTimePattern = "MMM dd ''yy";
                            break;
                        }
                        case 2: {
                            dateTimePattern = "''yy MMM dd";
                        }
                    }
                    break;
                }
                case 6: {
                    switch (dateOrderValue) {
                        case 1: {
                            dateTimePattern = "dd MMMMM";
                            break;
                        }
                        case 0: {
                            dateTimePattern = "MMMMM dd";
                        }
                    }
                    break;
                }
                case 7: {
                    switch (dateOrderValue) {
                        case 1: {
                            dateTimePattern = "dd MMM";
                            break;
                        }
                        case 0: {
                            dateTimePattern = "MMM dd";
                        }
                    }
                    break;
                }
                case 8: {
                    switch (dateOrderValue) {
                        case 1: {
                            dateTimePattern = "EEE dd" + datesep + "MM" + datesep + "yy " + timePattern;
                            break;
                        }
                        case 0: {
                            dateTimePattern = "EEE MM" + datesep + "dd" + datesep + "yy " + timePattern;
                            break;
                        }
                        case 2: {
                            dateTimePattern = "EEE yy" + datesep + "MM" + datesep + "dd " + timePattern;
                        }
                    }
                    break;
                }
                case 9: {
                    switch (dateOrderValue) {
                        case 1: {
                            dateTimePattern = "EEE dd" + datesep + "MM" + datesep + "yy";
                            break;
                        }
                        case 0: {
                            dateTimePattern = "EEE MM" + datesep + "dd" + datesep + "yy";
                            break;
                        }
                        case 2: {
                            dateTimePattern = "EEE yy" + datesep + "MM" + datesep + "dd";
                        }
                    }
                    break;
                }
                case 10: {
                    switch (dateOrderValue) {
                        case 1: {
                            dateTimePattern = "EEE dd MMM ''yy";
                            break;
                        }
                        case 0: {
                            dateTimePattern = "EEE MM dd ''yy";
                            break;
                        }
                        case 2: {
                            dateTimePattern = "EEE ''yy MMM dd";
                        }
                    }
                    break;
                }
                case 11: {
                    dateTimePattern = "EEE " + timePattern;
                    break;
                }
                case 12: {
                    switch (dateOrderValue) {
                        case 1: {
                            dateTimePattern = "dd" + datesep + "MM";
                            break;
                        }
                        case 0: {
                            dateTimePattern = "MM" + datesep + "dd";
                        }
                    }
                    break;
                }
                case 13: {
                    dateTimePattern = "dd";
                    break;
                }
                case 14: {
                    dateTimePattern = timePattern;
                    break;
                }
                case 15: {
                    switch (dateOrderValue) {
                        case 1: {
                            dateTimePattern = "EEE dd MMM";
                            break;
                        }
                        case 0: {
                            dateTimePattern = "EEE MMM dd";
                        }
                    }
                    break;
                }
                case 16: {
                    switch (dateOrderValue) {
                        case 1: {
                            dateTimePattern = "EEE dd" + datesep + "MM";
                            break;
                        }
                        case 0: {
                            dateTimePattern = "EEE MM" + datesep + "dd";
                        }
                    }
                    break;
                }
                case 17: {
                    dateTimePattern = "EEE dd";
                    break;
                }
                case 18: {
                    dateTimePattern = "F" + datesep + "'W'ww";
                    break;
                }
                case 19: {
                    dateTimePattern = "F" + datesep + "'W'ww" + datesep + "yy " + timePattern;
                    break;
                }
                case 20: {
                    switch (dateOrderValue) {
                        case 1: {
                            dateTimePattern = "dd" + datesep + "MM" + datesep + "yyyy";
                            break block5;
                        }
                        case 0: {
                            dateTimePattern = "MM" + datesep + "dd" + datesep + "yyyy";
                            break block5;
                        }
                        case 2: {
                            dateTimePattern = "yyyy" + datesep + "MM" + datesep + "dd";
                        }
                    }
                }
            }
            MPXFile parent = this.getParentFile();
            parent.getDateTimeFormat().applyPattern(dateTimePattern);
            parent.getDateFormat().applyPattern(datePattern);
            parent.getTimeFormat().applyPattern(timePattern);
        }
    }

    private String getTimeElement() {
        char timesep = this.getTimeSeparator();
        TimeFormat format = this.getTimeFormat();
        String time = format == null || format.getValue() == 0 ? "hh" + timesep + "mm a" : "HH" + timesep + "mm";
        return time;
    }

    public DateOrder getDateOrder() {
        return this.m_dateOrder;
    }

    public void setDateOrder(DateOrder dateOrder) {
        this.m_dateOrder = dateOrder;
        this.updateDateTimeFormats();
    }

    public TimeFormat getTimeFormat() {
        return this.m_timeFormat;
    }

    public void setTimeFormat(TimeFormat timeFormat) {
        this.m_timeFormat = timeFormat;
        this.updateDateTimeFormats();
    }

    private void setIntegerDefaultStartTime(Integer time) {
        if (time != null) {
            int minutes = time;
            int hours = minutes / 60;
            Calendar cal = Calendar.getInstance();
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, minutes -= hours * 60);
            cal.set(11, hours);
            Date date = cal.getTime();
            this.setDefaultStartTime(date);
        }
    }

    private Integer getIntegerDefaultStartTime() {
        Integer result = null;
        Date date = this.getDefaultStartTime();
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int time = cal.get(11) * 60;
            result = new Integer(time += cal.get(12));
        }
        return result;
    }

    public Date getDefaultStartTime() {
        return this.m_defaultStartTime;
    }

    public void setDefaultStartTime(Date defaultStartTime) {
        this.m_defaultStartTime = defaultStartTime;
    }

    public char getDateSeparator() {
        return this.m_dateSeparator;
    }

    public void setDateSeparator(char dateSeparator) {
        this.m_dateSeparator = dateSeparator;
        this.updateDateTimeFormats();
    }

    private void setDateSeparator(Character dateSeparator) {
        this.setDateSeparator(dateSeparator == null ? (char)'/' : (char)dateSeparator.charValue());
    }

    public char getTimeSeparator() {
        return this.m_timeSeparator;
    }

    public void setTimeSeparator(char timeSeparator) {
        this.m_timeSeparator = timeSeparator;
        this.updateDateTimeFormats();
    }

    public void setTimeSeparator(Character timeSeparator) {
        this.setTimeSeparator(timeSeparator == null ? (char)':' : (char)timeSeparator.charValue());
    }

    public String getAMText() {
        return this.m_amText;
    }

    public void setAMText(String amText) {
        this.m_amText = amText;
        this.updateDateTimeFormats();
    }

    public String getPMText() {
        return this.m_pmText;
    }

    public void setPMText(String pmText) {
        this.m_pmText = pmText;
        this.updateDateTimeFormats();
    }

    public DateFormat getDateFormat() {
        return this.m_dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.m_dateFormat = dateFormat;
        this.updateDateTimeFormats();
    }

    public DateFormat getBarTextDateFormat() {
        return this.m_barTextDateFormat;
    }

    public void setBarTextDateFormat(DateFormat dateFormat) {
        this.m_barTextDateFormat = dateFormat;
    }

    public Date getDefaultEndTime() {
        return this.m_defaultEndTime;
    }

    public void setDefaultEndTime(Date date) {
        this.m_defaultEndTime = date;
    }

    void updateProjectHeader(Record record) throws MPXException {
        this.setProjectTitle(record.getString(0));
        this.setCompany(record.getString(1));
        this.setManager(record.getString(2));
        this.setCalendarName(record.getString(3));
        this.setStartDate(record.getDateTime(4));
        this.setFinishDate(record.getDateTime(5));
        this.setScheduleFrom(record.getScheduleFrom(6));
        this.setCurrentDate(record.getDateTime(7));
        this.setComments(record.getString(8));
        this.setCost(record.getCurrency(9));
        this.setBaselineCost(record.getCurrency(10));
        this.setActualCost(record.getCurrency(11));
        this.setWork(record.getDuration(12));
        this.setBaselineWork(record.getDuration(13));
        this.setActualWork(record.getDuration(14));
        this.setWork2(record.getPercentage(15));
        this.setDuration(record.getDuration(16));
        this.setBaselineDuration(record.getDuration(17));
        this.setActualDuration(record.getDuration(18));
        this.setPercentageComplete(record.getPercentage(19));
        this.setBaselineStart(record.getDateTime(20));
        this.setBaselineFinish(record.getDateTime(21));
        this.setActualStart(record.getDateTime(22));
        this.setActualFinish(record.getDateTime(23));
        this.setStartVariance(record.getDuration(24));
        this.setFinishVariance(record.getDuration(25));
        this.setSubject(record.getString(26));
        this.setAuthor(record.getString(27));
        this.setKeywords(record.getString(28));
    }

    public void setProjectTitle(String projectTitle) {
        this.m_projectTitle = projectTitle;
    }

    public String getProjectTitle() {
        return this.m_projectTitle;
    }

    public void setCompany(String company) {
        this.m_company = company;
    }

    public String getCompany() {
        return this.m_company;
    }

    public void setManager(String manager) {
        this.m_manager = manager;
    }

    public String getManager() {
        return this.m_manager;
    }

    public void setCalendarName(String calendarName) {
        if (calendarName == null || calendarName.length() == 0) {
            calendarName = DEFAULT_CALENDAR_NAME;
        }
        this.m_calendarName = calendarName;
    }

    public String getCalendarName() {
        return this.m_calendarName;
    }

    public void setStartDate(Date startDate) {
        this.m_startDate = this.toDate(startDate);
    }

    public Date getStartDate() {
        Date result = this.m_startDate;
        if (result == null) {
            result = this.getParentFile().getStartDate();
        }
        return result;
    }

    public Date getFinishDate() {
        Date result = this.m_finishDate;
        if (result == null) {
            result = this.getParentFile().getFinishDate();
        }
        return result;
    }

    public void setFinishDate(Date finishDate) {
        this.m_finishDate = this.toDate(finishDate);
    }

    public ScheduleFrom getScheduleFrom() {
        return this.m_scheduleFrom;
    }

    public void setScheduleFrom(ScheduleFrom scheduleFrom) {
        this.m_scheduleFrom = scheduleFrom;
    }

    public Date getCurrentDate() {
        return this.m_currentDate;
    }

    public void setCurrentDate(Date currentDate) {
        this.m_currentDate = this.toDate(currentDate);
    }

    public String getComments() {
        return this.m_comments;
    }

    public void setComments(String comments) {
        this.m_comments = comments;
    }

    public Number getCost() {
        return this.m_cost;
    }

    public void setCost(Number cost) {
        this.m_cost = this.toCurrency(cost);
    }

    public void setBaselineCost(Number baselineCost) {
        this.m_baselineCost = this.toCurrency(baselineCost);
    }

    public Number getBaselineCost() {
        return this.m_baselineCost;
    }

    public void setActualCost(Number actualCost) {
        this.m_actualCost = this.toCurrency(actualCost);
    }

    public Number getActualCost() {
        return this.m_actualCost;
    }

    public void setWork(MPXDuration work) {
        this.m_work = work;
    }

    public MPXDuration getWork() {
        return this.m_work;
    }

    public void setBaselineWork(MPXDuration baselineWork) {
        this.m_baselineWork = baselineWork;
    }

    public MPXDuration getBaselineWork() {
        return this.m_baselineWork;
    }

    public void setActualWork(MPXDuration actualWork) {
        this.m_actualWork = actualWork;
    }

    public MPXDuration getActualWork() {
        return this.m_actualWork;
    }

    public Number getWork2() {
        return this.m_work2;
    }

    public void setWork2(Number work2) {
        this.m_work2 = this.toPercentage(work2);
    }

    public MPXDuration getDuration() {
        return this.m_duration;
    }

    public void setDuration(MPXDuration duration) {
        this.m_duration = duration;
    }

    public MPXDuration getBaselineDuration() {
        return this.m_baselineDuration;
    }

    public void setBaselineDuration(MPXDuration baselineDuration) {
        this.m_baselineDuration = baselineDuration;
    }

    public MPXDuration getActualDuration() {
        return this.m_actualDuration;
    }

    public void setActualDuration(MPXDuration actualDuration) {
        this.m_actualDuration = actualDuration;
    }

    public Number getPercentageComplete() {
        return this.m_percentageComplete;
    }

    public void setPercentageComplete(Number percentComplete) {
        this.m_percentageComplete = this.toPercentage(percentComplete);
    }

    public void setBaselineStart(Date baselineStartDate) {
        this.m_baselineStart = this.toDate(baselineStartDate);
    }

    public Date getBaselineStart() {
        return this.m_baselineStart;
    }

    public void setBaselineFinish(Date baselineFinishDate) {
        this.m_baselineFinish = this.toDate(baselineFinishDate);
    }

    public Date getBaselineFinish() {
        return this.m_baselineFinish;
    }

    public void setActualStart(Date actualStartDate) {
        this.m_actualStart = this.toDate(actualStartDate);
    }

    public Date getActualStart() {
        return this.m_actualStart;
    }

    public void setActualFinish(Date actualFinishDate) {
        this.m_actualFinish = this.toDate(actualFinishDate);
    }

    public Date getActualFinish() {
        return this.m_actualFinish;
    }

    public MPXDuration getStartVariance() {
        return this.m_startVariance;
    }

    public void setStartVariance(MPXDuration startVariance) {
        this.m_startVariance = startVariance;
    }

    public MPXDuration getFinishVariance() {
        return this.m_finishVariance;
    }

    public void setFinishVariance(MPXDuration finishVariance) {
        this.m_finishVariance = finishVariance;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public void setSubject(String subject) {
        this.m_subject = subject;
    }

    public String getAuthor() {
        return this.m_author;
    }

    public void setAuthor(String author) {
        this.m_author = author;
    }

    public String getKeywords() {
        return this.m_keywords;
    }

    public void setKeywords(String keywords) {
        this.m_keywords = keywords;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        char delimiter = this.getParentFile().getDelimiter();
        buffer.append(10);
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getCurrencySymbol()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getSymbolPosition()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getCurrencyDigits()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, new Character(this.getThousandsSeparator())));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, new Character(this.getDecimalSeparator())));
        this.stripTrailingDelimiters(buffer, delimiter);
        buffer.append("\r\n");
        buffer.append(11);
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getDefaultDurationUnits()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getNumericBooleanDefaultDurationIsFixed()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getDefaultWorkUnits()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getDefaultHoursInDay()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getDefaultHoursInWeek()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getDefaultStandardRate()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getDefaultOvertimeRate()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getNumericBooleanUpdatingTaskStatusUpdatesResourceStatus()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getNumericBooleanSplitInProgressTasks()));
        this.stripTrailingDelimiters(buffer, delimiter);
        buffer.append("\r\n");
        buffer.append(12);
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getDateOrder()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getTimeFormat()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getIntegerDefaultStartTime()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, new Character(this.getDateSeparator())));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, new Character(this.getTimeSeparator())));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getAMText()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getPMText()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getDateFormat()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getBarTextDateFormat()));
        this.stripTrailingDelimiters(buffer, delimiter);
        buffer.append("\r\n");
        buffer.append(30);
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getProjectTitle()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getCompany()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getManager()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getCalendarName()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getStartDate()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getFinishDate()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getScheduleFrom()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getCurrentDate()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getComments()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getCost()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getBaselineCost()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getActualCost()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getWork()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getBaselineWork()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getActualWork()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getWork2()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getDuration()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getBaselineDuration()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getActualDuration()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getPercentageComplete()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getBaselineStart()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getBaselineFinish()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getActualStart()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getActualFinish()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getStartVariance()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getFinishVariance()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getSubject()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getAuthor()));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.getKeywords()));
        this.stripTrailingDelimiters(buffer, delimiter);
        buffer.append("\r\n");
        return buffer.toString();
    }

    void updateCurrencySettings(Record record) {
        this.m_updateCurrencyFormat = false;
        this.setCurrencySymbol(record.getString(0));
        this.setSymbolPosition(record.getCurrencySymbolPosition(1));
        this.setCurrencyDigits(record.getInteger(2));
        this.setThousandsSeparator(record.getCharacter(3));
        this.setDecimalSeparator(record.getCharacter(4));
        this.m_updateCurrencyFormat = true;
        this.updateCurrencyFormats();
    }

    public void setCurrencySymbol(String symbol) {
        if (symbol == null) {
            symbol = "$";
        }
        this.m_currencySymbol = symbol;
        this.updateCurrencyFormats();
    }

    public String getCurrencySymbol() {
        return this.m_currencySymbol;
    }

    public void setSymbolPosition(CurrencySymbolPosition posn) {
        this.m_symbolPosition = posn;
        this.updateCurrencyFormats();
    }

    public CurrencySymbolPosition getSymbolPosition() {
        return this.m_symbolPosition;
    }

    public void setCurrencyDigits(Integer currDigs) {
        this.m_currencyDigits = currDigs;
        this.updateCurrencyFormats();
    }

    public Integer getCurrencyDigits() {
        return this.m_currencyDigits;
    }

    public void setThousandsSeparator(char sep) {
        this.m_thousandsSeparator = sep;
        this.updateCurrencyFormats();
        if (this.getParentFile().getThousandsSeparator() != sep) {
            this.getParentFile().setThousandsSeparator(sep);
        }
    }

    private void setThousandsSeparator(Character sep) {
        if (sep != null) {
            this.setThousandsSeparator(sep.charValue());
        }
    }

    public char getThousandsSeparator() {
        return this.m_thousandsSeparator;
    }

    public void setDecimalSeparator(char decSep) {
        this.m_decimalSeparator = decSep;
        this.updateCurrencyFormats();
        if (this.getParentFile().getDecimalSeparator() != decSep) {
            this.getParentFile().setDecimalSeparator(decSep);
        }
    }

    private void setDecimalSeparator(Character decSep) {
        if (decSep != null) {
            this.setDecimalSeparator(decSep.charValue());
        }
    }

    public char getDecimalSeparator() {
        return this.m_decimalSeparator;
    }

    public boolean getProjectExternallyEdited() {
        return this.m_projectExternallyEdited;
    }

    public void setProjectExternallyEdited(boolean projectExternallyEdited) {
        this.m_projectExternallyEdited = projectExternallyEdited;
    }

    public String getCategory() {
        return this.m_category;
    }

    public void setCategory(String category) {
        this.m_category = category;
    }

    public Integer getDaysPerMonth() {
        return this.m_daysPerMonth;
    }

    public void setDaysPerMonth(Integer daysPerMonth) {
        this.m_daysPerMonth = daysPerMonth;
    }

    public Integer getMinutesPerDay() {
        return this.m_minutesPerDay;
    }

    public void setMinutesPerDay(Integer minutesPerDay) {
        this.m_minutesPerDay = minutesPerDay;
    }

    public Integer getMinutesPerWeek() {
        return this.m_minutesPerWeek;
    }

    public void setMinutesPerWeek(Integer minutesPerWeek) {
        this.m_minutesPerWeek = minutesPerWeek;
    }

    public boolean getFiscalYearStart() {
        return this.m_fiscalYearStart;
    }

    public void setFiscalYearStart(boolean fiscalYearStart) {
        this.m_fiscalYearStart = fiscalYearStart;
    }

    public EarnedValueMethod getDefaultTaskEarnedValueMethod() {
        return this.m_defaultTaskEarnedValueMethod;
    }

    public void setDefaultTaskEarnedValueMethod(EarnedValueMethod defaultTaskEarnedValueMethod) {
        this.m_defaultTaskEarnedValueMethod = defaultTaskEarnedValueMethod;
    }

    public boolean getRemoveFileProperties() {
        return this.m_removeFileProperties;
    }

    public void setRemoveFileProperties(boolean removeFileProperties) {
        this.m_removeFileProperties = removeFileProperties;
    }

    public boolean getMoveCompletedEndsBack() {
        return this.m_moveCompletedEndsBack;
    }

    public void setMoveCompletedEndsBack(boolean moveCompletedEndsBack) {
        this.m_moveCompletedEndsBack = moveCompletedEndsBack;
    }

    public boolean getNewTasksEstimated() {
        return this.m_newTasksEstimated;
    }

    public void setNewTasksEstimated(boolean newTasksEstimated) {
        this.m_newTasksEstimated = newTasksEstimated;
    }

    public boolean getSpreadActualCost() {
        return this.m_spreadActualCost;
    }

    public void setSpreadActualCost(boolean spreadActualCost) {
        this.m_spreadActualCost = spreadActualCost;
    }

    public boolean getMultipleCriticalPaths() {
        return this.m_multipleCriticalPaths;
    }

    public void setMultipleCriticalPaths(boolean multipleCriticalPaths) {
        this.m_multipleCriticalPaths = multipleCriticalPaths;
    }

    public boolean getAutoAddNewResourcesAndTasks() {
        return this.m_autoAddNewResourcesAndTasks;
    }

    public void setAutoAddNewResourcesAndTasks(boolean autoAddNewResourcesAndTasks) {
        this.m_autoAddNewResourcesAndTasks = autoAddNewResourcesAndTasks;
    }

    public Date getLastSaved() {
        return this.m_lastSaved;
    }

    public void setLastSaved(Date lastSaved) {
        this.m_lastSaved = lastSaved;
    }

    public Date getStatusDate() {
        return this.m_statusDate;
    }

    public void setStatusDate(Date statusDate) {
        this.m_statusDate = statusDate;
    }

    public boolean getMoveRemainingStartsBack() {
        return this.m_moveRemainingStartsBack;
    }

    public void setMoveRemainingStartsBack(boolean moveRemainingStartsBack) {
        this.m_moveRemainingStartsBack = moveRemainingStartsBack;
    }

    public boolean getAutolink() {
        return this.m_autolink;
    }

    public void setAutolink(boolean autolink) {
        this.m_autolink = autolink;
    }

    public boolean getMicrosoftProjectServerURL() {
        return this.m_microsoftProjectServerURL;
    }

    public void setMicrosoftProjectServerURL(boolean microsoftProjectServerURL) {
        this.m_microsoftProjectServerURL = microsoftProjectServerURL;
    }

    public boolean getHonorConstraints() {
        return this.m_honorConstraints;
    }

    public void setHonorConstraints(boolean honorConstraints) {
        this.m_honorConstraints = honorConstraints;
    }

    public boolean getAdminProject() {
        return this.m_adminProject;
    }

    public void setAdminProject(boolean adminProject) {
        this.m_adminProject = adminProject;
    }

    public boolean getInsertedProjectsLikeSummary() {
        return this.m_insertedProjectsLikeSummary;
    }

    public void setInsertedProjectsLikeSummary(boolean insertedProjectsLikeSummary) {
        this.m_insertedProjectsLikeSummary = insertedProjectsLikeSummary;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public boolean getSpreadPercentComplete() {
        return this.m_spreadPercentComplete;
    }

    public void setSpreadPercentComplete(boolean spreadPercentComplete) {
        this.m_spreadPercentComplete = spreadPercentComplete;
    }

    public boolean getMoveCompletedEndsForward() {
        return this.m_moveCompletedEndsForward;
    }

    public void setMoveCompletedEndsForward(boolean moveCompletedEndsForward) {
        this.m_moveCompletedEndsForward = moveCompletedEndsForward;
    }

    public boolean getEditableActualCosts() {
        return this.m_editableActualCosts;
    }

    public void setEditableActualCosts(boolean editableActualCosts) {
        this.m_editableActualCosts = editableActualCosts;
    }

    public String getUniqueID() {
        return this.m_uniqueID;
    }

    public void setUniqueID(String uniqueID) {
        this.m_uniqueID = uniqueID;
    }

    public Integer getRevision() {
        return this.m_revision;
    }

    public boolean getNewTasksEffortDriven() {
        return this.m_newTasksEffortDriven;
    }

    public void setNewTasksEffortDriven(boolean newTasksEffortDriven) {
        this.m_newTasksEffortDriven = newTasksEffortDriven;
    }

    public void setRevision(Integer revision) {
        this.m_revision = revision;
    }

    public boolean getMoveRemainingStartsForward() {
        return this.m_moveRemainingStartsForward;
    }

    public void setMoveRemainingStartsForward(boolean moveRemainingStartsForward) {
        this.m_moveRemainingStartsForward = moveRemainingStartsForward;
    }

    public boolean getActualsInSync() {
        return this.m_actualsInSync;
    }

    public void setActualsInSync(boolean actualsInSync) {
        this.m_actualsInSync = actualsInSync;
    }

    public TaskType getDefaultTaskType() {
        return this.m_defaultTaskType;
    }

    public void setDefaultTaskType(TaskType defaultTaskType) {
        this.m_defaultTaskType = defaultTaskType;
    }

    public EarnedValueMethod getEarnedValueMethod() {
        return this.m_earnedValueMethod;
    }

    public void setEarnedValueMethod(EarnedValueMethod earnedValueMethod) {
        this.m_earnedValueMethod = earnedValueMethod;
    }

    public Date getCreationDate() {
        return this.m_creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.m_creationDate = creationDate;
    }

    public Date getExtendedCreationDate() {
        return this.m_extendedCreationDate;
    }

    public AccrueType getDefaultFixedCostAccrual() {
        return this.m_defaultFixedCostAccrual;
    }

    public void setDefaultFixedCostAccrual(AccrueType defaultFixedCostAccrual) {
        this.m_defaultFixedCostAccrual = defaultFixedCostAccrual;
    }

    public void setExtendedCreationDate(Date creationDate) {
        this.m_extendedCreationDate = creationDate;
    }

    public Integer getCriticalSlackLimit() {
        return this.m_criticalSlackLimit;
    }

    public void setCriticalSlackLimit(Integer criticalSlackLimit) {
        this.m_criticalSlackLimit = criticalSlackLimit;
    }

    public Integer getBaselineForEarnedValue() {
        return this.m_baselineForEarnedValue;
    }

    public void setBaselineForEarnedValue(Integer baselineForEarnedValue) {
        this.m_baselineForEarnedValue = baselineForEarnedValue;
    }

    public Integer getFiscalYearStartMonth() {
        return this.m_fiscalYearStartMonth;
    }

    public void setFiscalYearStartMonth(Integer fiscalYearStartMonth) {
        this.m_fiscalYearStartMonth = fiscalYearStartMonth;
    }

    public boolean getNewTaskStartIsProjectStart() {
        return this.m_newTaskStartIsProjectStart;
    }

    public void setNewTaskStartIsProjectStart(boolean newTaskStartIsProjectStart) {
        this.m_newTaskStartIsProjectStart = newTaskStartIsProjectStart;
    }

    public Day getWeekStartDay() {
        return this.m_weekStartDay;
    }

    public void setWeekStartDay(Day weekStartDay) {
        this.m_weekStartDay = weekStartDay;
    }

    private void updateCurrencyFormats() {
        if (this.m_updateCurrencyFormat) {
            String noSymbolSecondaryPattern;
            String noSymbolPrimaryPattern;
            String secondaryPattern;
            MPXFile parent = this.getParentFile();
            String prefix = "";
            String suffix = "";
            String currencySymbol = this.quoteFormatCharacters(this.getCurrencySymbol());
            switch (this.getSymbolPosition().getValue()) {
                case 0: {
                    suffix = currencySymbol;
                    break;
                }
                case 1: {
                    prefix = currencySymbol;
                    break;
                }
                case 2: {
                    suffix = " " + currencySymbol;
                    break;
                }
                case 3: {
                    prefix = currencySymbol + " ";
                }
            }
            StringBuffer pattern = new StringBuffer(prefix);
            pattern.append("#0");
            int digits = this.getCurrencyDigits();
            if (digits > 0) {
                pattern.append('.');
                for (int i = 0; i < digits; ++i) {
                    pattern.append("0");
                }
            }
            pattern.append(suffix);
            String primaryPattern = pattern.toString();
            String[] alternativePatterns = new String[7];
            alternativePatterns[0] = primaryPattern + ";(" + primaryPattern + ")";
            pattern.insert(prefix.length(), "#,#");
            alternativePatterns[1] = secondaryPattern = pattern.toString();
            alternativePatterns[2] = secondaryPattern + ";(" + secondaryPattern + ")";
            pattern.setLength(0);
            pattern.append("#0");
            if (digits > 0) {
                pattern.append('.');
                for (int i = 0; i < digits; ++i) {
                    pattern.append("0");
                }
            }
            alternativePatterns[3] = noSymbolPrimaryPattern = pattern.toString();
            alternativePatterns[4] = noSymbolPrimaryPattern + ";(" + noSymbolPrimaryPattern + ")";
            pattern.insert(0, "#,#");
            alternativePatterns[5] = noSymbolSecondaryPattern = pattern.toString();
            alternativePatterns[6] = noSymbolSecondaryPattern + ";(" + noSymbolSecondaryPattern + ")";
            parent.setCurrencyFormat(primaryPattern, alternativePatterns, this.getDecimalSeparator(), this.getThousandsSeparator());
        }
    }

    private String quoteFormatCharacters(String literal) {
        StringBuffer sb = new StringBuffer();
        int length = literal.length();
        block3: for (int loop = 0; loop < length; ++loop) {
            char c = literal.charAt(loop);
            switch (c) {
                case '#': 
                case '%': 
                case ',': 
                case '-': 
                case '.': 
                case '0': 
                case ';': 
                case 'E': {
                    sb.append("'");
                    sb.append(c);
                    sb.append("'");
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

