/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.LocaleData;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.ToStringRequiresFile;
import java.util.Locale;

public final class Priority
implements ToStringRequiresFile {
    public static final int LOWEST = 100;
    public static final int VERY_LOW = 200;
    public static final int LOWER = 300;
    public static final int LOW = 400;
    public static final int MEDIUM = 500;
    public static final int HIGH = 600;
    public static final int HIGHER = 700;
    public static final int VERY_HIGH = 800;
    public static final int HIGHEST = 900;
    public static final int DO_NOT_LEVEL = 1000;
    private static final Priority[] VALUE = new Priority[]{new Priority(100), new Priority(200), new Priority(300), new Priority(400), new Priority(500), new Priority(600), new Priority(700), new Priority(800), new Priority(900), new Priority(1000)};
    private int m_value;

    private Priority(int priority) {
        this.m_value = priority < 100 || priority > 1000 ? 500 : priority;
    }

    public static Priority getInstance(Locale locale, String priority) {
        int index = 500;
        if (priority != null) {
            String[] priorityTypes = LocaleData.getStringArray(locale, "PRIORITY_TYPES");
            for (int loop = 0; loop < priorityTypes.length; ++loop) {
                if (!priorityTypes[loop].equalsIgnoreCase(priority)) continue;
                index = loop;
                break;
            }
        }
        return VALUE[index];
    }

    public static Priority getInstance(int priority) {
        Priority result = priority >= 100 && priority <= 1000 && priority % 100 == 0 ? VALUE[priority / 100 - 1] : new Priority(priority);
        return result;
    }

    public int getValue() {
        return this.m_value;
    }

    public String toString(MPXFile mpx) {
        String[] priorityTypes = LocaleData.getStringArray(mpx.getLocale(), "PRIORITY_TYPES");
        int priority = this.m_value;
        if (priority < 100) {
            priority = 100;
        } else if (priority > 1000) {
            priority = 1000;
        }
        return priorityTypes[(priority /= 100) - 1];
    }
}

