/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.DateRange;
import com.tapsterrock.mpx.Day;
import com.tapsterrock.mpx.MPXCalendar;
import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXRecord;
import com.tapsterrock.mpx.NumberUtility;
import com.tapsterrock.mpx.Record;
import java.util.Iterator;
import java.util.LinkedList;

public final class MPXCalendarHours
extends MPXRecord {
    private MPXCalendar m_parentCalendar;
    private Day m_day;
    private LinkedList m_dateRanges = new LinkedList();
    static final int BASE_CALENDAR_HOURS_RECORD_NUMBER = 25;
    static final int RESOURCE_CALENDAR_HOURS_RECORD_NUMBER = 56;

    MPXCalendarHours(MPXFile file, MPXCalendar parentCalendar) throws MPXException {
        this(file, parentCalendar, Record.EMPTY_RECORD);
    }

    MPXCalendarHours(MPXFile file, MPXCalendar parentCalendar, Record record) throws MPXException {
        super(file, 0);
        this.m_parentCalendar = parentCalendar;
        if (record != Record.EMPTY_RECORD) {
            this.setDay(Day.getInstance(NumberUtility.getInt(record.getInteger(0))));
            this.addDateRange(new DateRange(record.getTime(1), record.getTime(2)));
            this.addDateRange(new DateRange(record.getTime(3), record.getTime(4)));
            this.addDateRange(new DateRange(record.getTime(5), record.getTime(6)));
        }
    }

    public Day getDay() {
        return this.m_day;
    }

    void setDay(Day d) {
        this.m_day = d;
    }

    public void addDateRange(DateRange range) {
        this.m_dateRanges.add(range);
    }

    public DateRange getDateRange(int index) {
        DateRange result = null;
        if (index >= 0 && index < this.m_dateRanges.size()) {
            result = (DateRange)this.m_dateRanges.get(index);
        }
        return result;
    }

    public Iterator iterator() {
        return this.m_dateRanges.iterator();
    }

    public String toString() {
        DateRange range3;
        DateRange range2;
        int recordNumber = this.m_parentCalendar.isBaseCalendar() ? 25 : 56;
        StringBuffer buffer = new StringBuffer();
        char delimiter = this.getParentFile().getDelimiter();
        DateRange range1 = this.getDateRange(0);
        if (range1 == null) {
            range1 = DateRange.EMPTY_RANGE;
        }
        if ((range2 = this.getDateRange(1)) == null) {
            range2 = DateRange.EMPTY_RANGE;
        }
        if ((range3 = this.getDateRange(2)) == null) {
            range3 = DateRange.EMPTY_RANGE;
        }
        buffer.append(recordNumber);
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.m_day));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.toTime(range1.getStartDate())));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.toTime(range1.getEndDate())));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.toTime(range2.getStartDate())));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.toTime(range2.getEndDate())));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.toTime(range3.getStartDate())));
        buffer.append(delimiter);
        buffer.append(this.format(delimiter, this.toTime(range3.getEndDate())));
        this.stripTrailingDelimiters(buffer, delimiter);
        buffer.append("\r\n");
        return buffer.toString();
    }
}

