/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.event.hierarchy.DockingPortTracker;
import org.flexdock.docking.state.DockingState;
import org.flexdock.docking.state.FloatManager;
import org.flexdock.docking.state.LayoutManager;
import org.flexdock.docking.state.LayoutNode;
import org.flexdock.docking.state.PersistenceException;
import org.flexdock.event.EventManager;
import org.flexdock.event.RegistrationEvent;
import org.flexdock.perspective.DockingStateListener;
import org.flexdock.perspective.LayoutBuilder;
import org.flexdock.perspective.Perspective;
import org.flexdock.perspective.PerspectiveFactory;
import org.flexdock.perspective.RestorationManager;
import org.flexdock.perspective.event.LayoutEventHandler;
import org.flexdock.perspective.event.PerspectiveEvent;
import org.flexdock.perspective.event.PerspectiveEventHandler;
import org.flexdock.perspective.event.PerspectiveListener;
import org.flexdock.perspective.event.RegistrationHandler;
import org.flexdock.perspective.persist.FilePersistenceHandler;
import org.flexdock.perspective.persist.PersistenceHandler;
import org.flexdock.perspective.persist.PerspectiveModel;
import org.flexdock.util.RootWindow;
import org.flexdock.util.Utilities;

public class PerspectiveManager
implements LayoutManager {
    public static final String EMPTY_PERSPECTIVE = "PerspectiveManager.EMPTY_PERSPECTIVE";
    public static final String DEFAULT_PERSISTENCE_KEY_VALUE = "perspectiveFile.data";
    private static PerspectiveManager SINGLETON = new PerspectiveManager();
    private static DockingStateListener UPDATE_LISTENER = new DockingStateListener();
    private HashMap m_perspectives = new HashMap();
    private PerspectiveFactory perspectiveFactory;
    private String m_defaultPerspective;
    private String m_currentPerspective;
    private PersistenceHandler m_persistHandler;
    private boolean restoreFloatingOnLoad;
    private String m_defaultPersistenceKey;

    private static void initialize() {
        Class c = DockingManager.class;
        EventManager.addHandler(new RegistrationHandler());
        EventManager.addHandler(PerspectiveEventHandler.getInstance());
        EventManager.addHandler(new LayoutEventHandler());
        EventManager.addListener(UPDATE_LISTENER);
        String pKey = System.getProperty("default.persist.key");
        PerspectiveManager.setPersistenceHandler(FilePersistenceHandler.createDefault(DEFAULT_PERSISTENCE_KEY_VALUE));
        PerspectiveManager.getInstance().setDefaultPersistenceKey(pKey);
    }

    public static PerspectiveManager getInstance() {
        return SINGLETON;
    }

    public static void setFactory(PerspectiveFactory factory) {
        PerspectiveManager.getInstance().perspectiveFactory = factory;
    }

    public static void setPersistenceHandler(PersistenceHandler handler) {
        PerspectiveManager.getInstance().m_persistHandler = handler;
    }

    public static PersistenceHandler getPersistenceHandler() {
        return PerspectiveManager.getInstance().m_persistHandler;
    }

    private PerspectiveManager() {
        this.setDefaultPerspective(EMPTY_PERSPECTIVE);
        this.loadPerspective(this.m_defaultPerspective, (DockingPort)null);
    }

    public void add(Perspective perspective) {
        this.add(perspective, false);
    }

    public void add(Perspective perspective, boolean isDefault) {
        if (perspective == null) {
            throw new NullPointerException("perspective cannot be null");
        }
        this.m_perspectives.put(perspective.getPersistentId(), perspective);
        if (isDefault) {
            this.setDefaultPerspective(perspective.getPersistentId());
        }
        EventManager.dispatch(new RegistrationEvent((Object)perspective, (Object)this, true));
    }

    public void remove(String perspectiveId) {
        if (perspectiveId == null) {
            throw new NullPointerException("perspectiveId cannot be null");
        }
        Perspective perspective = this.getPerspective(perspectiveId);
        if (perspective == null) {
            return;
        }
        this.m_perspectives.remove(perspectiveId);
        if (this.m_defaultPerspective.equals(perspectiveId)) {
            this.setDefaultPerspective(EMPTY_PERSPECTIVE);
        }
        EventManager.dispatch(new RegistrationEvent((Object)perspective, (Object)this, false));
    }

    public Perspective getPerspective(String perspectiveId) {
        if (perspectiveId == null) {
            return null;
        }
        Perspective perspective = (Perspective)this.m_perspectives.get(perspectiveId);
        if (perspective == null && (perspective = this.createPerspective(perspectiveId)) != null) {
            this.add(perspective);
        }
        return perspective;
    }

    public Perspective createPerspective(String perspectiveId) {
        if (EMPTY_PERSPECTIVE.equals(perspectiveId)) {
            return new Perspective(EMPTY_PERSPECTIVE, EMPTY_PERSPECTIVE){

                public void load(DockingPort port, boolean defaultSetting) {
                }
            };
        }
        Perspective p = null;
        if (this.perspectiveFactory != null && !(p = this.perspectiveFactory.getPerspective(perspectiveId)).getPersistentId().equals(perspectiveId)) {
            throw new IllegalStateException("Factory created perspective does not match intended ID: " + perspectiveId);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Perspective[] getPerspectives() {
        HashMap hashMap = this.m_perspectives;
        synchronized (hashMap) {
            ArrayList list = new ArrayList(this.m_perspectives.values());
            return list.toArray(new Perspective[0]);
        }
    }

    public void addListener(PerspectiveListener perspectiveListener) {
        EventManager.addListener(perspectiveListener);
    }

    public void removeListener(PerspectiveListener perspectiveListener) {
        EventManager.removeListener(perspectiveListener);
    }

    public PerspectiveListener[] getPerspectiveListeners() {
        return PerspectiveEventHandler.getInstance().getListeners();
    }

    public void setDefaultPerspective(String perspectiveId) {
        this.m_defaultPerspective = perspectiveId;
    }

    public void setCurrentPerspective(String perspectiveId) {
        this.setCurrentPerspective(perspectiveId, false);
    }

    public String getCurrentPerspectiveName() {
        return this.m_currentPerspective;
    }

    private void setCurrentPerspectiveName(String name) {
        this.m_currentPerspective = "".equals(name) ? null : name;
    }

    public void setCurrentPerspective(String perspectiveId, boolean asDefault) {
        perspectiveId = perspectiveId == null ? this.m_defaultPerspective : perspectiveId;
        this.setCurrentPerspectiveName(perspectiveId);
        if (asDefault) {
            this.setDefaultPerspective(perspectiveId);
        }
    }

    public Perspective getDefaultPerspective() {
        return this.getPerspective(this.m_defaultPerspective);
    }

    public Perspective getCurrentPerspective() {
        return this.getPerspective(this.getCurrentPerspectiveName());
    }

    public DockingState getDockingState(Dockable dockable) {
        return this.getCurrentPerspective().getDockingState(dockable);
    }

    public DockingState getDockingState(String dockable) {
        return this.getCurrentPerspective().getDockingState(dockable);
    }

    public DockingState getDockingState(Dockable dockable, boolean load) {
        return this.getCurrentPerspective().getDockingState(dockable, load);
    }

    public DockingState getDockingState(String dockable, boolean load) {
        return this.getCurrentPerspective().getDockingState(dockable, load);
    }

    public FloatManager getFloatManager() {
        return this.getCurrentPerspective().getLayout();
    }

    public void reset() {
        RootWindow[] windows = DockingManager.getDockingWindows();
        if (windows.length != 0) {
            this.reset(windows[0].getRootContainer());
        }
    }

    public void reset(Component window) {
        if (window == null) {
            this.reset();
        } else {
            DockingPort port = DockingManager.getRootDockingPort(window);
            this.reset(port);
        }
    }

    public void reset(DockingPort rootPort) {
        this.loadPerspectiveImpl(this.getCurrentPerspectiveName(), rootPort, true);
    }

    public void reload(Window w) {
        this.reload(w, true);
    }

    public void reload(Window w, boolean reset) {
        String current = this.getCurrentPerspectiveName();
        String key = current == null ? this.m_defaultPerspective : current;
        this.setCurrentPerspectiveName(null);
        DockingPort port = DockingManager.getRootDockingPort(w);
        Perspective[] perspectives = this.getPerspectives();
        for (int i = 0; i < perspectives.length; ++i) {
            String id = perspectives[i].getPersistentId();
            if (id.equals(EMPTY_PERSPECTIVE) || !reset) continue;
            perspectives[i].getLayout().setRestorationLayout(null);
        }
        this.loadPerspectiveImpl(key, port, reset);
        if (!Utilities.isEqual(this.getCurrentPerspectiveName(), key)) {
            this.setCurrentPerspectiveName(current);
        }
    }

    public void restore(Window w) throws IOException, PersistenceException {
        this.reload(w, true);
        this.load();
        this.reload(w, false);
    }

    public void reload() {
        String current = this.getCurrentPerspectiveName();
        String key = current == null ? this.m_defaultPerspective : current;
        this.setCurrentPerspectiveName(null);
        this.loadPerspective(key);
        if (!Utilities.isEqual(this.getCurrentPerspectiveName(), key)) {
            this.setCurrentPerspectiveName(current);
        }
    }

    public void loadPerspective() {
        this.loadPerspective(this.m_defaultPerspective);
    }

    public void loadPerspectiveAsDefault(String perspectiveId) {
        this.loadPerspectiveAsDefault(perspectiveId, false);
    }

    public void loadPerspectiveAsDefault(String perspectiveId, boolean reset) {
        if (perspectiveId != null) {
            this.setDefaultPerspective(perspectiveId);
        }
        this.loadPerspective(perspectiveId, reset);
    }

    public void loadPerspective(String perspectiveId) {
        this.loadPerspective(perspectiveId, false);
    }

    public void loadPerspective(String perspectiveId, boolean reset) {
        RootWindow window = PerspectiveManager.getMainApplicationWindow();
        if (window != null) {
            this.loadPerspective(perspectiveId, window.getRootContainer(), reset);
            return;
        }
        DockingPort rootPort = this.findMainDockingPort();
        if (rootPort != null) {
            this.loadPerspective(perspectiveId, rootPort, reset);
        }
    }

    public void loadPerspective(String perspectiveId, Component window) {
        this.loadPerspective(perspectiveId, window, false);
    }

    public void loadPerspective(String perspectiveId, Component window, boolean reset) {
        if (window == null) {
            this.loadPerspective(perspectiveId, reset);
            return;
        }
        DockingPort port = DockingManager.getRootDockingPort(window);
        this.loadPerspective(perspectiveId, port, reset);
    }

    public void loadPerspective(String perspectiveId, DockingPort rootPort) {
        this.loadPerspective(perspectiveId, rootPort, false);
    }

    public void loadPerspective(String perspectiveId, DockingPort rootPort, boolean reset) {
        if (perspectiveId == null || perspectiveId.equals(this.getCurrentPerspectiveName())) {
            return;
        }
        this.loadPerspectiveImpl(perspectiveId, rootPort, reset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPerspectiveImpl(String perspectiveId, final DockingPort rootPort, boolean reset) {
        if (perspectiveId == null) {
            return;
        }
        Perspective current = this.getCurrentPerspective();
        final Perspective perspective = this.getPerspective(perspectiveId);
        if (current != null) {
            this.cacheLayoutState(current, rootPort);
            current.unload();
        }
        if (perspective == null) {
            return;
        }
        PerspectiveManager perspectiveManager = this;
        synchronized (perspectiveManager) {
            this.setCurrentPerspectiveName(perspectiveId);
            if (reset) {
                perspective.reset(rootPort);
                EventManager.dispatch(new PerspectiveEvent(perspective, current, 2));
            } else {
                perspective.load(rootPort);
                EventManager.dispatch(new PerspectiveEvent(perspective, current, 1));
            }
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                PerspectiveManager.this.cacheLayoutState(perspective, rootPort);
            }
        });
    }

    private void cacheLayoutState(Perspective p, DockingPort port) {
        if (p != null) {
            p.cacheLayoutState(port);
        }
    }

    public LayoutNode createLayout(DockingPort port) {
        return LayoutBuilder.getInstance().createLayout(port);
    }

    public boolean display(Dockable dockable) {
        return RestorationManager.getInstance().restore(dockable);
    }

    static void setDockingStateListening(boolean enabled) {
        UPDATE_LISTENER.setEnabled(enabled);
    }

    static boolean isDockingStateListening() {
        return UPDATE_LISTENER.isEnabled();
    }

    static void clear(DockingPort port) {
        if (port != null) {
            boolean currState = PerspectiveManager.isDockingStateListening();
            PerspectiveManager.setDockingStateListening(false);
            port.clear();
            PerspectiveManager.setDockingStateListening(currState);
        }
    }

    static void updateDockingStates(final Dockable[] dockables) {
        if (dockables == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                for (int i = 0; i < dockables.length; ++i) {
                    UPDATE_LISTENER.updateState(dockables[i]);
                }
            }
        });
    }

    public synchronized boolean store() throws IOException, PersistenceException {
        return this.store(null);
    }

    public synchronized boolean store(String persistenceKey) throws IOException, PersistenceException {
        if (this.m_persistHandler == null) {
            return false;
        }
        DockingPort rootPort = this.findMainDockingPort();
        return this.store(persistenceKey, rootPort);
    }

    public synchronized boolean store(String persistenceKey, DockingPort dockingPort) throws IOException, PersistenceException {
        if (this.m_persistHandler == null) {
            return false;
        }
        this.cacheLayoutState(this.getCurrentPerspective(), dockingPort);
        Perspective[] items = this.getPerspectives();
        for (int i = 0; i < items.length; ++i) {
            items[i] = (Perspective)items[i].clone();
        }
        PerspectiveModel info = new PerspectiveModel(this.m_defaultPerspective, this.getCurrentPerspectiveName(), items);
        String pKey = persistenceKey == null ? this.m_defaultPersistenceKey : persistenceKey;
        return this.m_persistHandler.store(pKey, info);
    }

    public synchronized boolean load() throws IOException, PersistenceException {
        return this.load(null);
    }

    public synchronized boolean load(String persistenceKey) throws IOException, PersistenceException {
        if (this.m_persistHandler == null) {
            return false;
        }
        String pKey = persistenceKey == null ? this.m_defaultPersistenceKey : persistenceKey;
        PerspectiveModel info = this.m_persistHandler.load(pKey);
        if (info == null) {
            return false;
        }
        Perspective[] perspectives = info.getPerspectives();
        this.m_perspectives.clear();
        for (int i = 0; i < perspectives.length; ++i) {
            this.add(perspectives[i]);
        }
        this.setDefaultPerspective(info.getDefaultPerspective());
        this.setCurrentPerspectiveName(info.getCurrentPerspective());
        return true;
    }

    public static boolean isRestoreFloatingOnLoad() {
        return PerspectiveManager.getInstance().restoreFloatingOnLoad;
    }

    public static void setRestoreFloatingOnLoad(boolean restoreFloatingOnLoad) {
        PerspectiveManager.getInstance().restoreFloatingOnLoad = restoreFloatingOnLoad;
    }

    public static RootWindow getMainApplicationWindow() {
        RootWindow[] windows = DockingManager.getDockingWindows();
        if (windows.length == 0) {
            windows = PerspectiveManager.resolveDockingWindows();
        }
        RootWindow window = null;
        for (int i = 0; i < windows.length && (window = windows[i]).getOwner() != null; ++i) {
        }
        return window;
    }

    private static RootWindow[] resolveDockingWindows() {
        Set rootPorts = DockingPortTracker.getRootDockingPorts();
        ArrayList<RootWindow> windows = new ArrayList<RootWindow>(rootPorts.size());
        Iterator it = rootPorts.iterator();
        while (it.hasNext()) {
            DockingPort port = (DockingPort)it.next();
            RootWindow window = RootWindow.getRootContainer((Component)((Object)port));
            if (window == null) continue;
            windows.add(window);
        }
        return windows.toArray(new RootWindow[0]);
    }

    public static DockingPort getMainDockingPort() {
        RootWindow window = PerspectiveManager.getMainApplicationWindow();
        return window == null ? null : DockingManager.getRootDockingPort(window.getRootContainer());
    }

    public boolean restore(boolean loadFromStorage) throws IOException, PersistenceException {
        boolean loaded = loadFromStorage ? this.load() : true;
        this.reload();
        return loaded;
    }

    public String getDefaultPersistenceKey() {
        return this.m_defaultPersistenceKey;
    }

    public void setDefaultPersistenceKey(String key) {
        this.m_defaultPersistenceKey = key;
    }

    private DockingPort findMainDockingPort() {
        Set rootPorts = DockingPortTracker.getRootDockingPorts();
        DockingPort rootPort = null;
        Iterator it = rootPorts.iterator();
        while (it.hasNext()) {
            DockingPort port = (DockingPort)it.next();
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)port));
            if (win instanceof Dialog) continue;
            rootPort = port;
            break;
        }
        return rootPort;
    }

    static {
        PerspectiveManager.initialize();
    }
}

