/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.validator;

import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.Grammar;
import com.sun.xml.bind.StringInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.zip.GZIPInputStream;

public class SchemaDeserializer {
    private static Grammar deserialize(InputStream is) {
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            final Expression exp = (Expression)ois.readObject();
            final ExpressionPool pool = (ExpressionPool)ois.readObject();
            ois.close();
            return new Grammar(){

                public Expression getTopLevel() {
                    return exp;
                }

                public ExpressionPool getPool() {
                    return pool;
                }
            };
        }
        catch (IOException e) {
            throw new InternalError(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public static Grammar deserialize(String str) {
        return SchemaDeserializer.deserialize(new StringInputStream(str));
    }

    public static Grammar deserializeCompressed(String str) {
        try {
            return SchemaDeserializer.deserialize(new GZIPInputStream(new StringInputStream(str)));
        }
        catch (IOException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

