/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.unmarshaller;

import java.util.Enumeration;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class DOMScanner {
    private Node currentNode = null;
    private final AttributesImpl atts = new AttributesImpl();
    private ContentHandler receiver = null;
    private static Locator dummyLocator = new Locator(){

        public int getColumnNumber() {
            return -1;
        }

        public int getLineNumber() {
            return -1;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return null;
        }
    };

    public void visit(Element e) throws SAXException {
        this.setCurrentLocation(e);
        NamedNodeMap attributes = e.getAttributes();
        this.atts.clear();
        int len = attributes.getLength();
        int i = len - 1;
        while (i >= 0) {
            Attr a = (Attr)attributes.item(i);
            String name = a.getName();
            if (name.equals("xmlns")) {
                this.receiver.startPrefixMapping("", a.getValue());
            } else if (name.startsWith("xmlns:")) {
                this.receiver.startPrefixMapping(a.getLocalName(), a.getValue());
            } else {
                String local;
                String uri = a.getNamespaceURI();
                if (uri == null) {
                    uri = "";
                }
                if ((local = a.getLocalName()) == null) {
                    local = a.getName();
                }
                this.atts.addAttribute(uri, local, a.getName(), "CDATA", a.getValue());
            }
            --i;
        }
        String uri = e.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        String local = e.getLocalName();
        String qname = e.getTagName();
        if (local == null) {
            local = qname;
        }
        this.receiver.startElement(uri, local, qname, this.atts);
        NodeList children = e.getChildNodes();
        int clen = children.getLength();
        int i2 = 0;
        while (i2 < clen) {
            this.visit(children.item(i2));
            ++i2;
        }
        this.setCurrentLocation(e);
        this.receiver.endElement(uri, local, qname);
        int i3 = len - 1;
        while (i3 >= 0) {
            Attr a = (Attr)attributes.item(i3);
            String name = a.getName();
            if (name.startsWith("xmlns:")) {
                this.receiver.endPrefixMapping(a.getLocalName());
            }
            --i3;
        }
    }

    public Node getCurrentLocation() {
        return this.currentNode;
    }

    private void setCurrentLocation(Node currNode) {
        this.currentNode = currNode;
    }

    private void visit(Node n) throws SAXException {
        this.setCurrentLocation(n);
        switch (n.getNodeType()) {
            case 3: 
            case 4: {
                String value = n.getNodeValue();
                this.receiver.characters(value.toCharArray(), 0, value.length());
                break;
            }
            case 1: {
                this.visit((Element)n);
                break;
            }
            case 5: {
                this.receiver.skippedEntity(n.getNodeName());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)n;
                this.receiver.processingInstruction(pi.getTarget(), pi.getData());
            }
        }
    }

    private void buildNamespaceSupport(NamespaceSupport nss, Node node) {
        if (!(node instanceof Element)) {
            return;
        }
        this.buildNamespaceSupport(nss, node.getParentNode());
        nss.pushContext();
        NamedNodeMap atts = ((Element)node).getAttributes();
        int i = 0;
        while (i < atts.getLength()) {
            Attr a = (Attr)atts.item(i);
            if ("xmlns".equals(a.getPrefix())) {
                nss.declarePrefix(a.getLocalName(), a.getValue());
            } else if ("xmlns".equals(a.getName())) {
                nss.declarePrefix("", a.getValue());
            }
            ++i;
        }
    }

    public void parse(Element e, ContentHandler handler) throws SAXException {
        this.receiver = handler;
        this.setCurrentLocation(e);
        handler.startDocument();
        handler.setDocumentLocator(dummyLocator);
        this.visit(e);
        this.setCurrentLocation(e);
        handler.endDocument();
    }

    public void parseWithContext(Element e, ContentHandler handler) throws SAXException {
        this.receiver = handler;
        this.setCurrentLocation(e);
        handler.startDocument();
        handler.setDocumentLocator(dummyLocator);
        NamespaceSupport nss = new NamespaceSupport();
        this.buildNamespaceSupport(nss, e.getParentNode());
        Enumeration<String> en = nss.getPrefixes();
        while (en.hasMoreElements()) {
            String prefix = en.nextElement();
            handler.startPrefixMapping(prefix, nss.getURI(prefix));
        }
        this.visit(e);
        Enumeration<String> en2 = nss.getPrefixes();
        while (en2.hasMoreElements()) {
            String prefix = en2.nextElement();
            handler.endPrefixMapping(prefix);
        }
        this.setCurrentLocation(e);
        handler.endDocument();
    }
}

