// -*- mode: c++; c-set-style: "stroustrup"; tab-width: 4; -*-
//
// CFile.h
//
// Copyright (C) 2004 Koji Nakamaru
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef _CFile_h_
#define _CFile_h_

class CFile {
public:
	CFile();
	virtual ~CFile();
	bool open(char *name);
	void close();
	bool stat(struct stat *sbuf);
	char *gets(char *buf, size_t len);
	int getc();
	size_t read(void *buf, size_t len);
	bool seek(size_t pos);
	size_t tell();

protected:
	enum {
		kFileNone = 0,
		kFileStdIn,
		kFileBZ,
		kFileGZ,
		kFileXZ,
		kFileUZ,
	} _type;
	void *_fp;
	char *_stream;
	char _buf[4096];
	char _name[PATH_MAX];
	size_t _pos;
};

#endif
