// -*- mode: c++; c-set-style: "stroustrup"; tab-width: 4; -*-
//
// error.c
//
// Copyright (C) 2004 Koji Nakamaru
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <cstdarg>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include "error.h"

static char *_progname = NULL;

void setProgname(char *progname)
{
	if ((_progname = strrchr(progname, '/')) == NULL) {
		if ((_progname = strrchr(progname, '\\')) == NULL) {
			_progname = strrchr(progname, ':');
		}
	}
	_progname = (_progname != NULL) ? _progname + 1 : progname;
}

const char *progname()
{
	return _progname;
}

void message(char *format, ...)
{
	va_list ap;

	va_start(ap, format);
	if (_progname) {
		fprintf(stderr, "%s: ", _progname);
	}
	vfprintf(stderr, format, ap);
	fprintf(stderr, "\n");
	va_end(ap);
}

void error(char *format, ...)
{
	va_list ap;

	va_start(ap, format);
	if (_progname) {
		fprintf(stderr, "%s: ", _progname);
	}
	vfprintf(stderr, format, ap);
	fprintf(stderr, "\n");
	va_end(ap);
	exit(1);
}
