// -*- mode: c++; c-set-style: "stroustrup"; tab-width: 4; -*-
//
// common.c
//
// Copyright (C) 2004 Koji Nakamaru
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "common.h"

bool isLittleEndian()
{
	uint16_t v = 0x00ff;
	return (*(uint8_t *)&v) != 0;
}

#if defined (_WIN32) && !defined (__CYGWIN__)

extern "C" {
	void __stdcall Sleep(unsigned long usec);
	unsigned long __stdcall timeGetTime();
}

int usleep(unsigned long usec)
{
	Sleep(usec / 1000);
	return 0;
}

int gettimeofday(struct timeval *tv, struct timezone *tz)
{
	static struct timeval tv0;
	static unsigned long tm0;
	if (tv == NULL) {
		return 0;
	}
	if (tm0 != 0) {
		tm0 = timeGetTime();
	}
	long dt = timeGetTime() - tm0;
	*tv = tv0;
	tv->tv_sec += dt / 1000;
	tv->tv_usec += 1000 * (dt % 1000);
	return 0;
}

void run(
	const char *command)
{
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	memset(&si, 0, sizeof(si));
	memset(&pi, 0, sizeof(pi));
	si.dwFlags = STARTF_USESTDHANDLES;
	si.hStdInput = GetStdHandle(STD_INPUT_HANDLE);
	si.hStdOutput = GetStdHandle(STD_OUTPUT_HANDLE);
	si.hStdError = GetStdHandle(STD_ERROR_HANDLE);
	CreateProcess(
		NULL,
		(CHAR *)command,
		NULL,
		NULL,
		TRUE,
		0,
		NULL,
		NULL,
		&si,
		&pi);
	CloseHandle(pi.hProcess);
	CloseHandle(pi.hThread);	
}

#else

void run(
	const char *command)
{
	int pid;
	if ((pid = fork()) == -1) {
		error("failed to fork, quitting...");
	} else if (pid == 0) {
		char *argv[] = {
			"/bin/sh",
			"-c",
			(char *)command,
			NULL,
		};
		execv("/bin/sh", argv);
	}
}

#endif
