// --------------------------------------------------------------------
//       A g e . c p p
//                                                                     
//        Fido messages tracker                            
//        Age support
// --------------------------------------------------------------------
//        Copyright (c) 1998-2000 by Fyodor Ustinov                         
//                                FIDONet 2:5020/79                      
//                                                                     
//        All rights reserved.                                         
// --------------------------------------------------------------------
#ifndef UNIX
#include <io.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "constant.hpp"
#include "help.hpp"
#include "utils.hpp"
#include "vars.hpp"
#include "configure.hpp"
#include "scandir.hpp"
#include "age.hpp"
#include "ufmtypes.h"

// --------------------------------------------------------------------
// --------------------------------------------------------------------

int AgeIsOver(time_t D, uint MAge) {
   return (AgeIs(D) > (int) MAge);
}

int AgeIs(time_t D) {
time_t t;

   t = time(NULL);
   if (D == 0) return 0;
   if (t < D) return 0;
   return ((t - D) / (60 * 60 * 24));
}
// --------------------------------------------------------------------

int SetMaxAge(int tmt) {
IndBiList<ScanDir>::ElemPtr sd;

   sd = ScanDirs.GetLast();
   if (sd == NULL) {
      if (MaxAge != 0) {
         yyerror("Global MaxAge already defined.");
         return (-1);
      }
   } else {
      if (sd->_MaxAge != 0) {
         yyerror("MaxAge for this ScanDir already defined.");
         return (-1);
      }
   }
   if (tmt < 1 || tmt > 65535) {
      yyerror("Parameter must be a number between 1 and 65535.");
      return (-1);
   }
   if (sd != NULL) {
      sd->_MaxAge = tmt;
   } else {
      MaxAge = tmt;
   }
   return 0;
}



// ---------------------------- END --------------------------------------
