#ifndef _CONST_HPP_
#define _CONST_HPP_

#if !defined(__OS2__) && defined(__EMX__)
#define __OS2__
#endif

#ifdef __NT__
#define OsType         "/W32"
#define PATHDELIMS     "\\"
#define PATHDELIMC     '\\'
#elif defined(__OS2__)
#define OsType         "/OS2"
#define PATHDELIMS     "\\"
#define PATHDELIMC     '\\'
#elif defined(__DJGPP__) || defined(__DOS4G__)
#define OsType         "/386"
#define PATHDELIMS     "\\"
#define PATHDELIMC     '\\'
#elif defined(UNIX)
#   ifdef __LINUX__
#      define OsType      "/LNX"
#   elif defined(__FreeBSD__)
#      define OsType      "/FBSD"
#   elif defined(sun)
#      define OsType      "/SUN"
#   elif defined(_AIX)
#      define OsType      "/AIX"
#   else
#      define OsType      "/Unix"
#   endif
#define PATHDELIMS     "/"
#define PATHDELIMC     '/'
#endif
#define FVersion       "3.1"OsType
#define RevisionHI     3
#define RevisionLO     1
#define FTrackProductLo 0xff
#define FTrackProductHi 0x0c
#define Copyright      "(C) 1998-2002 Fyodor Ustinov (2:5020/79)"
#define DefaultConfig  "ftrack.cfg"

#ifdef UNIX
#define MsgExtension   ".msg"
#define PktExtension   ".pkt"
#define BsyExtension   ".bsy"
#define PntExtension   ".pnt"
#else
#define MsgExtension   ".MSG"
#define PktExtension   ".PKT"
#define BsyExtension   ".BSY"
#define PntExtension   ".PNT"
#endif

#define MAXCFGLINE     4096
#define DELIMETERS     " \t"
#define STRDELIMETERS  "\t\""
#define FICL_SIZE      10000
#define MAXPOINTS      1024

#define LOGE           100
#define LOGW           101
#define LOGI           102
#define LOGD           105

#endif
