/*--------------------------------------------------------------------*/
/*       C o n f i g u r e . h p p                                    */
/*                                                                    */
/*       Configuration routine for FTrack                             */
/*--------------------------------------------------------------------*/
/*       Copyright (c) 2000 by Fyodor Ustinov                         */
/*                          FIDONet 2:5020/79                         */
/*                                                                    */
/*       All rights reserved.                                         */
/*--------------------------------------------------------------------*/
#ifndef _CONFIGURE_HPP_
#define _CONFIGURE_HPP_

typedef enum {LEX_START, LEX_PARSE, LEX_DIGIT, LEX_COMMENT, LEX_STRING,
              LEX_CRLF, LEX_END, LEX_TOKEN, LEX_ERROR, LEX_COMMLINE} tLexState;


int ParseConfig(char *CfgFile);
#undef yyerror
int yyerror(char *s);
int yylex(void);

extern int avail;

int SetMyAddr(FA &f);
int SetLogFile(char *tmt);
int SetTimeStampFile(char *tmt);
int SetLogLevel(int tmt);
int SetCreateMissingBase(void);
int SetForceINTL(void);
int SetNoLogIgnore(void);
int SetSetViaAlways(void);
int SetMaxAttach(int tmt);
int SetLoopStr(char *tmt);
int SetOrigin(char *tmt);
int SetSysopName(char *tmt);
int SetTearline(char *tmt);
int SetNewVia(void);
int SetUseOwnZone(void);
int SetUseASO(void);
int SetSoftCheckInNodelists(void);
int SetAPktDir(char *tmt);
int SetCheckPoints(CheckPointsT pmode);
int SetNodelistPath(char *tmt);
int SetIndexFile(char *tmt);
int SetUTC(int i);
int SetInclude(char *tmt);
int SetSemaphoreName(char *File, unsigned int SemTime);
int SetTrafficLogTemplate(char *tmt);
int SetIgnoreBSY(void);
int LoadScriptFile(char *Fname);
int SetStripPathInPkt(void);
#endif
