/*
 * Decompiled with CFR 0.152.
 */
package uk.org.skeet.png;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Vector;

public class Palette {
    Vector colours = new Vector();
    int transparentIndex;
    private ColourEntry[][][] ces = new ColourEntry[256][][];

    public Palette(BufferedImage[] images, Color[] extraColours, int size, boolean wantTransparent) {
        int i;
        Hashtable<Integer, ColourEntry> tempHash = new Hashtable<Integer, ColourEntry>();
        ColourEntry transparent = new ColourEntry();
        if (wantTransparent) {
            transparent.population = 0;
            transparent.argb = 0;
            this.colours.addElement(transparent);
            this.transparentIndex = 0;
        } else {
            this.transparentIndex = -1;
        }
        int imagePop = 0;
        int k = 0;
        while (k < images.length) {
            BufferedImage image = images[k];
            int w = image.getWidth();
            int h = image.getHeight();
            int[] row = new int[w];
            imagePop += h * w;
            i = 0;
            while (i < h) {
                image.getRGB(0, i, w, 1, row, 0, w);
                int j = 0;
                while (j < w) {
                    int col = row[j];
                    Integer x = new Integer(col);
                    ColourEntry ce = (ColourEntry)tempHash.get(x);
                    if (ce == null) {
                        if (col >>> 24 != 255) {
                            ce = transparent;
                        } else {
                            ce = new ColourEntry();
                            ce.argb = col;
                            ce.population = 0;
                            this.colours.add(ce);
                        }
                        tempHash.put(x, ce);
                    }
                    ++ce.population;
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        if (extraColours != null) {
            int i2 = 0;
            while (i2 < extraColours.length) {
                int col = extraColours[i2].getRGB();
                Integer x = new Integer(col);
                ColourEntry ce = (ColourEntry)tempHash.get(x);
                if (ce == null) {
                    if (col >>> 24 != 255) {
                        ce = transparent;
                    } else {
                        ce = new ColourEntry();
                        ce.argb = col;
                        ce.population = 0;
                        this.colours.add(ce);
                    }
                    tempHash.put(x, ce);
                }
                ce.population += imagePop / extraColours.length;
                ++i2;
            }
        }
        while (this.colours.size() > size) {
            int l = this.colours.size();
            ColourEntry minCe = (ColourEntry)this.colours.elementAt(1);
            int minPop = minCe.population;
            int minIndex = 1;
            i = 2;
            while (i < l) {
                ColourEntry ce = (ColourEntry)this.colours.elementAt(i);
                if (ce.population < minPop) {
                    minPop = ce.population;
                    minCe = ce;
                    minIndex = i;
                }
                ++i;
            }
            int closeIndex = 1;
            if (minIndex == 1) {
                closeIndex = 2;
            }
            ColourEntry closeCe = (ColourEntry)this.colours.elementAt(closeIndex);
            int closeDiff = closeCe.compare(minCe);
            int i3 = closeIndex + 1;
            while (i3 < l) {
                ColourEntry ce;
                int diff;
                if (i3 != minIndex && (diff = (ce = (ColourEntry)this.colours.elementAt(i3)).compare(minCe)) < closeDiff) {
                    closeDiff = diff;
                    closeCe = ce;
                    closeIndex = i3;
                }
                ++i3;
            }
            int totalPop = closeCe.population + minCe.population;
            closeCe.setRed((closeCe.getRed() * closeCe.population + minCe.getRed() * minCe.population) / totalPop);
            closeCe.setGreen((closeCe.getGreen() * closeCe.population + minCe.getGreen() * minCe.population) / totalPop);
            closeCe.setBlue((closeCe.getBlue() * closeCe.population + minCe.getBlue() * minCe.population) / totalPop);
            closeCe.population = totalPop;
            minCe.follow = closeCe;
            this.colours.removeElementAt(minIndex);
        }
        if (wantTransparent) {
            ColourEntry ce;
            int argb = -1;
            while ((ce = (ColourEntry)tempHash.get(new Integer(argb))) != null) {
                --argb;
            }
            transparent.argb = argb & 0xFFFFFF;
        }
        int i4 = 0;
        while (i4 < this.colours.size()) {
            ColourEntry ce = (ColourEntry)this.colours.elementAt(i4);
            ce.index = i4++;
            this.hashPut(ce.argb, ce);
        }
    }

    public Palette(BufferedImage image, int size, boolean wantTransparent) {
        this(new BufferedImage[]{image}, null, size, wantTransparent);
    }

    public int getRed(int index) {
        return ((ColourEntry)this.colours.elementAt(index)).getRed();
    }

    public int getGreen(int index) {
        return ((ColourEntry)this.colours.elementAt(index)).getGreen();
    }

    public int getBlue(int index) {
        return ((ColourEntry)this.colours.elementAt(index)).getBlue();
    }

    public int getSize() {
        return this.colours.size();
    }

    public int getTransparentIndex() {
        return this.transparentIndex;
    }

    public byte[] getIndices(int[] argbs, int offset, int length) {
        byte[] ret = new byte[length];
        int index = offset;
        int l = 0;
        while (l < length) {
            ret[l] = (byte)this.getIndex(argbs[index]);
            ++index;
            ++l;
        }
        return ret;
    }

    public int getIndex(int argb) {
        if (argb >>> 24 != 255 && this.transparentIndex != -1) {
            return this.transparentIndex;
        }
        ColourEntry ce = this.hashGet(argb);
        if (ce == null) {
            int minIndex = 0;
            int minDiff = Integer.MAX_VALUE;
            int i = 0;
            while (i < this.colours.size()) {
                ColourEntry entry;
                int diff;
                if (i != this.transparentIndex && (diff = (entry = (ColourEntry)this.colours.elementAt(i)).compare(argb)) < minDiff) {
                    minDiff = diff;
                    minIndex = i;
                }
                ++i;
            }
            ce = (ColourEntry)this.colours.elementAt(minIndex);
            this.hashPut(argb, ce);
        }
        return ce.index;
    }

    private ColourEntry hashGet(int argb) {
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        if (this.ces[red] == null || this.ces[red][green] == null) {
            return null;
        }
        return this.ces[red][green][blue];
    }

    private void hashPut(int argb, ColourEntry ce) {
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        if (this.ces[red] == null) {
            this.ces[red] = new ColourEntry[256][];
        }
        if (this.ces[red][green] == null) {
            this.ces[red][green] = new ColourEntry[256];
        }
        this.ces[red][green][blue] = ce;
    }

    private static class ColourEntry {
        int population;
        int argb;
        ColourEntry follow = null;
        int index;

        private ColourEntry() {
        }

        int compare(ColourEntry ce) {
            int x = this.argb;
            int y = ce.argb;
            int ret = 0;
            int i = 0;
            while (i < 3) {
                int dist = (x & 0xFF) - (y & 0xFF);
                ret += dist * dist;
                x >>>= 8;
                y >>>= 8;
                ++i;
            }
            return ret;
        }

        int compare(int y) {
            int x = this.argb;
            int ret = 0;
            int i = 0;
            while (i < 3) {
                int dist = (x & 0xFF) - (y & 0xFF);
                ret += dist * dist;
                x >>>= 8;
                y >>>= 8;
                ++i;
            }
            return ret;
        }

        int getRed() {
            return this.argb >> 16 & 0xFF;
        }

        int getBlue() {
            return this.argb & 0xFF;
        }

        int getGreen() {
            return this.argb >> 8 & 0xFF;
        }

        void setRed(int red) {
            this.argb = this.argb & 0xFF00FFFF | red << 16;
        }

        void setGreen(int green) {
            this.argb = this.argb & 0xFFFF00FF | green << 8;
        }

        void setBlue(int blue) {
            this.argb = this.argb & 0xFFFFFF00 | blue;
        }
    }
}

