/*
 * Decompiled with CFR 0.152.
 */
package ftjava.util;

import ftjava.util.GameOptions;
import java.util.Random;

public class Dice {
    private int faces;
    private static boolean isTestMode;
    private static Random generator;
    private static int index;
    private static int[] testSequence;
    public static final Dice D2;
    public static final Dice D4;
    public static final Dice D6;
    public static final Dice D8;
    public static final Dice D10;
    public static final Dice D12;
    public static final Dice D20;
    public static final Dice D100;

    public static int rollD6() {
        if (GameOptions.getTestingMode()) {
            if (testSequence != null && index < testSequence.length) {
                return testSequence[index++];
            }
            return (int)Math.round(GameOptions.getTestRandom() * 6.0 + 0.5);
        }
        return (int)Math.round(Math.random() * 6.0 + 0.5);
    }

    public static int rollD6(String crewQuality) {
        if (GameOptions.getTestingMode()) {
            if (testSequence != null && index < testSequence.length) {
                return testSequence[index++];
            }
            return (int)Math.round(GameOptions.getTestRandom() * 6.0 + 0.5);
        }
        int roll = 1;
        if (crewQuality.equals("Elite")) {
            roll = (int)Math.round(Math.random() * 5.0 + 0.5) + 1;
        }
        if (crewQuality.equals("First Rate")) {
            roll = (int)Math.round(Math.random() * 6.0 + 0.5);
        }
        if (crewQuality.equals("Second Rate")) {
            roll = (int)Math.round(Math.random() * 8.0 + 0.5) - 2;
        }
        if (crewQuality.equals("Third Rate")) {
            roll = (int)Math.round(Math.random() * 10.0 + 0.5) - 4;
        }
        if (crewQuality.equals("Civilian")) {
            roll = (int)Math.round(Math.random() * 12.0 + 0.5) - 6;
        }
        if (roll <= 0) {
            roll = 1;
        }
        return roll;
    }

    public static void resetIndex() {
        index = 0;
    }

    public static void setTestSequence(int[] array) {
        testSequence = array;
        Dice.resetIndex();
    }

    public static int rollD(int size) {
        double die_size = size;
        if (GameOptions.getTestingMode()) {
            return (int)Math.round(GameOptions.getTestRandom() * die_size + 0.5);
        }
        return (int)Math.round(Math.random() * die_size + 0.5);
    }

    public static int roll2D6() {
        return Dice.rollD6() + Dice.rollD6();
    }

    public static int rollD4() {
        return Dice.rollD(4);
    }

    public static int rollD8() {
        return Dice.rollD(8);
    }

    public static int rollD10() {
        return Dice.rollD(10);
    }

    public static int rollD12() {
        return Dice.rollD(12);
    }

    public static int rollD20() {
        return Dice.rollD(20);
    }

    public static int rollD100() {
        return Dice.rollD(100);
    }

    public static int flipCoin() {
        if (GameOptions.getTestingMode()) {
            return (int)Math.round(GameOptions.getTestRandom());
        }
        return (int)Math.round(Math.random());
    }

    public static int makeKey() {
        if (GameOptions.getTestingMode()) {
            GameOptions.getTestRandom();
            GameOptions.getTestRandom();
            return (int)Math.round(100000.0 + 899999.0 * GameOptions.getTestRandom());
        }
        Math.random();
        Math.random();
        return (int)Math.round(100000.0 + 899999.0 * Math.random());
    }

    public Dice(int numSides) {
        if (generator == null) {
            generator = new Random(System.currentTimeMillis());
            isTestMode = GameOptions.getTestingMode();
            if (isTestMode) {
                generator.setSeed(12161958L);
            }
        }
        this.faces = numSides;
    }

    public int roll() {
        if (isTestMode != GameOptions.getTestingMode()) {
            boolean bl = isTestMode = !isTestMode;
            if (isTestMode) {
                generator.setSeed(12161958L);
            } else {
                generator.setSeed(System.currentTimeMillis());
            }
        }
        return generator.nextInt(this.faces) + 1;
    }

    public void roll(int[] dice) {
        for (int i = 0; i < dice.length; ++i) {
            dice[i] = this.roll();
        }
    }

    static {
        generator = null;
        index = 0;
        D2 = new Dice(2);
        D4 = new Dice(4);
        D6 = new Dice(6);
        D8 = new Dice(8);
        D10 = new Dice(10);
        D12 = new Dice(12);
        D20 = new Dice(20);
        D100 = new Dice(100);
    }
}

