/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std.variant;

import ftjava.std.BeamBattery;
import ftjava.std.GameEngine;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;

public class HeavyBeamBattery
extends BeamBattery {
    public HeavyBeamBattery() {
        this(2, Weapon.ALL_ARCS);
    }

    public HeavyBeamBattery(int beamClass) {
        this(beamClass, Weapon.ALL_ARCS);
    }

    public HeavyBeamBattery(int beamClass, String arcString) {
        this(beamClass, Weapon.parseArcString(arcString));
    }

    public HeavyBeamBattery(int beamClass, int arcCoverage) {
        this.rating = beamClass;
        this.setArcs(arcCoverage);
        this.setSystemName("Class " + this.rating + " Heavy Beam Battery " + this.getArcsString());
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setMaximumRange((double)(this.rating - 1) * this.getOptions().getBeamRangeBand());
    }

    public void setValue(String Name, String Value) {
        boolean handled = false;
        if (Name.equals("rating")) {
            this.rating = Integer.parseInt(Value);
            this.setMaximumRange((double)(this.rating - 1) * this.getOptions().getBeamRangeBand());
            this.setSystemName("Class " + this.rating + " Heavy Beam Battery " + this.getArcsString());
            handled = true;
        }
        if (!handled) {
            super.setValue(Name, Value);
        }
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
        if (!this.isRecharged()) {
            this.setNotes("Weapon is recharging.");
            return;
        }
        if (!this.getSystemStatus().equals("Operational")) {
            return;
        }
        if (!(target instanceof Ship)) {
            return;
        }
        if (!this.fireAtTargetArc(firer.arcTo(target))) {
            return;
        }
        this.fireAtDirectFire(firer, target);
    }

    private void fireAtDirectFire(SpaceObject firer, SpaceObject target) {
        String record;
        Ship s;
        int[] damage = new int[1];
        DecimalFormat df = new DecimalFormat("0.0");
        int rerolls = 0;
        int penetration = 0;
        int screens = 0;
        double rangeBand = this.getOptions().getBeamRangeBand();
        if (target instanceof Ship) {
            s = (Ship)target;
            screens = s.getNumberOfActiveScreens();
        }
        double range = firer.rangeTo(target) * target.getRangeStealthModifier();
        int dice = this.rating - 1;
        for (int i = 1; i < this.rating; ++i) {
            if (!(range > (double)i * rangeBand)) continue;
            --dice;
        }
        String targetName = target.getName();
        this.setFired();
        boolean hit = false;
        boolean deflected = false;
        String playTestResults = " R=" + df.format(firer.rangeTo(target)) + "/" + df.format(range);
        while (dice > 0) {
            for (int i = 0; i < dice; ++i) {
                int die = Dice.rollD6();
                playTestResults = playTestResults + "(" + die + ") ";
                int passingDamage = die - 2;
                if (passingDamage > 0) {
                    if ((passingDamage -= screens) > 0) {
                        int n = penetration;
                        damage[n] = damage[n] + passingDamage;
                        hit = true;
                    } else {
                        deflected = true;
                    }
                }
                if (die != 6) continue;
                ++rerolls;
            }
            if (rerolls > 0 && this.getOptions().getPenetratingDamage()) {
                dice = rerolls;
                rerolls = 0;
                screens = 0;
                int[] temp = new int[++penetration + 1];
                System.arraycopy(damage, 0, temp, 0, damage.length);
                damage = temp;
                continue;
            }
            dice = 0;
        }
        if (!hit) {
            String record2;
            if (deflected) {
                if (this.getOptions().getPlayTest()) {
                    this.setNotes("Deflected by " + targetName + "'s shielding. " + playTestResults);
                    record2 = firer.getName() + " hit, but deflected with a class " + this.getRating() + " heavy beam battery. " + playTestResults;
                } else {
                    this.setNotes("Deflected by " + targetName + "'s shielding.");
                    record2 = firer.getName() + " hit, but deflected with a class " + this.getRating() + " heavy beam battery.";
                }
            } else if (this.getOptions().getPlayTest()) {
                this.setNotes("Missed the " + targetName + ". " + playTestResults);
                record2 = firer.getName() + " missed with a class " + this.getRating() + " heavy beam battery. " + playTestResults;
            } else {
                this.setNotes("Missed the " + targetName + ".");
                record2 = firer.getName() + " missed with a class " + this.getRating() + " heavy beam battery.";
            }
            target.addLog("Attack", "Medium", record2);
            return;
        }
        int totalDamage = 0;
        for (int i = 0; i < damage.length; ++i) {
            totalDamage += damage[i];
        }
        if (this.getOptions().getPlayTest()) {
            this.setNotes("Hit the " + targetName + " for " + StringUtils.number(damage[0]) + " armor and " + StringUtils.number(totalDamage - damage[0]) + " hull points. " + playTestResults);
            record = firer.getName() + " hit for " + StringUtils.points(totalDamage) + " with a class " + this.getRating() + " heavy beam battery. " + playTestResults;
        } else {
            this.setNotes("Hit the " + targetName + " for " + StringUtils.points(totalDamage) + ".");
            record = firer.getName() + " hit for " + StringUtils.points(totalDamage) + " with a class " + this.getRating() + " heavy beam battery.";
        }
        target.addLog("Attack", "High", record);
        if (totalDamage >= 6 * this.rating) {
            GameEngine ge = firer.getGameEngine();
            record = firer.getName() + " hit " + target.getName() + " for " + StringUtils.points(totalDamage) + " with a class " + this.getRating() + " heavy beam battery.";
            ge.addTurnReport("Attack", "High", record);
        }
        s = (Ship)target;
        s.takeDamage(damage);
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String s = "";
        String t = XMLUtilities.getIndent();
        String newLine = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        if (level >= 6) {
            return s;
        }
        sb.append(t);
        sb.append(t);
        sb.append("<HeavyBeamBattery");
        if (level > 0) {
            sb.append(" id=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" rating=\"");
        sb.append(this.rating);
        sb.append("\" arcs=\"");
        sb.append(this.getArcsString());
        sb.append("\"");
        if (level != 0 && level != 5) {
            sb.append(" status=\"");
            sb.append(this.getSystemStatus());
            sb.append("\"");
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"");
            sb.append(this.getNotes());
            sb.append("\"");
        }
        sb.append("/>");
        sb.append(newLine);
        return sb.toString();
    }

    static {
        Weapon.addSystem("HeavyBeamBattery", new HeavyBeamBattery());
    }
}

