/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std.importer;

import ftjava.std.victoryconditions.ShipFilter;
import ftjava.std.victoryconditions.VictoryCondition;
import ftjava.util.XMLUtilities;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportVictoryCondition {
    public static void setParameters(VictoryCondition condition, Node node) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node tempnode = attrs.item(i);
                condition.parameters.put(tempnode.getNodeName(), tempnode.getNodeValue());
            }
        }
    }

    public static VictoryCondition parseVictoryCondition(Node node) throws Exception {
        VictoryCondition condition;
        String name = node.getNodeName();
        try {
            Class<?> c = Class.forName("ftjava.std.victoryconditions." + name);
            if (c == null) {
                throw new Exception("Could not find VictoryCondition class: " + name);
            }
            condition = (VictoryCondition)c.newInstance();
        }
        catch (Exception e) {
            throw new Exception("Could not create VictoryCondition: " + name);
        }
        ImportVictoryCondition.setParameters(condition, node);
        ImportVictoryCondition.parseVictoryCondition(condition, node);
        return condition;
    }

    public static void parseVictoryCondition(VictoryCondition condition, Node topnode) throws Exception {
        NodeList topchildren = topnode.getChildNodes();
        if (topchildren == null) {
            return;
        }
        for (int j = 0; j < topchildren.getLength(); ++j) {
            NodeList children;
            Node node = topchildren.item(j);
            String name = node.getNodeName();
            if (name.equals("Children") && (children = node.getChildNodes()) != null) {
                int length = children.getLength();
                for (int i = 0; i < length; ++i) {
                    condition.addChild(ImportVictoryCondition.parseVictoryCondition(children.item(j)));
                }
            }
            if (!name.equals("Filter")) continue;
            ImportVictoryCondition.handleFilter(condition, node);
        }
    }

    public static void handleFilter(VictoryCondition condition, Node node) {
        ShipFilter filter = new ShipFilter();
        filter.setMatchShips();
        if (XMLUtilities.attributeExists(node, "Team")) {
            filter.setMatchTeam(XMLUtilities.getAttribute(node, "Team"));
        }
        if (XMLUtilities.attributeExists(node, "Player")) {
            filter.setMatchPlayer(XMLUtilities.getAttribute(node, "Player"));
        }
        condition.addFilter(filter);
        NodeList children = node.getChildNodes();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("Id")) continue;
            filter.addShipToMatch(child.getFirstChild().getNodeValue());
        }
    }
}

