/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std.importer;

import ftjava.std.AntiMatterTorpedo;
import ftjava.std.FighterGroup;
import ftjava.std.FighterOrders;
import ftjava.std.HeavenlyBody;
import ftjava.std.LogRecord;
import ftjava.std.Missile;
import ftjava.std.MissileSalvo;
import ftjava.std.NovaCannonBolt;
import ftjava.std.PlasmaBolt;
import ftjava.std.SpaceObject;
import ftjava.std.WaveGunBolt;
import ftjava.util.XMLUtilities;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportSpaceObject {
    public static SpaceObject getMissile(Node node) {
        Missile ms = new Missile();
        ImportSpaceObject.parseMissile(ms, node);
        return ms;
    }

    public static SpaceObject getMissileSalvo(Node node) {
        MissileSalvo ms = new MissileSalvo();
        ImportSpaceObject.parseMissileSalvo(ms, node);
        return ms;
    }

    public static SpaceObject getPlasmaBolt(Node node) {
        PlasmaBolt pb = new PlasmaBolt();
        ImportSpaceObject.parsePlasmaBolt(pb, node);
        return pb;
    }

    public static SpaceObject getNovaCannonBolt(Node node) {
        NovaCannonBolt nc = new NovaCannonBolt();
        ImportSpaceObject.parseNovaCannonBolt(nc, node);
        return nc;
    }

    public static SpaceObject getWaveGunBolt(Node node) {
        WaveGunBolt wgb = new WaveGunBolt();
        ImportSpaceObject.parseWaveGunBolt(wgb, node);
        return wgb;
    }

    public static SpaceObject getAntiMatterTorpedo(Node node) {
        AntiMatterTorpedo amt = new AntiMatterTorpedo();
        ImportSpaceObject.parseAntiMatterTorpedo(amt, node);
        return amt;
    }

    public static SpaceObject getFighterGroup(Node node) {
        FighterGroup fg = new FighterGroup();
        ImportSpaceObject.parseFighterGroup(fg, node);
        return fg;
    }

    public static SpaceObject getHeavenlyBody(Node node) {
        HeavenlyBody hb = new HeavenlyBody();
        ImportSpaceObject.parseHeavenlyBody(hb, node);
        return hb;
    }

    public static void parseMissile(Missile object, Node node) {
        NodeList children;
        String name = node.getNodeName();
        if (name.equals("Missile")) {
            if (XMLUtilities.attributeExists(node, "id")) {
                object.setId((int)XMLUtilities.getNumericAttribute(node, "id"));
            }
            if (XMLUtilities.attributeExists(node, "shipId")) {
                object.setLaunchingShipId((int)XMLUtilities.getNumericAttribute(node, "shipId"));
            }
            if (XMLUtilities.attributeExists(node, "launcherId")) {
                object.setLauncherId((int)XMLUtilities.getNumericAttribute(node, "launcherId"));
            }
            if (XMLUtilities.attributeExists(node, "targetId")) {
                object.setTargetId((int)XMLUtilities.getNumericAttribute(node, "targetId"));
            }
            if (XMLUtilities.attributeExists(node, "type")) {
                object.setType(XMLUtilities.getAttribute(node, "type"));
                object.setName();
            }
            if (XMLUtilities.attributeExists(node, "x")) {
                object.setXPosition(XMLUtilities.getNumericAttribute(node, "x"));
            }
            if (XMLUtilities.attributeExists(node, "y")) {
                object.setYPosition(XMLUtilities.getNumericAttribute(node, "y"));
            }
            if (XMLUtilities.attributeExists(node, "heading")) {
                object.setHeading((int)XMLUtilities.getNumericAttribute(node, "heading"));
            }
            if (XMLUtilities.attributeExists(node, "move")) {
                object.setMove((int)XMLUtilities.getNumericAttribute(node, "move"));
            }
            if (XMLUtilities.attributeExists(node, "turn")) {
                object.setTurn((int)XMLUtilities.getNumericAttribute(node, "turn"));
            }
            if (XMLUtilities.attributeExists(node, "endurance")) {
                object.setEndurance((int)XMLUtilities.getNumericAttribute(node, "endurance"));
            }
            object.setName();
        }
        if ((children = node.getChildNodes()) != null) {
            int length = children.getLength();
            for (int j = 0; j < length; ++j) {
                ImportSpaceObject.parseMissile(object, children.item(j));
            }
        }
    }

    public static void parseMissileSalvo(MissileSalvo object, Node node) {
        NodeList children;
        String name = node.getNodeName();
        if (name.equals("MissileSalvo") && XMLUtilities.attributeExists(node, "id")) {
            object.setId((int)XMLUtilities.getNumericAttribute(node, "id"));
            object.setName();
        }
        if (name.equals("IconFamily") && XMLUtilities.attributeExists(node, "value")) {
            object.setIconFamily(XMLUtilities.getAttribute(node, "value"));
        }
        if (name.equals("Race")) {
            object.setRace(node.getFirstChild().getNodeValue());
        }
        if (name.equals("SalvoType")) {
            object.setSalvoType(node.getFirstChild().getNodeValue());
        }
        if (name.equals("Position")) {
            double x = XMLUtilities.getNumericAttribute(node, "x");
            double y = XMLUtilities.getNumericAttribute(node, "y");
            object.setPosition(x, y);
        }
        if (name.equals("Heading")) {
            object.setHeading((int)XMLUtilities.getNumericAttribute(node, "heading"));
        }
        if (name.equals("Ship")) {
            int shipId = (int)XMLUtilities.getNumericAttribute(node, "id");
            object.setLaunchingShipId(shipId);
        }
        if (name.equals("Launcher")) {
            int launcherId = (int)XMLUtilities.getNumericAttribute(node, "id");
            object.setLauncherId(launcherId);
        }
        if (name.equals("Target")) {
            int targetId = (int)XMLUtilities.getNumericAttribute(node, "id");
            object.setTargetId(targetId);
        }
        if ((children = node.getChildNodes()) != null) {
            int length = children.getLength();
            for (int j = 0; j < length; ++j) {
                ImportSpaceObject.parseMissileSalvo(object, children.item(j));
            }
        }
    }

    public static void parsePlasmaBolt(PlasmaBolt object, Node node) {
        NodeList children;
        String name = node.getNodeName();
        if (name.equals("PlasmaBolt") && XMLUtilities.attributeExists(node, "id")) {
            object.setId((int)XMLUtilities.getNumericAttribute(node, "id"));
            object.setName();
        }
        if (name.equals("IconFamily") && XMLUtilities.attributeExists(node, "value")) {
            object.setIconFamily(XMLUtilities.getAttribute(node, "value"));
        }
        if (name.equals("Race")) {
            object.setRace(node.getFirstChild().getNodeValue());
        }
        if (name.equals("Position")) {
            double x = XMLUtilities.getNumericAttribute(node, "x");
            double y = XMLUtilities.getNumericAttribute(node, "y");
            object.setPosition(x, y);
        }
        if (name.equals("Heading")) {
            object.setHeading((int)XMLUtilities.getNumericAttribute(node, "heading"));
        }
        if (name.equals("Ship")) {
            int shipId = (int)XMLUtilities.getNumericAttribute(node, "id");
            object.setLaunchingShipId(shipId);
        }
        if (name.equals("Launcher")) {
            int launcherId = (int)XMLUtilities.getNumericAttribute(node, "id");
            object.setLauncherId(launcherId);
        }
        if (name.equals("Strength")) {
            object.setStrength(Integer.parseInt(node.getFirstChild().getNodeValue()));
            object.setName();
        }
        if ((children = node.getChildNodes()) != null) {
            int length = children.getLength();
            for (int j = 0; j < length; ++j) {
                ImportSpaceObject.parsePlasmaBolt(object, children.item(j));
            }
        }
    }

    public static void parseNovaCannonBolt(NovaCannonBolt object, Node node) {
        NodeList children;
        String name = node.getNodeName();
        if (name.equals("NovaCannonBolt") && XMLUtilities.attributeExists(node, "id")) {
            object.setId((int)XMLUtilities.getNumericAttribute(node, "id"));
            object.setName();
        }
        if (name.equals("IconFamily") && XMLUtilities.attributeExists(node, "value")) {
            object.setIconFamily(XMLUtilities.getAttribute(node, "value"));
        }
        if (name.equals("Race")) {
            object.setRace(node.getFirstChild().getNodeValue());
        }
        if (name.equals("Position")) {
            double x = XMLUtilities.getNumericAttribute(node, "x");
            double y = XMLUtilities.getNumericAttribute(node, "y");
            object.setPosition(x, y);
        }
        if (name.equals("Heading")) {
            object.setHeading((int)XMLUtilities.getNumericAttribute(node, "heading"));
        }
        if (name.equals("Ship")) {
            int shipId = (int)XMLUtilities.getNumericAttribute(node, "id");
            object.setLaunchingShipId(shipId);
        }
        if (name.equals("Launcher")) {
            int launcherId = (int)XMLUtilities.getNumericAttribute(node, "id");
            object.setLauncherId(launcherId);
        }
        if (name.equals("Age")) {
            object.setAge(Integer.parseInt(node.getFirstChild().getNodeValue()));
        }
        if ((children = node.getChildNodes()) != null) {
            int length = children.getLength();
            for (int j = 0; j < length; ++j) {
                ImportSpaceObject.parseNovaCannonBolt(object, children.item(j));
            }
        }
    }

    public static void parseWaveGunBolt(WaveGunBolt object, Node node) {
        NodeList children;
        String name = node.getNodeName();
        if (name.equals("WaveGunBolt") && XMLUtilities.attributeExists(node, "id")) {
            object.setId((int)XMLUtilities.getNumericAttribute(node, "id"));
            object.setName();
        }
        if (name.equals("IconFamily") && XMLUtilities.attributeExists(node, "value")) {
            object.setIconFamily(XMLUtilities.getAttribute(node, "value"));
        }
        if (name.equals("Race")) {
            object.setRace(node.getFirstChild().getNodeValue());
        }
        if (name.equals("Position")) {
            double x = XMLUtilities.getNumericAttribute(node, "x");
            double y = XMLUtilities.getNumericAttribute(node, "y");
            object.setPosition(x, y);
        }
        if (name.equals("Heading")) {
            object.setHeading((int)XMLUtilities.getNumericAttribute(node, "heading"));
        }
        if (name.equals("Ship")) {
            int shipId = (int)XMLUtilities.getNumericAttribute(node, "id");
            object.setLaunchingShipId(shipId);
        }
        if (name.equals("Launcher")) {
            int launcherId = (int)XMLUtilities.getNumericAttribute(node, "id");
            object.setLauncherId(launcherId);
        }
        if ((children = node.getChildNodes()) != null) {
            int length = children.getLength();
            for (int j = 0; j < length; ++j) {
                ImportSpaceObject.parseWaveGunBolt(object, children.item(j));
            }
        }
    }

    public static void parseAntiMatterTorpedo(AntiMatterTorpedo object, Node node) {
        NodeList children;
        String name = node.getNodeName();
        if (name.equals("AntiMatterTorpedo") && XMLUtilities.attributeExists(node, "id")) {
            object.setId((int)XMLUtilities.getNumericAttribute(node, "id"));
            object.setName();
        }
        if (name.equals("IconFamily") && XMLUtilities.attributeExists(node, "value")) {
            object.setIconFamily(XMLUtilities.getAttribute(node, "value"));
        }
        if (name.equals("Race")) {
            object.setRace(node.getFirstChild().getNodeValue());
        }
        if (name.equals("Position")) {
            double x = XMLUtilities.getNumericAttribute(node, "x");
            double y = XMLUtilities.getNumericAttribute(node, "y");
            object.setPosition(x, y);
        }
        if (name.equals("Heading")) {
            object.setHeading((int)XMLUtilities.getNumericAttribute(node, "heading"));
        }
        if (name.equals("Ship")) {
            int shipId = (int)XMLUtilities.getNumericAttribute(node, "id");
            object.setLaunchingShipId(shipId);
        }
        if (name.equals("Launcher")) {
            int launcherId = (int)XMLUtilities.getNumericAttribute(node, "id");
            object.setLauncherId(launcherId);
        }
        if (name.equals("Target")) {
            int targetId = (int)XMLUtilities.getNumericAttribute(node, "id");
            object.setTargetId(targetId);
        }
        if ((children = node.getChildNodes()) != null) {
            int length = children.getLength();
            for (int j = 0; j < length; ++j) {
                ImportSpaceObject.parseAntiMatterTorpedo(object, children.item(j));
            }
        }
    }

    public static void parseFighterGroup(FighterGroup object, Node node) {
        NodeList children;
        String theValue;
        String name = node.getNodeName();
        if (name.equals("FighterGroup") && XMLUtilities.attributeExists(node, "id")) {
            object.setId((int)XMLUtilities.getNumericAttribute(node, "id"));
            object.setName();
        }
        if (name.equals("IconFamily") && XMLUtilities.attributeExists(node, "value")) {
            object.setIconFamily(XMLUtilities.getAttribute(node, "value"));
        }
        if (name.equals("Race")) {
            object.setRace(node.getFirstChild().getNodeValue());
        }
        if (name.equals("Name")) {
            object.setName(node.getFirstChild().getNodeValue());
        }
        if (name.equals("Class")) {
            object.setFighterClass(node.getFirstChild().getNodeValue());
        }
        if (name.equals("Type")) {
            object.setType(node.getFirstChild().getNodeValue());
        }
        if (name.equals("Position")) {
            double x = XMLUtilities.getNumericAttribute(node, "x");
            double y = XMLUtilities.getNumericAttribute(node, "y");
            object.setPosition(x, y);
            object.setOriginalPosition();
        }
        if (name.equals("Heading")) {
            object.setHeading((int)XMLUtilities.getNumericAttribute(node, "heading"));
            object.setOriginalPosition();
        }
        if (name.equals("Count")) {
            object.setCount(Integer.parseInt(node.getFirstChild().getNodeValue()));
        }
        if (name.equals("DogFighting")) {
            theValue = XMLUtilities.getAttribute(node, "value");
            object.setDogfighting(false);
            if (theValue.equals("true")) {
                object.setDogfighting(true);
            }
        }
        if (name.equals("Carrier")) {
            int carrierId = (int)XMLUtilities.getNumericAttribute(node, "id");
            object.setCarrierShipId(carrierId);
        }
        if (name.equals("OnBoard")) {
            theValue = XMLUtilities.getAttribute(node, "value");
            object.setOnBoard(false);
            if (theValue.equals("true")) {
                object.setOnBoard(true);
            }
        }
        if (name.equals("FighterBay")) {
            int fighterBayId = (int)XMLUtilities.getNumericAttribute(node, "id");
            object.setFighterBayId(fighterBayId);
        }
        if (name.equals("Endurance")) {
            object.setCombatEndurance(Integer.parseInt(node.getFirstChild().getNodeValue()));
        }
        if (name.equals("PilotQuality")) {
            object.setPilotQuality(node.getFirstChild().getNodeValue());
        }
        if (name.equals("Log")) {
            ImportSpaceObject.handleLog(object, node);
            return;
        }
        if (name.equals("Target")) {
            int targetId = (int)XMLUtilities.getNumericAttribute(node, "id");
            object.setTargetId(targetId);
        }
        if (name.equals("Orders")) {
            Node nn = node.getFirstChild();
            if (nn == null) {
                object.setFighterOrders((FighterOrders)FighterGroup.orderChoices.get(0));
            } else {
                String inO = node.getFirstChild().getNodeValue();
                FighterOrders fo = null;
                for (int i = 0; i < FighterGroup.orderChoices.size(); ++i) {
                    fo = (FighterOrders)FighterGroup.orderChoices.get(i);
                    if (!fo.toString().equals(inO)) continue;
                    object.setFighterOrders(fo);
                }
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int length = children.getLength();
            for (int j = 0; j < length; ++j) {
                ImportSpaceObject.parseFighterGroup(object, children.item(j));
            }
        }
    }

    public static void parseHeavenlyBody(HeavenlyBody object, Node node) {
        NodeList children;
        String name = node.getNodeName();
        if (name.equals("HeavenlyBody") && XMLUtilities.attributeExists(node, "id")) {
            object.setId((int)XMLUtilities.getNumericAttribute(node, "id"));
        }
        if (name.equals("Name")) {
            object.setName(node.getFirstChild().getNodeValue());
        }
        if (name.equals("IconFamily") && XMLUtilities.attributeExists(node, "value")) {
            object.setIconFamily(XMLUtilities.getAttribute(node, "value"));
        }
        if (name.equals("Position")) {
            double x = XMLUtilities.getNumericAttribute(node, "x");
            double y = XMLUtilities.getNumericAttribute(node, "y");
            object.setPosition(x, y);
        }
        if (name.equals("Radius")) {
            object.setRadius(XMLUtilities.getNumericAttribute(node, "value"));
        }
        if ((children = node.getChildNodes()) != null) {
            int length = children.getLength();
            for (int j = 0; j < length; ++j) {
                ImportSpaceObject.parseHeavenlyBody(object, children.item(j));
            }
        }
    }

    private static void handleLog(FighterGroup fg, Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            int l = children.getLength();
            for (int i = 0; i < l; ++i) {
                Node child = children.item(i);
                String name = child.getNodeName();
                if (!name.equals("Record")) continue;
                LogRecord r = new LogRecord();
                String record = child.getFirstChild().getNodeValue();
                record = record.trim();
                NamedNodeMap attributes = child.getAttributes();
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node a = attributes.item(j);
                    r.setValue(a.getNodeName(), a.getNodeValue());
                }
                r.setRecord(record);
                fg.addLog(r);
            }
        }
    }
}

