/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std.importer;

import ftjava.std.Defense;
import ftjava.std.Electronics;
import ftjava.std.FTLDrive;
import ftjava.std.FireControl;
import ftjava.std.Holds;
import ftjava.std.Hull;
import ftjava.std.LogRecord;
import ftjava.std.MainDrive;
import ftjava.std.SalvoMissileMagazine;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.Weapon;
import ftjava.util.XMLUtilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportShip {
    public static Ship readShip(InputStream in) throws Exception {
        Ship ship = new Ship();
        Document d = XMLUtilities.getDOMDocument(in);
        ImportShip.parseShip(ship, d.getDocumentElement());
        return ship;
    }

    public static Ship readShip(File file) throws Exception {
        return ImportShip.readShip(new BufferedInputStream(new FileInputStream(file)));
    }

    public static Ship getShip(Node node) {
        Ship ship = new Ship();
        ImportShip.parseShip(ship, node);
        return ship;
    }

    public static void parseShip(Ship ship, Node node) {
        String name = node.getNodeName();
        if (name.equals("Ship")) {
            if (XMLUtilities.attributeExists(node, "id")) {
                ship.setId((int)XMLUtilities.getNumericAttribute(node, "id"));
            }
            if (XMLUtilities.attributeExists(node, "arrivalTurn")) {
                ship.setArrivalTurn((int)XMLUtilities.getNumericAttribute(node, "arrivalTurn"));
            }
            if (XMLUtilities.attributeExists(node, "file")) {
                String fName = XMLUtilities.getAttribute(node, "file");
                System.out.println(fName);
            }
        }
        if (name.equals("IconFamily") && XMLUtilities.attributeExists(node, "value")) {
            ship.setIconFamily(XMLUtilities.getAttribute(node, "value"));
        }
        if (name.equals("Name")) {
            ship.setName(node.getFirstChild().getNodeValue());
        }
        if (name.equals("Status")) {
            ship.setStatus(node.getFirstChild().getNodeValue());
        }
        if (name.equals("Race")) {
            ship.setRace(node.getFirstChild().getNodeValue());
        }
        if (name.equals("ClassAbbrev")) {
            ship.setClassAbbrev(node.getFirstChild().getNodeValue());
        }
        if (name.equals("ClassName")) {
            ship.setClassName(node.getFirstChild().getNodeValue());
        }
        if (name.equals("ShipClass")) {
            ship.setShipClass(node.getFirstChild().getNodeValue());
        }
        if (name.equals("PointValue")) {
            ship.setPointValue(new Integer(node.getFirstChild().getNodeValue()));
        }
        if (name.equals("Position")) {
            double x = XMLUtilities.getNumericAttribute(node, "x");
            double y = XMLUtilities.getNumericAttribute(node, "y");
            ship.setPosition(x, y);
            if (XMLUtilities.attributeExists(node, "pastX")) {
                ship.setPastX(XMLUtilities.getNumericAttribute(node, "pastX"));
            }
            if (XMLUtilities.attributeExists(node, "pastY")) {
                ship.setPastY(XMLUtilities.getNumericAttribute(node, "pastY"));
            }
            if (XMLUtilities.attributeExists(node, "rolled") && ship.getOptions().getShipRoll()) {
                String r = XMLUtilities.getAttribute(node, "rolled");
                ship.setRolled(r.equals("true"));
            }
        }
        if (name.equals("Heading")) {
            ship.setHeading((int)XMLUtilities.getNumericAttribute(node, "heading"));
            if (XMLUtilities.attributeExists(node, "pastHeading")) {
                ship.setPastHeading((int)XMLUtilities.getNumericAttribute(node, "pastHeading"));
            }
        }
        if (name.equals("Speed")) {
            int i = (int)XMLUtilities.getNumericAttribute(node, "speed");
            ship.setSpeed(i);
        }
        if (name.equals("VectorSpeed")) {
            double s = XMLUtilities.getNumericAttribute(node, "speed");
            ship.setVectorSpeed(s);
            ship.setVelocityFromHeadingAndSpeed(ship.getVectorCourse(), s);
        }
        if (name.equals("Course")) {
            double c = XMLUtilities.getNumericAttribute(node, "course");
            ship.setCourse(c);
            ship.setVelocityFromHeadingAndSpeed(c, ship.getVectorSpeed());
        }
        if (name.equals("Orders")) {
            Node nn = node.getFirstChild();
            if (nn == null) {
                ship.setOrders("0");
            } else {
                ship.setOrders(nn.getNodeValue());
            }
        }
        if (name.equals("DamageControl") && XMLUtilities.attributeExists(node, "ids")) {
            String Value = XMLUtilities.getAttribute(node, "ids");
            ArrayList<Integer> d = new ArrayList<Integer>();
            StringTokenizer st = new StringTokenizer(Value, ",");
            while (st.hasMoreTokens()) {
                String id = st.nextToken();
                Integer iobj = new Integer(id);
                d.add(iobj);
            }
            ship.setDamageControlIds(d);
        }
        if (name.equals("MainDrive")) {
            ship.setMainDrive(new MainDrive());
            ship.getMainDrive().setShip(ship);
            if (XMLUtilities.attributeExists(node, "initialThrust")) {
                ship.getMainDrive().setThrustRating((int)XMLUtilities.getNumericAttribute(node, "initialThrust"));
            }
            if (XMLUtilities.attributeExists(node, "currentThrust")) {
                ship.getMainDrive().setCurrentThrust((int)XMLUtilities.getNumericAttribute(node, "currentThrust"));
            }
            if (XMLUtilities.attributeExists(node, "active") && XMLUtilities.getBooleanAttribute(node, "active")) {
                ship.getMainDrive().setActive(true);
            }
            if (XMLUtilities.attributeExists(node, "type")) {
                ship.getMainDrive().setType(XMLUtilities.getAttribute(node, "type"));
            }
            if (XMLUtilities.attributeExists(node, "id")) {
                ship.getMainDrive().setId((int)XMLUtilities.getNumericAttribute(node, "id"));
            }
            if (XMLUtilities.attributeExists(node, "status")) {
                ((ShipSystem)ship.getMainDrive()).setSystemStatus(XMLUtilities.getAttribute(node, "status"));
            }
            if (XMLUtilities.attributeExists(node, "notes")) {
                ship.getMainDrive().setNotes(XMLUtilities.getAttribute(node, "notes"));
            }
        }
        if (name.equals("FTLDrive")) {
            ship.setFTLDrive(new FTLDrive());
            ship.getFTLDrive().setShip(ship);
            if (XMLUtilities.attributeExists(node, "id")) {
                ship.getFTLDrive().setId((int)XMLUtilities.getNumericAttribute(node, "id"));
            }
            if (XMLUtilities.attributeExists(node, "phasesActive")) {
                ship.getFTLDrive().setPhasesActive((int)XMLUtilities.getNumericAttribute(node, "phasesActive"));
            }
            if (XMLUtilities.attributeExists(node, "active") && XMLUtilities.getBooleanAttribute(node, "active")) {
                ship.getFTLDrive().activate();
            }
            if (XMLUtilities.attributeExists(node, "status")) {
                ((ShipSystem)ship.getFTLDrive()).setSystemStatus(XMLUtilities.getAttribute(node, "status"));
            }
            if (XMLUtilities.attributeExists(node, "recharge")) {
                ship.getFTLDrive().setRecharge((int)XMLUtilities.getNumericAttribute(node, "recharge"));
            }
            if (XMLUtilities.attributeExists(node, "notes")) {
                ship.getFTLDrive().setNotes(XMLUtilities.getAttribute(node, "notes"));
            }
        }
        if (name.equals("Armor")) {
            String rem;
            if (XMLUtilities.attributeExists(node, "totalArmor")) {
                String tot = XMLUtilities.getAttribute(node, "totalArmor");
                ship.getArmor().setValue("totalArmor", tot);
            }
            if (XMLUtilities.attributeExists(node, "remainingArmor")) {
                rem = XMLUtilities.getAttribute(node, "remainingArmor");
                ship.getArmor().setValue("remainingArmor", rem);
            }
            if (XMLUtilities.attributeExists(node, "stealth")) {
                rem = XMLUtilities.getAttribute(node, "stealth");
                ship.getArmor().setValue("stealth", rem);
            }
        }
        if (name.equals("Hull")) {
            int hullValue = (int)XMLUtilities.getNumericAttribute(node, "value");
            String hullType = XMLUtilities.getAttribute(node, "type");
            String hullClass = XMLUtilities.getAttribute(node, "class");
            int rows = (int)XMLUtilities.getNumericAttribute(node, "rows");
            if (rows == 0) {
                rows = 4;
            }
            int stealth = (int)XMLUtilities.getNumericAttribute(node, "stealth");
            if (XMLUtilities.attributeExists(node, "totalHullBoxes")) {
                int totalHullBoxes = (int)XMLUtilities.getNumericAttribute(node, "totalHullBoxes");
                if (hullClass == null) {
                    ship.setHull(new Hull(hullValue, totalHullBoxes, "Military", rows, stealth));
                } else {
                    ship.setHull(new Hull(hullValue, totalHullBoxes, hullClass, rows, stealth));
                }
            } else if (hullClass == null) {
                ship.setHull(new Hull(hullValue, hullType, "Military", rows, stealth));
            } else {
                ship.setHull(new Hull(hullValue, hullType, hullClass, rows, stealth));
            }
            if (XMLUtilities.attributeExists(node, "remainingHullBoxes")) {
                ship.getHull().setRemainingHull((int)XMLUtilities.getNumericAttribute(node, "remainingHullBoxes"));
            }
        }
        if (name.equals("Electronics")) {
            ImportShip.handleElectronics(ship, node);
            return;
        }
        if (name.equals("Defenses")) {
            ImportShip.handleDefenses(ship, node);
            return;
        }
        if (name.equals("Holds")) {
            ImportShip.handleHolds(ship, node);
            return;
        }
        if (name.equals("Weapons")) {
            ImportShip.handleWeapons(ship, node);
            return;
        }
        if (name.equals("Log")) {
            ImportShip.handleLog(ship, node);
            return;
        }
        NodeList children = node.getChildNodes();
        if (children != null) {
            int length = children.getLength();
            for (int j = 0; j < length; ++j) {
                ImportShip.parseShip(ship, children.item(j));
            }
        }
    }

    private static void handleElectronics(Ship ship, Node node) {
        NodeList children = node.getChildNodes();
        ArrayList<Electronics> list = new ArrayList<Electronics>();
        if (children != null) {
            int l = children.getLength();
            for (int i = 0; i < l; ++i) {
                Node child = children.item(i);
                String name = child.getNodeName();
                Electronics e = Electronics.findSystem(name);
                if (e == null) continue;
                NamedNodeMap attributes = child.getAttributes();
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node a = attributes.item(j);
                    e.setValue(a.getNodeName(), a.getNodeValue());
                }
                e.setShip(ship);
                list.add(e);
            }
        }
        ship.setElectronicsSystems(list);
    }

    private static void handleDefenses(Ship ship, Node node) {
        NodeList children = node.getChildNodes();
        ArrayList<Defense> list = new ArrayList<Defense>();
        if (children != null) {
            int l = children.getLength();
            for (int i = 0; i < l; ++i) {
                Node child = children.item(i);
                String name = child.getNodeName();
                Defense e = Defense.findSystem(name);
                if (e == null) continue;
                NamedNodeMap attributes = child.getAttributes();
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node a = attributes.item(j);
                    e.setValue(a.getNodeName(), a.getNodeValue());
                }
                e.setShip(ship);
                list.add(e);
            }
        }
        ship.setDefenseSystems(list);
    }

    private static void handleHolds(Ship ship, Node node) {
        NodeList children = node.getChildNodes();
        ArrayList<Holds> list = new ArrayList<Holds>();
        if (children != null) {
            int l = children.getLength();
            for (int i = 0; i < l; ++i) {
                Node child = children.item(i);
                String name = child.getNodeName();
                Holds e = Holds.findSystem(name);
                if (e == null) continue;
                NamedNodeMap attributes = child.getAttributes();
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node a = attributes.item(j);
                    e.setValue(a.getNodeName(), a.getNodeValue());
                }
                e.setShip(ship);
                list.add(e);
            }
        }
        ship.setShipHolds(list);
    }

    private static void handleWeapons(Ship ship, Node node) {
        NodeList children = node.getChildNodes();
        ArrayList<Weapon> list = new ArrayList<Weapon>();
        if (children != null) {
            int l = children.getLength();
            for (int i = 0; i < l; ++i) {
                Node child = children.item(i);
                String name = child.getNodeName();
                Weapon e = Weapon.findSystem(name);
                if (e == null) continue;
                NamedNodeMap attributes = child.getAttributes();
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node a = attributes.item(j);
                    e.setValue(a.getNodeName(), a.getNodeValue());
                }
                if (name.equals("SalvoMissileMagazine")) {
                    SalvoMissileMagazine smm = (SalvoMissileMagazine)e;
                    NodeList weaponChildren = child.getChildNodes();
                    if (weaponChildren != null) {
                        int len = weaponChildren.getLength();
                        for (int k = 0; k < len; ++k) {
                            Node smmChild = weaponChildren.item(k);
                            if (!smmChild.getNodeName().equals("Salvo")) continue;
                            attributes = smmChild.getAttributes();
                            String type = "";
                            String status = "";
                            for (int j = 0; j < attributes.getLength(); ++j) {
                                Node a = attributes.item(j);
                                String attr = a.getNodeName();
                                String value = a.getNodeValue();
                                if (attr.equals("type")) {
                                    type = value;
                                    continue;
                                }
                                if (!attr.equals("status")) continue;
                                status = value;
                            }
                            smm.addSalvo(type, status);
                        }
                    }
                }
                e.setShip(ship);
                list.add(e);
            }
        }
        ship.setWeaponSystems(list);
        ArrayList fcs = ship.getActiveFireControls();
        if (fcs == null) {
            return;
        }
        FireControl fc = null;
        ArrayList ids = null;
        for (int i = 0; i < fcs.size(); ++i) {
            fc = (FireControl)fcs.get(i);
            ids = fc.getSlavedWeaponsIds();
            if (ids == null || ids.isEmpty()) continue;
            for (int j = 0; j < ids.size(); ++j) {
                Integer kInt = (Integer)ids.get(j);
                int k = kInt;
                Weapon w = ship.getWeaponById(k);
                if (w == null) continue;
                fc.slaveWeapon(w);
            }
        }
    }

    private static void handleLog(Ship ship, Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            int l = children.getLength();
            for (int i = 0; i < l; ++i) {
                Node child = children.item(i);
                String name = child.getNodeName();
                if (!name.equals("Record")) continue;
                LogRecord r = new LogRecord();
                String record = child.getFirstChild().getNodeValue();
                record = record.trim();
                NamedNodeMap attributes = child.getAttributes();
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node a = attributes.item(j);
                    r.setValue(a.getNodeName(), a.getNodeValue());
                }
                r.setRecord(record);
                ship.addLog(r);
            }
        }
    }
}

