/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.AntiMatterTorpedo;
import ftjava.std.FighterGroup;
import ftjava.std.GameEngine;
import ftjava.std.MissileSalvo;
import ftjava.std.NovaCannonBolt;
import ftjava.std.PlasmaBolt;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import ftjava.util.Dice;
import ftjava.util.MathUtil;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;

public class WaveGunBolt
extends SpaceObject {
    private String team = "";
    private int launchingShipId = 0;
    private int launcherId = 0;
    private boolean hasAttacked = false;

    public void setName() {
        this.setName("WG " + this.getId());
    }

    public void setTeam(String s) {
        this.team = s;
    }

    public String getTeam() {
        return this.team;
    }

    public void setLaunchingShipId(int id) {
        this.launchingShipId = id;
    }

    public int getLaunchingShipId() {
        return this.launchingShipId;
    }

    public void setLauncherId(int id) {
        this.launcherId = id;
    }

    public int getLauncherId() {
        return this.launcherId;
    }

    public void setHasAttacked(boolean b) {
        this.hasAttacked = b;
    }

    public boolean hasAttacked() {
        return this.hasAttacked;
    }

    private Ship getLaunchingShip() {
        return this.getGameEngine().getShipById(this.launchingShipId);
    }

    public void takeDamage(int[] hits) {
    }

    public void fireAt() {
        String playTestResults = "";
        this.setHasAttacked(true);
        double length = 12.0;
        int[] damage = new int[1];
        GameEngine game = this.getGameEngine();
        ArrayList allObjects = game.getActiveObjects();
        for (int i = 0; i < allObjects.size(); ++i) {
            SpaceObject so = (SpaceObject)allObjects.get(i);
            if (so instanceof WaveGunBolt || so instanceof NovaCannonBolt || so instanceof PlasmaBolt || so instanceof AntiMatterTorpedo) continue;
            int strength = 0;
            if (this.inShortRange(so, length, 1.0)) {
                strength = 4;
            }
            if (this.inMediumRange(so, length, 1.5)) {
                strength = 3;
            }
            if (this.inLongRange(so, length, 2.0)) {
                strength = 2;
            }
            if (strength == 0) continue;
            damage[0] = 0;
            playTestResults = "";
            for (int j = 0; j < strength; ++j) {
                int die = Dice.rollD6();
                playTestResults = playTestResults + "(" + die + ") ";
                damage[0] = damage[0] + die;
            }
            String record = this.getName() + ": Wave Gun hit for " + StringUtils.points(damage[0]) + ".";
            String report = this.getName() + " hit " + so.getName() + " for " + StringUtils.points(damage[0]) + ".";
            if (this.getOptions().getPlayTest()) {
                record = record + " " + playTestResults;
                report = report + " " + playTestResults;
            }
            game.addTurnReport("Attack", "High", report);
            if (so instanceof MissileSalvo) {
                ((MissileSalvo)so).takeDamage(damage);
            }
            if (so instanceof FighterGroup) {
                if (((FighterGroup)so).isOnBoard()) continue;
                ((FighterGroup)so).takeDamage(damage);
            }
            if (!so.isShip()) continue;
            ((Ship)so).takeDamage(damage);
            so.addLog("Attack", "High", record);
        }
    }

    private boolean inShortRange(SpaceObject so, double length, double radius) {
        double dy;
        double yO;
        double dx;
        double xP = this.getXPosition();
        double yP = this.getYPosition();
        double xE = xP + length * MathUtil.X(this.getHeading());
        double yE = yP + length * MathUtil.Y(this.getHeading());
        double xO = so.getXPosition();
        double t = ((xO - xP) * (dx = xE - xP) + ((yO = so.getYPosition()) - yP) * (dy = yE - yP)) / (dx * dx + dy * dy);
        if (t < 0.0 || t > 1.0) {
            return false;
        }
        double xN = xP + t * dx;
        double yN = yP + t * dy;
        double d3 = MathUtil.distance(xO, yO, xN, yN);
        return d3 <= radius;
    }

    private boolean inMediumRange(SpaceObject so, double length, double radius) {
        double dy;
        double yO;
        double dx;
        double xP = this.getXPosition() + length * MathUtil.X(this.getHeading());
        double yP = this.getYPosition() + length * MathUtil.Y(this.getHeading());
        double xE = xP + length * MathUtil.X(this.getHeading());
        double yE = yP + length * MathUtil.Y(this.getHeading());
        double xO = so.getXPosition();
        double t = ((xO - xP) * (dx = xE - xP) + ((yO = so.getYPosition()) - yP) * (dy = yE - yP)) / (dx * dx + dy * dy);
        if (t < 0.0 || t > 1.0) {
            return false;
        }
        double xN = xP + t * dx;
        double yN = yP + t * dy;
        double d3 = MathUtil.distance(xO, yO, xN, yN);
        return d3 <= radius;
    }

    private boolean inLongRange(SpaceObject so, double length, double radius) {
        double dy;
        double yO;
        double dx;
        double xP = this.getXPosition() + 2.0 * length * MathUtil.X(this.getHeading());
        double yP = this.getYPosition() + 2.0 * length * MathUtil.Y(this.getHeading());
        double xE = xP + length * MathUtil.X(this.getHeading());
        double yE = yP + length * MathUtil.Y(this.getHeading());
        double xO = so.getXPosition();
        double t = ((xO - xP) * (dx = xE - xP) + ((yO = so.getYPosition()) - yP) * (dy = yE - yP)) / (dx * dx + dy * dy);
        if (t < 0.0 || t > 1.0) {
            return false;
        }
        double xN = xP + t * dx;
        double yN = yP + t * dy;
        double d3 = MathUtil.distance(xO, yO, xN, yN);
        return d3 <= radius;
    }

    public String toString() {
        String result = "";
        String newLine = System.getProperty("line.separator");
        DecimalFormat df = new DecimalFormat("0.0");
        result = result + this.getRace() + " wave gun bolt" + newLine;
        result = result + newLine;
        result = result + "Position: ";
        result = result + df.format(this.getXPosition()) + ", ";
        result = result + df.format(this.getYPosition()) + newLine;
        return result;
    }

    private String ind(int level) {
        if (level > 0) {
            return XMLUtilities.getIndent() + XMLUtilities.getIndent();
        }
        return "";
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String s = "";
        String sep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String t = XMLUtilities.getIndent();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat df = new DecimalFormat("0.0");
        df.setDecimalFormatSymbols(dfs);
        if (level == 10) {
            return s;
        }
        sb.append(this.ind(level) + "<WaveGunBolt");
        if (level >= 1) {
            sb.append(" id=\"" + this.getId() + "\">" + sep);
        } else {
            sb.append(">" + sep);
        }
        if (level >= 1) {
            sb.append(this.ind(level) + t + "<Position ");
            sb.append("x=\"" + df.format(this.getXPosition()) + "\" ");
            sb.append("y=\"" + df.format(this.getYPosition()) + "\"/>" + sep);
            sb.append(this.ind(level) + t);
            sb.append("<Heading heading=\"" + this.getHeading() + "\"/>" + sep);
            sb.append(this.ind(level) + t);
            sb.append("<Race>" + this.getRace() + "</Race>" + sep);
            if (this.getIconFamily() != null) {
                sb.append(this.ind(level)).append(t);
                sb.append("<IconFamily value=\"");
                sb.append(this.getIconFamily());
                sb.append("\"/>").append(sep);
            }
            sb.append(this.ind(level) + t);
            sb.append("<Ship id=\"" + this.getLaunchingShipId());
            sb.append("\"/>" + sep);
            sb.append(this.ind(level) + t);
            sb.append("<Launcher id=\"" + this.getLauncherId());
            sb.append("\"/>" + sep);
        }
        sb.append(this.ind(level) + "</WaveGunBolt>" + sep);
        return sb.toString();
    }

    public String movementOrdersToXML() {
        StringBuffer sb = new StringBuffer();
        String sep = "\n";
        String t = XMLUtilities.getIndent();
        Ship s = this.getLaunchingShip();
        if (s.hasActiveVapourShroud()) {
            return "";
        }
        sb.append(t + t + "<LaunchWaveBolt ");
        sb.append("shipId=\"" + this.getLaunchingShipId() + "\" ");
        sb.append("launcherId=\"" + this.getLauncherId() + "\" ");
        sb.append("x=\"" + this.getXPosition() + "\" ");
        sb.append("y=\"" + this.getYPosition() + "\" ");
        sb.append("heading=\"" + this.getHeading() + "\"/>");
        sb.append(sep);
        return sb.toString();
    }
}

