/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.Defense;
import ftjava.std.ShipSystem;
import ftjava.util.XMLUtilities;

public class VapourShroud
extends Defense {
    public static final String NAME = "VapourShroud";
    public static final String SYSTEM_NAME = "Vapour Shroud";
    public static final String ACTIVE = "active";
    private boolean isActive;

    public VapourShroud() {
        this.setSystemName(SYSTEM_NAME);
        this.isActive = false;
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
    }

    public void setValue(String Name, String Value) {
        boolean handled = false;
        if (Name.equals(ACTIVE)) {
            if (Value.equals("true")) {
                this.setActive(true);
            } else {
                this.setActive(false);
            }
            handled = true;
        }
        if (!handled) {
            super.setValue(Name, Value);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public int computeMass(int shipMass) {
        int mass = (int)Math.round(0.05 * (double)shipMass);
        if (mass < 1) {
            mass = 1;
        }
        return mass;
    }

    public int computePointCost(int shipMass) {
        return 3 * this.computeMass(shipMass);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("   ");
        result.append(SYSTEM_NAME);
        result.append(" ");
        if (this.isActive()) {
            result.append(ACTIVE);
        }
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result.append(" ");
            }
            result.append(this.getSystemStatus());
        }
        return result.toString();
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        StringBuffer result = new StringBuffer(64);
        String t = XMLUtilities.getIndent();
        String sep = System.getProperty("line.separator");
        if (level >= 7) {
            return result.toString();
        }
        result.append(t).append(t).append("<");
        result.append(NAME);
        if (level > 0) {
            result.append(" id=\"").append(this.getId()).append("\"");
        }
        result.append(" ").append(ACTIVE);
        result.append("=\"").append(this.isActive).append("\"");
        if (this.isSSDDefined()) {
            result.append(" xSSD=\"").append(this.getXSSD()).append("\"");
            result.append(" ySSD=\"").append(this.getYSSD()).append("\"");
        }
        if (level != 0 && level != 5 && level != 6) {
            result.append(" status=\"");
            result.append(this.getSystemStatus()).append("\"");
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            result.append(" notes=\"");
            result.append(this.getNotes()).append("\"");
        }
        result.append("/>").append(sep);
        return result.toString();
    }

    static {
        Defense.addSystem(NAME, new VapourShroud());
    }
}

