/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.Defense;
import ftjava.std.ShipSystem;
import ftjava.util.XMLUtilities;

public class StealthGenerator
extends Defense {
    public StealthGenerator() {
        this.setSystemName("StealthGenerator");
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
    }

    public int computeMass(int shipMass) {
        int mass = (int)Math.round(0.05 * (double)shipMass);
        if (mass <= 2) {
            mass = 3;
        }
        return mass;
    }

    public int computePointCost(int shipMass) {
        return 9 * this.computeMass(shipMass);
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        StringBuffer sb = new StringBuffer();
        String t = XMLUtilities.getIndent();
        String sep = System.getProperty("line.separator");
        if (level >= 7) {
            return "";
        }
        sb.append(t);
        sb.append(t);
        sb.append("<StealthGenerator");
        if (level > 0) {
            sb.append(" id=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        if (level != 0 && level != 5 && level != 6) {
            sb.append(" status=\"" + this.getSystemStatus() + "\"");
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"");
            sb.append(this.getNotes());
            sb.append("\"");
        }
        sb.append("/>");
        sb.append(sep);
        return sb.toString();
    }

    static {
        Defense.addSystem("StealthGenerator", new StealthGenerator());
    }
}

