/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.GameEngine;
import ftjava.std.LogRecord;
import ftjava.std.Player;
import ftjava.std.Ship;
import ftjava.std.Weapon;
import ftjava.util.GameOptions;
import ftjava.util.MathUtil;
import java.util.ArrayList;

public class SpaceObject {
    public static final int UNDEFINED = 13;
    private String name = "";
    private String status = "Ok";
    private Player player = null;
    protected GameEngine gameEngine = null;
    private int id = 0;
    private int arrivalTurn = -1;
    private double xPosition = 0.0;
    private double yPosition = 0.0;
    private int heading = 12;
    private int speed = 0;
    private double xVelocity = 0.0;
    private double yVelocity = 0.0;
    private double vectorSpeed = -1.0;
    private double vectorCourse = -1.0;
    private double pastX = 0.0;
    private double pastY = 0.0;
    private int pastHeading = 13;
    private boolean rolled = false;
    private String orders = "0";
    private boolean validOrders = true;
    private boolean usedDrives = false;
    private double radius = 0.0;
    private String race;
    private String iconFamily = null;
    private String color = "";
    private String crewQuality = "First Rate";
    private ArrayList log = new ArrayList();

    public void setName(String s) {
        this.name = s;
    }

    public String getName() {
        return this.name;
    }

    public void setStatus(String s) {
        this.status = s;
    }

    public String getStatus() {
        return this.status;
    }

    public void setPlayer(Player p) {
        this.player = p;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setGameEngine(GameEngine g) {
        this.gameEngine = g;
    }

    public GameEngine getGameEngine() {
        return this.gameEngine;
    }

    public GameOptions getOptions() {
        if (this.gameEngine != null) {
            return this.gameEngine.getOptions();
        }
        return GameOptions.current();
    }

    public ArrayList getLog() {
        return this.log;
    }

    public String getTeam() {
        Player p = this.getPlayer();
        if (p == null || p.getTeam() == null) {
            return "None";
        }
        return p.getTeam();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int i) {
        this.id = i;
    }

    public int getArrivalTurn() {
        return this.arrivalTurn;
    }

    public void setArrivalTurn(int i) {
        this.arrivalTurn = i;
    }

    public boolean hasArrived() {
        int currentTurn = this.getGameEngine().getGameTurn();
        return currentTurn >= this.arrivalTurn;
    }

    public void setXPosition(double x) {
        this.xPosition = x;
    }

    public void setYPosition(double y) {
        this.yPosition = y;
    }

    public double getXPosition() {
        return this.xPosition;
    }

    public double getYPosition() {
        return this.yPosition;
    }

    public void setPastX(double x) {
        this.pastX = x;
    }

    public void setPastY(double y) {
        this.pastY = y;
    }

    public double getPastX() {
        return this.pastX;
    }

    public double getPastY() {
        return this.pastY;
    }

    public void setPastHeading(int h) {
        this.pastHeading = h;
    }

    public int getPastHeading() {
        return this.pastHeading;
    }

    public void setPosition(double x, double y, double z) {
        this.setXPosition(x);
        this.setYPosition(y);
    }

    public void setPosition(double x, double y) {
        this.setPosition(x, y, 0.0);
    }

    public void setHeading(int h) {
        this.heading = h;
    }

    public int getHeading() {
        return this.heading;
    }

    public void setSpeed(int s) {
        this.speed = s;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setXVelocity(double x) {
        this.xVelocity = x;
    }

    public void setYVelocity(double y) {
        this.yVelocity = y;
    }

    public void setVelocity(double x, double y) {
        this.setXVelocity(x);
        this.setYVelocity(y);
        this.setVectorSpeed(Math.sqrt(x * x + y * y));
    }

    public void setVectorSpeed(double s) {
        this.vectorSpeed = s;
    }

    public double getVectorSpeed() {
        return this.vectorSpeed;
    }

    public void setVectorCourse(double c) {
        this.vectorCourse = c;
    }

    public double getVectorCourse() {
        return this.vectorCourse;
    }

    public void setCourse(double c) {
        this.setVectorCourse(c);
    }

    public void setCourse(double x, double y) {
        double angle = MathUtil.toDegrees(Math.atan2(y, x));
        this.vectorCourse = MathUtil.headingFromAngle(angle);
    }

    public double getCourse() {
        return this.vectorCourse;
    }

    public void setRadius(double s) {
        this.radius = s;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setVelocityFromHeadingAndSpeed(int h, int s) {
        double angle = MathUtil.angleFromHeading(h);
        this.setXVelocity((double)s * Math.cos(Math.toRadians(angle)));
        this.setYVelocity((double)s * Math.sin(Math.toRadians(angle)));
    }

    public void setVelocityFromHeadingAndSpeed(double h, double s) {
        double angle = MathUtil.angleFromHeading(h);
        this.setXVelocity(s * Math.cos(Math.toRadians(angle)));
        this.setYVelocity(s * Math.sin(Math.toRadians(angle)));
    }

    public void setVelocityFromCourseAndSpeed() {
        this.setVelocityFromHeadingAndSpeed(this.getCourse(), this.getVectorSpeed());
    }

    public double getXVelocity() {
        return this.xVelocity;
    }

    public double getYVelocity() {
        return this.yVelocity;
    }

    public void setRolled(boolean b) {
        this.rolled = b;
    }

    public boolean getRolled() {
        return this.rolled;
    }

    public void toggleRolled() {
        this.rolled = !this.rolled;
    }

    public void setRace(String s) {
        this.race = s;
    }

    public String getRace() {
        return this.race;
    }

    public void setColor(String i) {
        this.color = i;
    }

    public String getColor() {
        return this.color;
    }

    public void setIconFamily(String s) {
        this.iconFamily = s;
    }

    public String getIconFamily() {
        return this.iconFamily;
    }

    public void setCrewQuality(String s) {
        this.crewQuality = "First Rate";
        if (s.equals("Elite")) {
            this.crewQuality = "Elite";
        }
        if (s.equals("First Rate")) {
            this.crewQuality = "First Rate";
        }
        if (s.equals("Second Rate")) {
            this.crewQuality = "Second Rate";
        }
        if (s.equals("Third Rate")) {
            this.crewQuality = "Third Rate";
        }
        if (s.equals("Civilian")) {
            this.crewQuality = "Civilian";
        }
    }

    public String getCrewQuality() {
        return this.crewQuality;
    }

    public void setOrders(String i) {
        this.orders = i;
    }

    public String getOrders() {
        return this.orders;
    }

    public void setOrdersValid(boolean tf) {
        this.validOrders = tf;
    }

    public boolean areOrdersValid() {
        return this.validOrders;
    }

    public void setUsedDrives(boolean tf) {
        this.usedDrives = tf;
    }

    public boolean hasUsedDrives() {
        return this.usedDrives;
    }

    public boolean isShip() {
        return this instanceof Ship;
    }

    public double rangeTo(SpaceObject s) {
        return SpaceObject.range(this.xPosition, this.yPosition, s.getXPosition(), s.getYPosition());
    }

    public double rangeTo(double x, double y) {
        return SpaceObject.range(this.xPosition, this.yPosition, x, y);
    }

    public static double range(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double getRangeStealthModifier() {
        return 1.0;
    }

    public double getMassStealthModifier() {
        return 1.0;
    }

    public void takeDamage(int[] damage) {
    }

    public double minimumRangeTo(ArrayList objs, ArrayList hBodies) {
        double minimum = 10000.0;
        for (int i = 0; i < objs.size(); ++i) {
            double current;
            Object o = objs.get(i);
            if (!(o instanceof SpaceObject) || !((current = this.rangeTo((SpaceObject)o)) < minimum)) continue;
            boolean blocked = false;
            for (int j = 0; j < hBodies.size(); ++j) {
                Object ho = hBodies.get(j);
                if (!(ho instanceof SpaceObject)) continue;
                SpaceObject sho = (SpaceObject)ho;
                blocked |= sho.intersect((SpaceObject)o, this);
            }
            if (blocked) continue;
            minimum = current;
        }
        return minimum;
    }

    public double[] rangeBoundsAlongVector(double x, double y, double maxRange) {
        double[] result = new double[2];
        double dx = x - this.xPosition;
        double dy = y - this.yPosition;
        double range = Math.sqrt(dx * dx + dy * dy);
        if (range < maxRange) {
            result[0] = x;
            result[1] = y;
            return result;
        }
        double tolerance = 0.1;
        result[0] = (maxRange - tolerance) * dx / range + this.xPosition;
        result[1] = (maxRange - tolerance) * dy / range + this.yPosition;
        return result;
    }

    public double[] rangeBoundsAlongVectorPast(double x, double y, double maxRange) {
        double[] result = new double[2];
        double dx = x - this.pastX;
        double dy = y - this.pastY;
        double range = Math.sqrt(dx * dx + dy * dy);
        if (range < maxRange) {
            result[0] = x;
            result[1] = y;
            return result;
        }
        double tolerance = 0.1;
        result[0] = (maxRange - tolerance) * dx / range + this.pastX;
        result[1] = (maxRange - tolerance) * dy / range + this.pastY;
        return result;
    }

    public int arcTo(SpaceObject s) {
        double dx = s.getXPosition() - this.xPosition;
        double dy = s.getYPosition() - this.yPosition;
        return this.arcTo(dx, dy);
    }

    public int arcTo(double dx, double dy) {
        double angle = MathUtil.toDegrees(Math.atan2(dx, dy)) + 720.0;
        angle -= (double)this.heading * 30.0;
        if ((angle %= 360.0) <= 30.0 || angle >= 330.0) {
            return Weapon.FORE_ARC;
        }
        if (angle > 150.0 && angle <= 210.0) {
            return Weapon.AFT_ARC;
        }
        if (!this.getRolled()) {
            if (angle > 30.0 && angle <= 90.0) {
                return Weapon.FORE_STARBOARD_ARC;
            }
            if (angle > 90.0 && angle <= 150.0) {
                return Weapon.AFT_STARBOARD_ARC;
            }
            if (angle > 210.0 && angle <= 270.0) {
                return Weapon.AFT_PORT_ARC;
            }
            return Weapon.FORE_PORT_ARC;
        }
        if (angle > 30.0 && angle <= 90.0) {
            return Weapon.FORE_PORT_ARC;
        }
        if (angle > 90.0 && angle <= 150.0) {
            return Weapon.AFT_PORT_ARC;
        }
        if (angle > 210.0 && angle <= 270.0) {
            return Weapon.AFT_STARBOARD_ARC;
        }
        return Weapon.FORE_STARBOARD_ARC;
    }

    public int headingTo(double x, double y) {
        double dx = x - this.getXPosition();
        double dy = y - this.getYPosition();
        double angle = MathUtil.toDegrees(Math.atan2(dx, dy)) + 720.0;
        if ((angle %= 360.0) > 15.0 && angle <= 45.0) {
            return 1;
        }
        if (angle > 45.0 && angle <= 75.0) {
            return 2;
        }
        if (angle > 75.0 && angle <= 105.0) {
            return 3;
        }
        if (angle > 105.0 && angle <= 135.0) {
            return 4;
        }
        if (angle > 135.0 && angle <= 165.0) {
            return 5;
        }
        if (angle > 165.0 && angle <= 195.0) {
            return 6;
        }
        if (angle > 195.0 && angle <= 215.0) {
            return 7;
        }
        if (angle > 215.0 && angle <= 245.0) {
            return 8;
        }
        if (angle > 245.0 && angle <= 275.0) {
            return 9;
        }
        if (angle > 275.0 && angle <= 305.0) {
            return 10;
        }
        if (angle > 305.0) {
            return 11;
        }
        return 12;
    }

    public int headingPastTo(double x, double y) {
        double dx = x - this.getPastX();
        double dy = y - this.getPastY();
        double angle = MathUtil.toDegrees(Math.atan2(dx, dy)) + 720.0;
        if ((angle %= 360.0) > 15.0 && angle <= 45.0) {
            return 1;
        }
        if (angle > 45.0 && angle <= 75.0) {
            return 2;
        }
        if (angle > 75.0 && angle <= 105.0) {
            return 3;
        }
        if (angle > 105.0 && angle <= 135.0) {
            return 4;
        }
        if (angle > 135.0 && angle <= 165.0) {
            return 5;
        }
        if (angle > 165.0 && angle <= 195.0) {
            return 6;
        }
        if (angle > 195.0 && angle <= 215.0) {
            return 7;
        }
        if (angle > 215.0 && angle <= 245.0) {
            return 8;
        }
        if (angle > 245.0 && angle <= 275.0) {
            return 9;
        }
        if (angle > 275.0 && angle <= 305.0) {
            return 10;
        }
        if (angle > 305.0) {
            return 11;
        }
        return 12;
    }

    public String arcToString(SpaceObject s) {
        int arc = this.arcTo(s);
        if (arc == Weapon.FORE_ARC) {
            return "F";
        }
        if (arc == Weapon.FORE_STARBOARD_ARC) {
            return "FS";
        }
        if (arc == Weapon.AFT_STARBOARD_ARC) {
            return "AS";
        }
        if (arc == Weapon.AFT_ARC) {
            return "A";
        }
        if (arc == Weapon.AFT_PORT_ARC) {
            return "AP";
        }
        return "FP";
    }

    public boolean isEnemy(SpaceObject s) {
        if (this == s) {
            return false;
        }
        if (s.getPlayer().equals(this.getPlayer())) {
            return false;
        }
        return !s.getTeam().equals(this.getTeam());
    }

    public boolean isFriend(SpaceObject s) {
        return true;
    }

    public boolean isUnknown(SpaceObject s) {
        return false;
    }

    public void addLog(String event, String priority, String record) {
        LogRecord r = new LogRecord();
        if (this.getGameEngine() != null) {
            r.setTurn(this.getGameEngine().getGameTurn());
        } else {
            r.setTurn(999);
        }
        r.setEvent(event);
        r.setPriority(priority);
        r.setRecord(record);
        this.log.add(r);
    }

    public void addLog(String event, String record) {
        this.addLog(event, "Low", record);
    }

    public void addLog(String record) {
        this.addLog("Misc.", "Low", record);
    }

    public void addLog(LogRecord r) {
        this.log.add(r);
    }

    public boolean intersect(double x0In, double y0In, double x1In, double y1In) {
        double[] result = MathUtil.intersectLineCircle(x0In, y0In, x1In, y1In, this.getXPosition(), this.getYPosition(), this.getRadius());
        if (result.length == 0) {
            return false;
        }
        double t1 = result[2];
        double t2 = result[5];
        if (t1 >= 0.0 && t1 <= 1.0) {
            return true;
        }
        return t2 >= 0.0 && t2 <= 1.0;
    }

    public boolean intersect(SpaceObject a, SpaceObject b) {
        return this.intersect(a.getXPosition(), a.getYPosition(), b.getXPosition(), b.getYPosition());
    }

    public boolean inside(SpaceObject a) {
        if (this.radius == 0.0) {
            return false;
        }
        return a.rangeTo(this) <= this.radius;
    }

    public double[] intersectionPoint(double x0In, double y0In, double x1In, double y1In) {
        double[] value = MathUtil.intersectLineCircle(x0In, y0In, x1In, y1In, this.getXPosition(), this.getYPosition(), this.getRadius());
        if (value.length == 0) {
            return null;
        }
        double t1 = value[2];
        double t2 = value[5];
        double[] result = new double[2];
        if (t1 >= 0.0 && t1 <= 1.0) {
            result[0] = value[0];
            result[1] = value[1];
            return result;
        }
        if (t2 >= 0.0 && t2 <= 1.0) {
            result[0] = value[3];
            result[1] = value[4];
            return result;
        }
        return null;
    }

    public String toString() {
        return "";
    }

    public String toXML() {
        return "";
    }

    public String toXML(int level) {
        return "";
    }
}

