/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.AntiMatterTorpedo;
import ftjava.std.AreaDefenseFireControl;
import ftjava.std.FighterGroup;
import ftjava.std.GameEngine;
import ftjava.std.Missile;
import ftjava.std.MissileSalvo;
import ftjava.std.PlasmaBolt;
import ftjava.std.Screen;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.StealthGenerator;
import ftjava.std.VapourShroud;
import java.util.ArrayList;

public class ShipUtilities {
    private ShipUtilities() {
    }

    public static boolean validateShip(Ship theShip) {
        ShipSystem s;
        int i;
        int evaluatedMass = 0;
        int evaluatedPoints = 0;
        int mass = theShip.getMass();
        int pointValue = theShip.getPointValue();
        evaluatedMass += theShip.getHull().computeMass();
        evaluatedPoints += theShip.getHull().computePointCost();
        evaluatedMass += theShip.getArmor().computeMass();
        evaluatedPoints += theShip.getArmor().computePointCost();
        if (theShip.getMainDrive() != null) {
            evaluatedMass += theShip.getMainDrive().computeMass(mass);
            evaluatedPoints += theShip.getMainDrive().computePointCost(mass);
        }
        if (theShip.getFTLDrive() != null) {
            evaluatedMass += theShip.getFTLDrive().computeMass(mass);
            evaluatedPoints += theShip.getFTLDrive().computePointCost(mass);
        }
        for (i = 0; i < theShip.getElectronicsSystems().size(); ++i) {
            s = (ShipSystem)theShip.getElectronicsSystems().get(i);
            evaluatedMass += s.computeMass();
            evaluatedPoints += s.computePointCost();
        }
        for (i = 0; i < theShip.getDefenseSystems().size(); ++i) {
            s = (ShipSystem)theShip.getDefenseSystems().get(i);
            if (s instanceof Screen || s instanceof VapourShroud || s instanceof StealthGenerator) {
                evaluatedMass += s.computeMass(mass);
                evaluatedPoints += s.computePointCost(mass);
                continue;
            }
            evaluatedMass += s.computeMass();
            evaluatedPoints += s.computePointCost();
        }
        for (i = 0; i < theShip.getShipHolds().size(); ++i) {
            s = (ShipSystem)theShip.getShipHolds().get(i);
            evaluatedMass += s.computeMass();
            evaluatedPoints += s.computePointCost();
        }
        for (i = 0; i < theShip.getWeaponSystems().size(); ++i) {
            s = (ShipSystem)theShip.getWeaponSystems().get(i);
            evaluatedMass += s.computeMass();
            evaluatedPoints += s.computePointCost();
        }
        if (mass != evaluatedMass || pointValue != evaluatedPoints) {
            System.out.println();
            System.out.println("Ship: " + theShip.getRace() + " " + theShip.getClassName());
            System.out.println("Reported:   " + mass + " Mass " + pointValue + " CPV value ");
            System.out.println("Evaluated:  " + evaluatedMass + " Mass " + evaluatedPoints + " CPV value ");
            return false;
        }
        return true;
    }

    public static boolean isPDSTarget(Ship ship, SpaceObject so, double range) {
        SpaceObject dObj = null;
        if (ship.getPlayer() == so.getPlayer()) {
            return false;
        }
        if (ship.getTeam().equals(so.getTeam())) {
            return false;
        }
        if (!ship.getOptions().getPDSFireAtShips() && so instanceof Ship) {
            return false;
        }
        if (so instanceof Ship && ((Ship)so).isDestroyed()) {
            return false;
        }
        if (so instanceof Ship && ((Ship)so).hasJumped()) {
            return false;
        }
        if (so instanceof Ship) {
            return ship.rangeTo(so) <= range;
        }
        if ((so instanceof PlasmaBolt || so instanceof AntiMatterTorpedo) && ship.rangeTo(so) <= range) {
            return true;
        }
        ArrayList adfc = ship.getActiveAreaDefenseFireControls();
        if (adfc.size() == 0) {
            FighterGroup fg;
            SpaceObject ms;
            if (ship.rangeTo(so) > range) {
                return false;
            }
            if (so instanceof MissileSalvo && ((MissileSalvo)(ms = (MissileSalvo)so)).getTargetId() != ship.getId()) {
                return false;
            }
            if (so instanceof Missile && ((Missile)(ms = (Missile)so)).getTargetId() != ship.getId()) {
                return false;
            }
            return !(so instanceof FighterGroup) || (fg = (FighterGroup)so).getTargetId() == ship.getId();
        }
        if (so instanceof MissileSalvo && ship.rangeTo(so) <= range) {
            return true;
        }
        if (so instanceof Missile && ship.rangeTo(so) <= range) {
            return true;
        }
        if (so instanceof FighterGroup && ship.rangeTo(so) <= range) {
            return true;
        }
        for (int i = 0; i < adfc.size(); ++i) {
            GameEngine ge;
            SpaceObject ms;
            AreaDefenseFireControl fc = (AreaDefenseFireControl)adfc.get(i);
            int defenseId = fc.getDefendedTargetId();
            if (defenseId == 0) continue;
            if (so instanceof MissileSalvo) {
                ms = (MissileSalvo)so;
                if (((MissileSalvo)ms).getTargetId() == 0) {
                    return false;
                }
                if (((MissileSalvo)ms).getTargetId() == defenseId) {
                    return true;
                }
            }
            if (so instanceof Missile) {
                ms = (Missile)so;
                if (((Missile)ms).getTargetId() == 0) {
                    return false;
                }
                if (((Missile)ms).getTargetId() == defenseId) {
                    return true;
                }
            }
            if (so instanceof FighterGroup) {
                FighterGroup fg = (FighterGroup)so;
                if (fg.getTargetId() == 0) {
                    return false;
                }
                if (fg.getTargetId() == defenseId) {
                    return true;
                }
            }
            if (!(so instanceof PlasmaBolt) && !(so instanceof AntiMatterTorpedo) || (dObj = (ge = ship.getGameEngine()).getObjectById(defenseId)) == null || !(dObj.rangeTo(so) <= range)) continue;
            return true;
        }
        return false;
    }

    public static boolean isScattergunTarget(Ship ship, SpaceObject so, ArrayList allShips, double range) {
        if (ship.getPlayer() == so.getPlayer()) {
            return false;
        }
        if (ship.getTeam().equals(so.getTeam())) {
            return false;
        }
        if (!ship.getOptions().getPDSFireAtShips() && so instanceof Ship) {
            return false;
        }
        if (so instanceof Ship && ((Ship)so).isDestroyed()) {
            return false;
        }
        if (so instanceof Ship && ((Ship)so).hasJumped()) {
            return false;
        }
        if (ship.rangeTo(so) > 2.0 * range) {
            return false;
        }
        if (so instanceof MissileSalvo) {
            return true;
        }
        if (so instanceof Missile) {
            return true;
        }
        if (so instanceof FighterGroup) {
            for (int i = 0; i < allShips.size(); ++i) {
                Ship aShip = (Ship)allShips.get(i);
                FighterGroup fg = (FighterGroup)so;
                if (ship.getTeam() != aShip.getTeam() || aShip.rangeTo(so) > ship.getOptions().getFighterRange() || fg.getTargetId() != aShip.getId()) continue;
                return true;
            }
            return false;
        }
        if (so instanceof PlasmaBolt) {
            return true;
        }
        if (so instanceof AntiMatterTorpedo) {
            return true;
        }
        return so instanceof Ship && ship.rangeTo(so) <= range;
    }

    public static boolean isPulserPDSTarget(Ship ship, SpaceObject so, int arcs, double range) {
        FighterGroup fg;
        SpaceObject ms;
        if (ship.getPlayer() == so.getPlayer()) {
            return false;
        }
        if (ship.getTeam().equals(so.getTeam())) {
            return false;
        }
        if (so instanceof Ship) {
            return false;
        }
        int fireArc = ship.arcTo(so);
        if ((arcs & fireArc) != fireArc) {
            return false;
        }
        if ((so instanceof PlasmaBolt || so instanceof AntiMatterTorpedo) && ship.rangeTo(so) < range) {
            return true;
        }
        ArrayList adfc = ship.getActiveAreaDefenseFireControls();
        if (adfc.size() == 0) {
            FighterGroup fg2;
            SpaceObject ms2;
            if (ship.rangeTo(so) > range) {
                return false;
            }
            if (so instanceof MissileSalvo && ((MissileSalvo)(ms2 = (MissileSalvo)so)).getTargetId() != ship.getId()) {
                return false;
            }
            if (so instanceof Missile && ((Missile)(ms2 = (Missile)so)).getTargetId() != ship.getId()) {
                return false;
            }
            return !(so instanceof FighterGroup) || (fg2 = (FighterGroup)so).getTargetId() == ship.getId();
        }
        if (so instanceof MissileSalvo && ((MissileSalvo)(ms = (MissileSalvo)so)).getTargetId() == ship.getId()) {
            return true;
        }
        if (so instanceof Missile && ((Missile)(ms = (Missile)so)).getTargetId() == ship.getId()) {
            return true;
        }
        if (so instanceof FighterGroup && (fg = (FighterGroup)so).getTargetId() == ship.getId()) {
            return true;
        }
        for (int i = 0; i < adfc.size(); ++i) {
            SpaceObject ms3;
            AreaDefenseFireControl fc = (AreaDefenseFireControl)adfc.get(i);
            int defenseId = fc.getDefendedTargetId();
            if (so instanceof MissileSalvo) {
                ms3 = (MissileSalvo)so;
                if (((MissileSalvo)ms3).getTargetId() == 0) {
                    return false;
                }
                if (((MissileSalvo)ms3).getTargetId() == defenseId) {
                    return true;
                }
            }
            if (so instanceof Missile) {
                ms3 = (Missile)so;
                if (((Missile)ms3).getTargetId() == 0) {
                    return false;
                }
                if (((Missile)ms3).getTargetId() == defenseId) {
                    return true;
                }
            }
            if (!(so instanceof FighterGroup)) continue;
            FighterGroup fg3 = (FighterGroup)so;
            if (fg3.getTargetId() == 0) {
                return false;
            }
            if (fg3.getTargetId() != defenseId) continue;
            return true;
        }
        return false;
    }

    public static boolean isClass1PDSTarget(Ship ship, SpaceObject so, double range) {
        FighterGroup fg;
        MissileSalvo ms;
        if (ship.getPlayer() == so.getPlayer()) {
            return false;
        }
        if (ship.getTeam().equals(so.getTeam())) {
            return false;
        }
        if (so instanceof Ship) {
            return false;
        }
        if (ship.rangeTo(so) > range) {
            return false;
        }
        if (so instanceof PlasmaBolt) {
            return false;
        }
        if (so instanceof AntiMatterTorpedo) {
            return false;
        }
        if (so instanceof MissileSalvo && (ms = (MissileSalvo)so).getTargetId() != ship.getId()) {
            return false;
        }
        return !(so instanceof FighterGroup) || (fg = (FighterGroup)so).getTargetId() == ship.getId();
    }
}

