/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.AntiMatterTorpedo;
import ftjava.std.FighterGroup;
import ftjava.std.Missile;
import ftjava.std.MissileSalvo;
import ftjava.std.PlasmaBolt;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.ShipUtilities;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class Scattergun
extends Weapon {
    public Scattergun() {
        this.setSystemName("Scattergun");
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setMaximumRange(this.getOptions().getScattergunRange());
        this.setFireTypePointDefense();
    }

    public void setValue(String Name, String Value) {
        boolean handled = false;
        if (Name.equals("targetId")) {
            this.setTargetId(Integer.parseInt(Value));
            handled = true;
        }
        if (!handled) {
            super.setValue(Name, Value);
        }
    }

    public void fireAt(SpaceObject firer) {
        this.fireAt(firer, this.getTarget());
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
        FighterGroup fg;
        DecimalFormat df = new DecimalFormat("0.0");
        ArrayList allShips = ((Ship)firer).getGameEngine().getShips();
        if (target == null) {
            return;
        }
        int kills = 0;
        int plasmaHits = 0;
        double rangeBand = this.getOptions().getScattergunRange();
        boolean hit = false;
        if (!(target instanceof MissileSalvo || target instanceof Missile || target instanceof FighterGroup || target instanceof PlasmaBolt || target instanceof AntiMatterTorpedo || target instanceof Ship)) {
            return;
        }
        if (!this.getSystemStatus().equals("Operational")) {
            return;
        }
        if (!ShipUtilities.isScattergunTarget((Ship)firer, target, allShips, rangeBand)) {
            return;
        }
        this.setFired();
        this.setExpended();
        double range = firer.rangeTo(target) * target.getRangeStealthModifier();
        String playTestResults = " R=" + df.format(firer.rangeTo(target)) + "/" + df.format(range) + " ";
        String targetName = target.getName();
        if (target instanceof Ship) {
            String record;
            int die = Dice.rollD6(firer.getCrewQuality());
            playTestResults = playTestResults + "(" + die + ") ";
            if (range > rangeBand) {
                die = 1;
            }
            int[] damage = new int[1];
            if (die == 4 || die == 5) {
                hit = true;
                damage[0] = 1;
                if (this.getOptions().getPlayTest()) {
                    this.setNotes("Hit the " + targetName + " for one point." + playTestResults);
                    record = firer.getName() + " hit for one point " + " with a scattergun." + playTestResults;
                } else {
                    this.setNotes("Hit the " + targetName + " for one point.");
                    record = firer.getName() + " hit for one point " + " with a scattergun.";
                }
                target.addLog("Attack", "High", record);
            }
            if (die == 6) {
                hit = true;
                damage[0] = 2;
                if (this.getOptions().getPlayTest()) {
                    this.setNotes("Hit the " + targetName + " for two points." + playTestResults);
                    record = firer.getName() + " hit for two points " + " with a scattergun." + playTestResults;
                } else {
                    this.setNotes("Hit the " + targetName + " for two points.");
                    record = firer.getName() + " hit for two points " + " with a scattergun.";
                }
                target.addLog("Attack", "High", record);
            }
            if (!hit) {
                if (this.getOptions().getPlayTest()) {
                    this.setNotes("Missed the " + targetName + "." + playTestResults);
                    record = firer.getName() + " missed with a scattergun." + playTestResults;
                } else {
                    this.setNotes("Missed the " + targetName + ".");
                    record = firer.getName() + " missed with a scattergun.";
                }
                target.addLog("Attack", "Medium", record);
                return;
            }
            Ship s = (Ship)target;
            s.takeDamage(damage);
            return;
        }
        int die = Dice.rollD6(firer.getCrewQuality());
        playTestResults = playTestResults + "(" + die + ") ";
        if (target instanceof MissileSalvo) {
            kills = die;
            hit = true;
        } else if (target instanceof FighterGroup) {
            hit = true;
            fg = (FighterGroup)target;
            if (fg.getType().isAHeavyFighter()) {
                switch (die) {
                    case 1: 
                    case 2: {
                        kills = 1;
                        break;
                    }
                    case 3: 
                    case 4: {
                        kills = 2;
                        break;
                    }
                    case 5: 
                    case 6: {
                        kills = 3;
                    }
                }
            } else {
                kills = die;
            }
        } else if (target instanceof PlasmaBolt) {
            switch (die) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    plasmaHits = 1;
                    hit = true;
                    break;
                }
                case 6: {
                    plasmaHits = 2;
                    hit = true;
                }
            }
        } else if (target instanceof AntiMatterTorpedo || target instanceof Missile) {
            switch (die) {
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    plasmaHits = 1;
                    hit = true;
                    break;
                }
                case 5: 
                case 6: {
                    plasmaHits = 2;
                    hit = true;
                }
            }
        }
        if (!hit) {
            this.setNotes("Missed the " + targetName + ".");
            if (target instanceof FighterGroup) {
                target.addLog("Status", "Low", firer.getName() + "missed with " + "a Scattergun.");
            }
            return;
        }
        if (target instanceof PlasmaBolt || target instanceof AntiMatterTorpedo || target instanceof Missile) {
            this.setNotes("Hit the " + targetName + " for " + StringUtils.points(plasmaHits) + ".");
        } else {
            if (target instanceof FighterGroup) {
                target.addLog("Attack", "High", firer.getName() + " hit for " + StringUtils.kills(kills) + " with a Scattergun.");
            }
            this.setNotes("Hit the " + targetName + " for " + StringUtils.kills(kills) + ".");
        }
        if (this.getOptions().getPlayTest()) {
            this.appendNotes(playTestResults);
        }
        if (target instanceof MissileSalvo) {
            MissileSalvo ms = (MissileSalvo)target;
            ms.takeDamage(new int[]{kills});
        }
        if (target instanceof PlasmaBolt || target instanceof AntiMatterTorpedo || target instanceof Missile) {
            target.takeDamage(new int[]{plasmaHits});
        }
        if (target instanceof FighterGroup) {
            fg = (FighterGroup)target;
            fg.takeDamage(new int[]{kills});
        }
    }

    public int computeMass() {
        return 1;
    }

    public int computePointCost() {
        return 5;
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String sep = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        StringBuffer sb = new StringBuffer();
        if (level >= 6) {
            return "";
        }
        sb.append(t + t + "<Scattergun");
        if (level > 0) {
            sb.append(" id=\"" + this.getId() + "\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        if (level == 2 || level == 1) {
            sb.append(" targetId=\"" + this.getTargetId() + "\"");
        }
        if (level != 0 && level != 5) {
            sb.append(" status=\"" + this.getSystemStatus() + "\"");
            if (!this.isRecharged()) {
                sb.append(" recharge=\"" + this.getRecharge() + "\"");
            }
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"" + this.getNotes() + "\"");
        }
        sb.append("/>" + sep);
        return sb.toString();
    }

    static {
        Weapon.addSystem("Scattergun", new Scattergun());
    }
}

