/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.MissileSalvo;
import ftjava.std.SalvoMissileMagazine;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.XMLUtilities;

public class SalvoMissileLauncher
extends Weapon {
    private int salvoMagazineId;

    public SalvoMissileLauncher() {
        this(Weapon.FRONT_ARCS);
    }

    public SalvoMissileLauncher(String arcString) {
        this(Weapon.parseArcString(arcString));
    }

    public SalvoMissileLauncher(int a) {
        this.setArcs(a);
        this.setSystemName("Salvo Missile Launcher " + this.getArcsString());
        this.salvoMagazineId = 0;
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setFireTypeLaunched();
    }

    public void setValue(String Name, String Value) {
        boolean handled = false;
        if (Name.equals("arcs")) {
            this.setArcs(Weapon.parseArcString(Value));
            this.setSystemName("Salvo Missile Launcher " + this.getArcsString());
            handled = true;
        }
        if (Name.equals("smmId")) {
            this.setSalvoMagazineId(Integer.valueOf(Value));
            handled = true;
        }
        if (!handled) {
            super.setValue(Name, Value);
        }
    }

    public void setSalvoMagazineId(int id) {
        this.salvoMagazineId = id;
    }

    public int getSalvoMagazineId() {
        return this.salvoMagazineId;
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
    }

    public boolean canLaunch(SpaceObject firer, MissileSalvo ms) {
        if (!this.getSystemStatus().equals("Operational")) {
            return false;
        }
        if (this.hasFired()) {
            return false;
        }
        double range = firer.rangeTo(ms);
        if (range > this.getOptions().getSalvoMissileExtendedRange()) {
            return false;
        }
        if (range > this.getOptions().getSalvoMissileRange() && ms.getSalvoType() == "Standard Salvo") {
            return false;
        }
        if (!this.fireAtTargetArc(firer.arcTo(ms))) {
            return false;
        }
        Ship s = (Ship)firer;
        Weapon w = s.getWeaponById(this.getSalvoMagazineId());
        SalvoMissileMagazine smm = (SalvoMissileMagazine)w;
        return smm.isOneAvailable(ms.getSalvoType());
    }

    public void fireSalvo(SpaceObject firer, MissileSalvo ms) {
        this.setFired();
        Ship s = (Ship)firer;
        Weapon w = s.getWeaponById(this.getSalvoMagazineId());
        SalvoMissileMagazine smm = (SalvoMissileMagazine)w;
        smm.expendOne(ms.getSalvoType());
    }

    public int computeMass() {
        return 3;
    }

    public int computePointCost() {
        return 9;
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String sep = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        StringBuffer sb = new StringBuffer();
        if (level >= 6) {
            return "";
        }
        sb.append(t + t + "<SalvoMissileLauncher");
        if (level > 0) {
            sb.append(" id=\"" + this.getId() + "\"");
            sb.append(" smmId=\"" + this.getSalvoMagazineId() + "\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" arcs=\"" + this.getArcsString() + "\"");
        if (level != 0 && level != 5) {
            sb.append(" status=\"" + this.getSystemStatus() + "\"");
            if (!this.isRecharged()) {
                sb.append(" recharge=\"" + this.getRecharge() + "\"");
            }
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"" + this.getNotes() + "\"");
        }
        sb.append("/>" + sep);
        return sb.toString();
    }

    static {
        Weapon.addSystem("SalvoMissileLauncher", new SalvoMissileLauncher());
    }
}

