/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.AntiMatterTorpedo;
import ftjava.std.FighterGroup;
import ftjava.std.GameEngine;
import ftjava.std.MissileSalvo;
import ftjava.std.PlasmaBolt;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import ftjava.util.Dice;
import ftjava.util.MathUtil;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;

public class NovaCannonBolt
extends SpaceObject {
    private String team = "";
    private int age = 0;
    private int launchingShipId = 0;
    private int launcherId = 0;
    private boolean hasAttacked = false;

    public void setName() {
        this.setName("NC " + this.getId());
    }

    public void setTeam(String s) {
        this.team = s;
    }

    public String getTeam() {
        return this.team;
    }

    public void setAge(int s) {
        this.age = s;
    }

    public int getAge() {
        return this.age;
    }

    public void incrementAge() {
        ++this.age;
    }

    public void setLaunchingShipId(int id) {
        this.launchingShipId = id;
    }

    public int getLaunchingShipId() {
        return this.launchingShipId;
    }

    public void setLauncherId(int id) {
        this.launcherId = id;
    }

    public int getLauncherId() {
        return this.launcherId;
    }

    public void setHasAttacked(boolean b) {
        this.hasAttacked = b;
    }

    public boolean hasAttacked() {
        return this.hasAttacked;
    }

    private Ship getLaunchingShip() {
        return this.getGameEngine().getShipById(this.launchingShipId);
    }

    public void takeDamage(int[] hits) {
    }

    public void fireAt() {
        String playTestResults = "";
        this.setHasAttacked(true);
        double blastRadius = 2.0 * (double)this.age;
        double length = 18.0;
        if (this.age > 1) {
            length = 24.0;
        }
        int[] damage = new int[1];
        GameEngine game = this.getGameEngine();
        ArrayList allObjects = game.getActiveObjects();
        for (int i = 0; i < allObjects.size(); ++i) {
            SpaceObject so = (SpaceObject)allObjects.get(i);
            if (so instanceof NovaCannonBolt || so instanceof PlasmaBolt || so instanceof AntiMatterTorpedo || !this.inRange(so, length, blastRadius)) continue;
            damage[0] = 0;
            playTestResults = "";
            int strength = 8 - this.age * 2;
            for (int j = 0; j < strength; ++j) {
                int die = Dice.rollD6();
                playTestResults = playTestResults + "(" + die + ") ";
                damage[0] = damage[0] + die;
            }
            String record = this.getName() + ": Nova Cannon hit for " + StringUtils.points(damage[0]) + ".";
            String report = this.getName() + " hit " + so.getName() + " for " + StringUtils.points(damage[0]) + ".";
            if (this.getOptions().getPlayTest()) {
                record = record + " " + playTestResults;
                report = report + " " + playTestResults;
            }
            game.addTurnReport("Attack", "High", report);
            if (so instanceof MissileSalvo) {
                ((MissileSalvo)so).takeDamage(damage);
            }
            if (so instanceof FighterGroup) {
                if (((FighterGroup)so).isOnBoard()) continue;
                ((FighterGroup)so).takeDamage(damage);
            }
            if (!so.isShip()) continue;
            ((Ship)so).takeDamage(damage);
            so.addLog("Attack", "High", record);
        }
    }

    public void moveBolt() {
        double xP = this.getXPosition();
        double yP = this.getYPosition();
        double length = 0.0;
        if (this.getAge() == 1) {
            length = 18.0;
        }
        if (this.getAge() > 1) {
            length = 24.0;
        }
        this.setXPosition(xP + length * MathUtil.X(this.getHeading()));
        this.setYPosition(yP + length * MathUtil.Y(this.getHeading()));
        this.incrementAge();
    }

    private boolean inRange(SpaceObject so, double length, double radius) {
        double xP = this.getXPosition();
        double yP = this.getYPosition();
        double xE = xP + length * MathUtil.X(this.getHeading());
        double yE = yP + length * MathUtil.Y(this.getHeading());
        double xO = so.getXPosition();
        double yO = so.getYPosition();
        double d1 = MathUtil.distance(xO, yO, xP, yP);
        double d2 = MathUtil.distance(xO, yO, xE, yE);
        if (d1 <= radius) {
            return true;
        }
        if (d2 <= radius) {
            return true;
        }
        double dx = xE - xP;
        double dy = yE - yP;
        double t = ((xO - xP) * dx + (yO - yP) * dy) / (dx * dx + dy * dy);
        if (t < 0.0 || t > 1.0) {
            return false;
        }
        double xN = xP + t * dx;
        double yN = yP + t * dy;
        double d3 = MathUtil.distance(xO, yO, xN, yN);
        return d3 <= radius;
    }

    public String toString() {
        String result = "";
        String newLine = System.getProperty("line.separator");
        DecimalFormat df = new DecimalFormat("0.0");
        result = result + this.getRace() + " nova cannon bolt" + newLine;
        result = result + "Age:  " + this.age + newLine;
        result = result + newLine;
        result = result + "Position: ";
        result = result + df.format(this.getXPosition()) + ", ";
        result = result + df.format(this.getYPosition()) + newLine;
        return result;
    }

    private String ind(int level) {
        if (level > 0) {
            return XMLUtilities.getIndent() + XMLUtilities.getIndent();
        }
        return "";
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String s = "";
        String sep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String t = XMLUtilities.getIndent();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat df = new DecimalFormat("0.0");
        df.setDecimalFormatSymbols(dfs);
        if (level == 10) {
            return s;
        }
        sb.append(this.ind(level) + "<NovaCannonBolt");
        if (level >= 1) {
            sb.append(" id=\"" + this.getId() + "\">" + sep);
        } else {
            sb.append(">" + sep);
        }
        if (level >= 1) {
            sb.append(this.ind(level) + t);
            sb.append("<Age>" + this.getAge() + "</Age>" + sep);
            sb.append(this.ind(level) + t + "<Position ");
            sb.append("x=\"" + df.format(this.getXPosition()) + "\" ");
            sb.append("y=\"" + df.format(this.getYPosition()) + "\"/>" + sep);
            sb.append(this.ind(level) + t);
            sb.append("<Heading heading=\"" + this.getHeading() + "\"/>" + sep);
            sb.append(this.ind(level) + t);
            sb.append("<Race>" + this.getRace() + "</Race>" + sep);
            if (this.getIconFamily() != null) {
                sb.append(this.ind(level)).append(t);
                sb.append("<IconFamily value=\"");
                sb.append(this.getIconFamily());
                sb.append("\"/>").append(sep);
            }
            sb.append(this.ind(level) + t);
            sb.append("<Ship id=\"" + this.getLaunchingShipId());
            sb.append("\"/>" + sep);
            sb.append(this.ind(level) + t);
            sb.append("<Launcher id=\"" + this.getLauncherId());
            sb.append("\"/>" + sep);
        }
        sb.append(this.ind(level) + "</NovaCannonBolt>" + sep);
        return sb.toString();
    }

    public String movementOrdersToXML() {
        if (this.getAge() > 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        String sep = "\n";
        String t = XMLUtilities.getIndent();
        Ship s = this.getLaunchingShip();
        if (s.hasActiveVapourShroud()) {
            return "";
        }
        sb.append(t + t + "<LaunchNovaBolt ");
        sb.append("shipId=\"" + this.getLaunchingShipId() + "\" ");
        sb.append("launcherId=\"" + this.getLauncherId() + "\" ");
        sb.append("x=\"" + this.getXPosition() + "\" ");
        sb.append("y=\"" + this.getYPosition() + "\" ");
        sb.append("heading=\"" + this.getHeading() + "\"/>");
        sb.append(sep);
        return sb.toString();
    }
}

