/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.GameEngine;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;

public class MissileSalvo
extends SpaceObject {
    private String team = "";
    private String race = "";
    private int count = 6;
    private int launchingShipId = 0;
    private int launcherId = 0;
    private SpaceObject target = null;
    private int targetId = 0;
    private String salvoType = "Standard Salvo";
    private boolean hasAttacked = false;

    public void setName() {
        this.setName("SM " + this.getId());
    }

    public void setTeam(String s) {
        this.team = s;
    }

    public String getTeam() {
        return this.team;
    }

    public void setRace(String s) {
        this.race = s;
    }

    public String getRace() {
        return this.race;
    }

    public void setCount(int t) {
        this.count = t;
    }

    public int getCount() {
        return this.count;
    }

    public void setLaunchingShipId(int id) {
        this.launchingShipId = id;
    }

    public int getLaunchingShipId() {
        return this.launchingShipId;
    }

    public void setLauncherId(int id) {
        this.launcherId = id;
    }

    public int getLauncherId() {
        return this.launcherId;
    }

    public void setTarget(SpaceObject t) {
        this.target = t;
    }

    public SpaceObject getTarget() {
        return this.target;
    }

    public void setTargetId(int t) {
        this.targetId = t;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public void setSalvoType(String s) {
        this.salvoType = s;
    }

    public String getSalvoType() {
        return this.salvoType;
    }

    public void setHasAttacked(boolean b) {
        this.hasAttacked = b;
    }

    public boolean hasAttacked() {
        return this.hasAttacked;
    }

    private Ship getLaunchingShip() {
        return this.getGameEngine().getShipById(this.launchingShipId);
    }

    private Weapon getLauncher() {
        Ship s = this.getLaunchingShip();
        if (s == null) {
            return null;
        }
        return s.getWeaponById(this.launcherId);
    }

    public double getMaximumRange() {
        double result = this.getOptions().getSalvoMissileRange();
        if (this.getSalvoType().indexOf("Extended") > -1) {
            result = this.getOptions().getSalvoMissileExtendedRange();
        }
        return result;
    }

    public void takeDamage(int[] hits) {
        for (int i = 0; i < hits.length; ++i) {
            this.count -= hits[i];
        }
        if (this.count < 0) {
            this.count = 0;
        }
    }

    public void acquireTarget(ArrayList allShips, double lockOnRange) {
        SpaceObject bestShipSoFar = null;
        double bestShipRange = lockOnRange;
        Weapon launcher = this.getLauncher();
        for (int i = 0; i < allShips.size(); ++i) {
            double thisRange;
            Ship s;
            SpaceObject o = (SpaceObject)allShips.get(i);
            if (!(o instanceof Ship) || (s = (Ship)o).isDestroyed() || s.hasJumped() || s.getTeam().equals(this.getTeam()) || !s.hasArrived() || (thisRange = this.rangeTo(s) * s.getRangeStealthModifier()) > lockOnRange || bestShipSoFar != null && thisRange >= bestShipRange) continue;
            bestShipSoFar = s;
            bestShipRange = thisRange;
        }
        if (bestShipSoFar != null) {
            this.setTarget(bestShipSoFar);
            this.setTargetId(bestShipSoFar.getId());
            this.target.addLog("Attack", "Medium", this.getName() + ": Salvo missiles targeting.");
            launcher.setNotes("Targeting " + this.target.getName());
        } else {
            launcher.setNotes("No targets in range.");
        }
    }

    public int missilesLockingOn() {
        int die;
        Weapon launcher = this.getLauncher();
        this.target = this.getGameEngine().getShipById(this.targetId);
        if (this.targetId == 0 || this.target == null) {
            return 0;
        }
        this.count = die = Dice.rollD6();
        String playTestResults = "" + StringUtils.upperNumber(die) + " missiles lock on to " + this.target.getName();
        launcher.setNotes(playTestResults);
        if (die == 1) {
            this.target.addLog("Attack", "Medium", this.getName() + ": " + StringUtils.upperNumber(die) + " missile locking on.");
        } else {
            this.target.addLog("Attack", "Medium", this.getName() + ": " + StringUtils.upperNumber(die) + " missiles locking on.");
        }
        return this.count;
    }

    public void fireAt() {
        String record;
        String playTestResults = "";
        Weapon launcher = this.getLauncher();
        this.setHasAttacked(true);
        this.target = this.getGameEngine().getShipById(this.targetId);
        if (this.targetId == 0 || this.target == null) {
            return;
        }
        if (launcher == null) {
            throw new RuntimeException("No launcher for Salvo");
        }
        Ship s = (Ship)this.target;
        if (this.count == 0) {
            launcher.setNotes("No missiles got through.");
            return;
        }
        String targetName = this.target.getName();
        int[] damageArray = new int[]{0, 0};
        int attackingMissiles = this.count;
        while (this.count > 0) {
            int damage = Dice.rollD6();
            playTestResults = playTestResults + "(" + damage + ") ";
            int armorDamage = (int)Math.ceil((double)damage / 2.0);
            int hullDamage = damage - armorDamage;
            damageArray[0] = damageArray[0] + armorDamage;
            damageArray[1] = damageArray[1] + hullDamage;
            --this.count;
        }
        int totalDamage = damageArray[0] + damageArray[1];
        String missiles = " missiles.";
        if (attackingMissiles == 1) {
            missiles = " missile.";
        }
        if (this.getOptions().getPlayTest()) {
            launcher.setNotes("Hit the " + targetName + " for " + StringUtils.points(totalDamage) + " from " + StringUtils.number(attackingMissiles) + missiles + playTestResults);
            record = "Salvo hit for " + StringUtils.points(totalDamage) + " from " + StringUtils.number(attackingMissiles) + missiles + playTestResults;
        } else {
            launcher.setNotes("Hit the " + targetName + " for " + StringUtils.points(totalDamage) + " from " + StringUtils.number(attackingMissiles) + missiles);
            record = this.getName() + ": Salvo hit for " + StringUtils.points(totalDamage) + " from " + StringUtils.number(attackingMissiles) + missiles;
        }
        this.target.addLog("Attack", "High", record);
        s.takeDamage(damageArray);
        if (totalDamage >= 20) {
            GameEngine ge = this.getGameEngine();
            record = this.getName() + " hit " + targetName + " for " + StringUtils.points(totalDamage) + " from " + StringUtils.number(attackingMissiles) + missiles;
            ge.addTurnReport("Attack", "High", record);
        }
    }

    public String toString() {
        String result = "";
        String newLine = "\n";
        DecimalFormat df = new DecimalFormat("0.0");
        result = result + this.team + " " + this.getName() + newLine;
        while (result.length() < this.getOptions().getStatusSpacing()) {
            result = result + " ";
        }
        result = this.target != null ? result + "[" + this.target.getName() + "]" + newLine : result + newLine;
        result = result + "Count:  " + this.count + newLine;
        result = result + newLine;
        result = result + "Position: ";
        result = result + df.format(this.getXPosition()) + ", ";
        result = result + df.format(this.getYPosition()) + newLine;
        return result;
    }

    private String ind(int level) {
        if (level > 0) {
            return XMLUtilities.getIndent() + XMLUtilities.getIndent();
        }
        return "";
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String s = "";
        String sep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String t = XMLUtilities.getIndent();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat df = new DecimalFormat("0.0");
        df.setDecimalFormatSymbols(dfs);
        if (level == 10) {
            return s;
        }
        sb.append(this.ind(level) + "<MissileSalvo");
        if (level >= 1) {
            sb.append(" id=\"" + this.getId() + "\">" + sep);
        } else {
            sb.append(">" + sep);
        }
        if (level >= 1) {
            sb.append(this.ind(level) + t);
            sb.append("<SalvoType>" + this.getSalvoType() + "</SalvoType>" + sep);
            sb.append(this.ind(level) + t + "<Position ");
            sb.append("x=\"" + df.format(this.getXPosition()) + "\" ");
            sb.append("y=\"" + df.format(this.getYPosition()) + "\"/>" + sep);
            sb.append(this.ind(level) + t);
            sb.append("<Heading heading=\"" + this.getHeading() + "\"/>" + sep);
            sb.append(this.ind(level) + t);
            sb.append("<Race>" + this.getRace() + "</Race>" + sep);
            if (this.getIconFamily() != null) {
                sb.append(this.ind(level)).append(t);
                sb.append("<IconFamily value=\"");
                sb.append(this.getIconFamily());
                sb.append("\"/>").append(sep);
            }
            sb.append(this.ind(level) + t);
            sb.append("<Ship id=\"" + this.getLaunchingShipId());
            sb.append("\"/>" + sep);
            sb.append(this.ind(level) + t);
            sb.append("<Launcher id=\"" + this.getLauncherId());
            sb.append("\"/>" + sep);
            if (this.getTargetId() != 0) {
                sb.append(this.ind(level) + t);
                sb.append("<Target id=\"" + this.getTargetId());
                sb.append("\"/>" + sep);
            }
        }
        sb.append(this.ind(level) + "</MissileSalvo>" + sep);
        return sb.toString();
    }

    public String movementOrdersToXML() {
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        sb.append(t + t + "<LaunchSalvo ");
        sb.append("shipId=\"" + this.getLaunchingShipId() + "\" ");
        sb.append("launcherId=\"" + this.getLauncherId() + "\" ");
        sb.append("x=\"" + this.getXPosition() + "\" ");
        sb.append("y=\"" + this.getYPosition() + "\" ");
        sb.append("heading=\"" + this.getHeading() + "\" ");
        sb.append("salvoType=\"" + this.getSalvoType() + "\"/>");
        sb.append(sep);
        return sb.toString();
    }
}

