/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.ShipSystem;
import ftjava.util.Dice;
import ftjava.util.XMLUtilities;

public class MainDrive
extends ShipSystem {
    public static final String STANDARD = "Standard";
    public static final String ADVANCED = "Advanced";
    private int initialThrust;
    private int currentThrust;
    private int damageLevel;
    private String type;
    private boolean active;

    public MainDrive(int rating) {
        this.initialThrust = rating;
        this.currentThrust = rating;
        this.damageLevel = 0;
        this.active = false;
        this.setSystemName("Main Drive");
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setType(STANDARD);
    }

    public MainDrive() {
        this(2);
    }

    public void setThrustRating(int rating) {
        this.initialThrust = rating;
        this.currentThrust = rating;
    }

    public void setInitialThrust(int rating) {
        this.initialThrust = rating;
    }

    public void setCurrentThrust(int rating) {
        this.currentThrust = rating;
        if (this.currentThrust == 0) {
            this.damageLevel = 2;
        }
    }

    public void setDamageLevel(int rating) {
        this.damageLevel = rating;
    }

    public int getInitialThrust() {
        return this.initialThrust;
    }

    public int getCurrentThrust() {
        return this.currentThrust;
    }

    public void setActive(boolean tf) {
        this.active = tf;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setType(String s) {
        this.type = s;
    }

    public String getType() {
        return this.type;
    }

    public boolean isAdvanced() {
        return this.type.equals(ADVANCED);
    }

    public void setSystemStatus(String s) {
        super.setSystemStatus(s);
        if (this.isOperational()) {
            this.damageLevel = 0;
        }
        if (this.isDamaged()) {
            this.damageLevel = 1;
            if (this.currentThrust == 0) {
                this.damageLevel = 2;
            }
        }
    }

    public void takeThresholdCheck(int level) {
        int die = Dice.rollD6();
        String playTestResults = "TC:(" + die + ") ";
        if (this.getOptions().getPlayTest()) {
            this.appendNotes(playTestResults);
        }
        if (die < level) {
            return;
        }
        this.setDamaged();
        ++this.damageLevel;
        this.currentThrust = (int)Math.floor((double)this.initialThrust / 2.0);
        if (this.damageLevel >= 2) {
            this.currentThrust = 0;
        }
        if (this.getOptions().getThresholdDamagedSystems()) {
            if (this.damageLevel >= 3) {
                this.setDestroyed();
            }
        } else if (this.damageLevel >= 3) {
            this.damageLevel = 2;
        }
    }

    public String attemptRepair(int teams) {
        return this.attemptRepair("First Rate", teams);
    }

    public String attemptRepair(String crewQuality, int teams) {
        String playTestResults = "";
        String result = null;
        boolean progress = false;
        if (this.damageLevel == 0 || this.damageLevel == 3) {
            return result;
        }
        int die = Dice.rollD6(crewQuality);
        playTestResults = playTestResults + "DC:(" + die + ") ";
        if (this.getOptions().getPlayTest()) {
            this.appendNotes(playTestResults);
        }
        if (die == 6 && teams > 0) {
            progress = true;
        } else if (die >= 5 && teams > 1) {
            progress = true;
        } else if (die >= 4 && teams > 2) {
            progress = true;
        }
        if (progress) {
            --this.damageLevel;
            result = "Main Drive has been partially repaired.";
            this.currentThrust = (int)Math.floor((double)this.initialThrust / 2.0);
        }
        if (this.damageLevel <= 0) {
            this.damageLevel = 0;
            this.currentThrust = this.initialThrust;
            this.setRepaired();
            result = "Main Drive has been fully repaired.";
        }
        return result;
    }

    public int computeMass(int shipMass) {
        int mass = (int)Math.round(0.05 * (double)shipMass * (double)this.initialThrust);
        if (mass <= 0) {
            mass = 1;
        }
        return mass;
    }

    public int computePointCost(int shipMass) {
        int cost = 2 * this.computeMass(shipMass);
        if (this.getType().equals(ADVANCED)) {
            cost = 3 * this.computeMass(shipMass);
        }
        return cost;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("   Main Drive: " + this.initialThrust);
        if (this.getType().equals(ADVANCED)) {
            sb.append("A");
        }
        if (!this.getSystemStatus().equals("Operational")) {
            sb.append(" (" + this.currentThrust + ")  ");
            while (sb.length() < this.getOptions().getStatusSpacing()) {
                sb.append(" ");
            }
            sb.append(this.getSystemStatus());
        }
        return sb.toString();
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String t = XMLUtilities.getIndent();
        String sep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        if (level >= 7) {
            return "";
        }
        sb.append(t + "<MainDrive ");
        if (level > 0) {
            sb.append("id=\"" + this.getId() + "\" ");
        }
        sb.append("type=\"" + this.getType() + "\" ");
        sb.append("initialThrust=\"" + this.initialThrust + "\" ");
        if (level != 0 && level != 5 && level != 6) {
            sb.append("currentThrust=\"" + this.currentThrust + "\" ");
            sb.append("status=\"" + this.getSystemStatus() + "\" ");
        }
        sb.append("active=\"" + this.isActive() + "\" ");
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append("notes=\"" + this.getNotes() + "\"");
        }
        sb.append("/>" + sep);
        return sb.toString();
    }
}

