/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.FighterGroup;
import ftjava.std.MissileSalvo;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;

public class KineticGun
extends Weapon {
    private int rating;
    private int[] damage;
    private int[] doubleDamage;

    public KineticGun() {
        this(1, Weapon.ALL_ARCS);
    }

    public KineticGun(String arcString) {
        this(2, Weapon.parseArcString(arcString));
    }

    public KineticGun(int gunClass, int arcCoverage) {
        this.rating = gunClass;
        this.setArcs(arcCoverage);
        this.setDamageArrays();
        this.setSystemName("Class " + this.rating + " Kinetic gun " + this.getArcsString());
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
        this.setMaximumRange(5.0 * this.getOptions().getKineticGunRangeBand());
    }

    public int getRating() {
        return this.rating;
    }

    public void setValue(String Name, String Value) {
        boolean handled = false;
        if (Name.equals("rating")) {
            this.rating = Integer.parseInt(Value);
            this.setDamageArrays();
            this.setSystemName("Class " + this.rating + " Kinetic gun " + this.getArcsString());
            handled = true;
        }
        if (Name.equals("targetId")) {
            this.setTargetId(Integer.parseInt(Value));
            handled = true;
        }
        if (Name.equals("arcs")) {
            this.setArcs(Weapon.parseArcString(Value));
            this.setSystemName("Class " + this.rating + " Kinetic gun " + this.getArcsString());
            handled = true;
        }
        if (!handled) {
            super.setValue(Name, Value);
        }
    }

    public void fireAt(SpaceObject firer, SpaceObject target) {
        boolean pdsMode = false;
        if (this.rating == 1 && (target instanceof MissileSalvo || target instanceof FighterGroup)) {
            pdsMode = true;
        }
        if (!this.isRecharged()) {
            this.setNotes("Weapon is recharging.");
            return;
        }
        if (!this.getSystemStatus().equals("Operational")) {
            return;
        }
        if (!pdsMode && !(target instanceof Ship)) {
            return;
        }
        if (!this.fireAtTargetArc(firer.arcTo(target))) {
            return;
        }
        if (pdsMode) {
            this.fireAtPointDefense(firer, target);
        } else {
            this.fireAtDirectFire(firer, target);
        }
    }

    private void fireAtDirectFire(SpaceObject firer, SpaceObject target) {
        String record;
        DecimalFormat df = new DecimalFormat("0.0");
        double rangeBand = this.getOptions().getKineticGunRangeBand();
        double range = firer.rangeTo(target) * target.getRangeStealthModifier();
        String targetName = target.getName();
        if (firer.rangeTo(target) > this.getMaximumRange()) {
            return;
        }
        this.setFired();
        String playTestResults = " R=" + df.format(firer.rangeTo(target)) + "/" + df.format(range) + " ";
        int die = Dice.rollD6(firer.getCrewQuality());
        playTestResults = playTestResults + "(" + die + ") ";
        boolean hit = false;
        if (die == 1) {
            hit = false;
        }
        if (die == 6 && range <= 5.0 * rangeBand) {
            hit = true;
        }
        if (die >= 5 && range <= 4.0 * rangeBand) {
            hit = true;
        }
        if (die >= 4 && range <= 3.0 * rangeBand) {
            hit = true;
        }
        if (die >= 3 && range <= 2.0 * rangeBand) {
            hit = true;
        }
        if (die >= 2 && range <= rangeBand) {
            hit = true;
        }
        if (!hit) {
            String record2;
            if (this.getOptions().getPlayTest()) {
                this.setNotes("Missed the " + targetName + ". " + playTestResults);
                record2 = firer.getName() + " missed with a class " + this.getRating() + " kinetic gun. " + playTestResults;
            } else {
                this.setNotes("Missed the " + targetName + ".");
                record2 = firer.getName() + " missed with a class " + this.getRating() + " kinetic gun.";
            }
            target.addLog("Attack", "Medium", record2);
            return;
        }
        die = Dice.rollD6();
        int damage = this.rating;
        if (die != 6 && die <= this.rating) {
            damage *= 2;
        }
        playTestResults = playTestResults + "(" + die + " " + damage + ") ";
        int armorDamage = 1;
        int hullDamage = damage - armorDamage;
        if (this.getOptions().getPlayTest()) {
            this.setNotes("Hit the " + targetName + " for " + StringUtils.number(armorDamage) + " armor and " + StringUtils.number(hullDamage) + " hull points." + playTestResults);
            record = firer.getName() + " hit for " + StringUtils.points(damage) + " with a Class " + this.getRating() + " kinetic gun." + playTestResults;
        } else {
            this.setNotes("Hit the " + targetName + " for " + StringUtils.points(damage) + ".");
            record = firer.getName() + " hit for " + StringUtils.points(damage) + " with a Class " + this.getRating() + " kinetic gun.";
        }
        target.addLog("Attack", "High", record);
        Ship s = (Ship)target;
        int[] r_val = new int[]{0};
        if (damage == this.damage.length) {
            r_val = new int[this.damage.length];
            System.arraycopy(this.damage, 0, r_val, 0, this.damage.length);
        } else if (damage == this.doubleDamage.length) {
            r_val = new int[this.doubleDamage.length];
            System.arraycopy(this.doubleDamage, 0, r_val, 0, this.doubleDamage.length);
        }
        s.takeDamage(r_val);
    }

    private void fireAtPointDefense(SpaceObject firer, SpaceObject target) {
        int[] damage = new int[1];
        DecimalFormat df = new DecimalFormat("0.0");
        int dice = 0;
        int totalDamage = 0;
        double rangeBand = this.getOptions().getPointDefenseRange();
        double range = firer.rangeTo(target) * target.getRangeStealthModifier();
        dice = this.rating;
        this.setFired();
        boolean hit = false;
        String playTestResults = " R=" + df.format(firer.rangeTo(target)) + "/" + df.format(range) + " ";
        if (range < rangeBand) {
            block4: for (int i = 0; i < dice; ++i) {
                int die = Dice.rollD6(firer.getCrewQuality());
                playTestResults = playTestResults + "(" + die + ") ";
                switch (die) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        continue block4;
                    }
                    case 5: 
                    case 6: {
                        ++totalDamage;
                        damage[0] = damage[0] + 1;
                        hit = true;
                    }
                }
            }
        }
        String targetName = target.getName();
        if (!hit) {
            if (this.getOptions().getPlayTest()) {
                this.setNotes("Missed " + targetName + ". " + playTestResults);
                if (target instanceof FighterGroup) {
                    target.addLog("Status", "Low", firer.getName() + " missed with " + "a Class 1 kinetic gun. " + playTestResults);
                }
            } else {
                this.setNotes("Missed " + targetName + ".");
                if (target instanceof FighterGroup) {
                    target.addLog("Status", "Low", firer.getName() + " missed with " + "a Class 1 kinetic gun. ");
                }
            }
            return;
        }
        if (this.getOptions().getPlayTest()) {
            this.setNotes("Hit " + targetName + " for " + StringUtils.kills(totalDamage) + playTestResults);
            if (target instanceof FighterGroup) {
                target.addLog("Attack", "High", firer.getName() + " hit for " + StringUtils.kills(totalDamage) + " with a Class 1 kinetic gun. " + playTestResults);
            }
        } else {
            this.setNotes("Hit " + targetName + " for " + StringUtils.kills(totalDamage) + ".");
            if (target instanceof FighterGroup) {
                target.addLog("Attack", "High", firer.getName() + " hit for " + StringUtils.kills(totalDamage) + " with a Class 1 kinetic gun. ");
            }
        }
        if (target instanceof MissileSalvo) {
            MissileSalvo ms = (MissileSalvo)target;
            ms.takeDamage(damage);
        }
        if (target instanceof FighterGroup) {
            FighterGroup fg = (FighterGroup)target;
            fg.takeDamage(damage);
        }
    }

    public int computeMass() {
        int count = this.computeNumberOfArcs();
        int mass = 0;
        switch (this.getRating()) {
            case 1: {
                mass = 2;
                break;
            }
            case 2: {
                mass = 3;
                if (count != 2) break;
                mass = 4;
                break;
            }
            case 3: {
                mass = 5;
                break;
            }
            case 4: {
                mass = 8;
                break;
            }
            case 5: {
                mass = 11;
                break;
            }
            case 6: {
                mass = 14;
                break;
            }
            case 7: {
                mass = 17;
                break;
            }
            case 8: {
                mass = 21;
                break;
            }
            case 9: {
                mass = 24;
                break;
            }
            case 10: {
                mass = 28;
            }
        }
        return mass;
    }

    public int computePointCost() {
        return 4 * this.computeMass();
    }

    public String toString() {
        String result = "   ";
        result = result + this.getSystemName();
        if (!this.getSystemStatus().equals("Operational")) {
            while (result.length() < this.getOptions().getStatusSpacing()) {
                result = result + " ";
            }
            result = result + this.getSystemStatus();
        }
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String t = XMLUtilities.getIndent();
        String newLine = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        if (level >= 6) {
            return "";
        }
        sb.append(t);
        sb.append(t);
        sb.append("<KineticGun ");
        if (level > 0) {
            sb.append(" id=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" rating=\"");
        sb.append(this.rating);
        sb.append("\" arcs=\"");
        sb.append(this.getArcsString());
        sb.append("\"");
        if (this.rating == 1 && this.getTargetId() != 0 && (level == 2 || level == 1)) {
            sb.append(" targetId=\"" + this.getTargetId() + "\"");
        }
        if (level != 0 && level != 5) {
            sb.append(" status=\"");
            sb.append(this.getSystemStatus());
            sb.append("\"");
            if (!this.isRecharged()) {
                sb.append(" recharge=\"" + this.getRecharge() + "\"");
            }
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"");
            sb.append(this.getNotes());
            sb.append("\"");
        }
        sb.append("/>");
        sb.append(newLine);
        return sb.toString();
    }

    private void setDamageArrays() {
        this.damage = new int[this.rating];
        this.doubleDamage = new int[2 * this.rating];
        for (int i = 0; i < this.rating; ++i) {
            this.damage[i] = 1;
            this.doubleDamage[i] = 1;
            this.doubleDamage[i + this.rating] = 1;
        }
    }

    static {
        Weapon.addSystem("KineticGun", new KineticGun());
    }
}

