/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.util.XMLUtilities;

public class Hull {
    private int hullSize;
    private String hullStrength;
    private String hullClass;
    private int totalHullBoxes;
    private int remainingHullBoxes;
    private int totalDamageControl;
    private int totalHullStealth;
    private int numberOfRows;
    private int[] rows;
    private int incrDC;
    private int thresholdCheckSum;
    public static int FIRST_THRESHOLD_CHECK = 4;
    public static int SECOND_THRESHOLD_CHECK = 2;
    public static int THIRD_THRESHOLD_CHECK = 1;
    public static final String NO_DAMAGE = "Ok";
    public static final String LIGHT_DAMAGE = "Light";
    public static final String MODERATE_DAMAGE = "Moderate";
    public static final String HEAVY_DAMAGE = "Heavy";
    public static final String CRITICAL_DAMAGE = "Critical";
    public static final String DESTROYED = "Destroyed";
    public static final String FRAGILE = "Fragile";
    public static final String WEAK = "Weak";
    public static final String AVERAGE = "Average";
    public static final String STRONG = "Strong";
    public static final String SUPER = "Super";
    public static final String CUSTOM = "Custom";
    public static final String MILITARY = "Military";
    public static final String MERCHANT = "Merchant";

    public Hull() {
        this(0, AVERAGE, MILITARY, 4);
    }

    public Hull(int h) {
        this(h, AVERAGE, MILITARY, 4);
    }

    public Hull(int h, String s) {
        this(h, s, MILITARY, 4);
    }

    public Hull(int h, String s, String cl) {
        this(h, s, cl, 4);
    }

    public Hull(int h, String s, String cl, int nr) {
        this.setHullStrength(s);
        this.setHullClass(cl);
        this.numberOfRows = nr;
        this.setTotalHullStealth(0);
        this.setHull(h);
    }

    public Hull(int h, String s, String cl, int nr, int st) {
        this.setHullStrength(s);
        this.setHullClass(cl);
        this.numberOfRows = nr;
        this.setTotalHullStealth(st);
        this.setHull(h);
    }

    public Hull(int h, int hb) {
        this(h, hb, MILITARY, 4, 0);
    }

    public Hull(int h, int hb, String cl, int nr) {
        this(h, hb, cl, nr, 0);
    }

    public Hull(int h, int hb, String cl, int nr, int st) {
        this.setHullStrength(CUSTOM);
        this.setHullClass(cl);
        this.setTotalHull(hb);
        this.numberOfRows = nr;
        this.setTotalHullStealth(st);
        this.setHull(h);
    }

    public void setHull(int a) {
        int i;
        double dcpPerMass = 20.0;
        if (this.getHullClass().equals(MERCHANT)) {
            dcpPerMass = 50.0;
        }
        this.hullSize = a;
        if (!this.hullStrength.equals(CUSTOM)) {
            double mult = 0.3;
            this.incrDC = 6;
            if (this.hullStrength.equals(FRAGILE)) {
                mult = 0.1;
                this.incrDC = 2;
            }
            if (this.hullStrength.equals(WEAK)) {
                mult = 0.2;
                this.incrDC = 4;
            }
            if (this.hullStrength.equals(AVERAGE)) {
                mult = 0.3;
                this.incrDC = 6;
            }
            if (this.hullStrength.equals(STRONG)) {
                mult = 0.4;
                this.incrDC = 8;
            }
            if (this.hullStrength.equals(SUPER)) {
                mult = 0.5;
                this.incrDC = 10;
            }
            this.totalHullBoxes = (int)Math.round((double)this.hullSize * mult);
        }
        this.remainingHullBoxes = this.totalHullBoxes;
        this.totalDamageControl = (int)Math.ceil((double)this.hullSize / dcpPerMass);
        this.incrDC = (int)Math.ceil((double)this.totalHullBoxes / (double)this.totalDamageControl);
        this.rows = new int[6];
        int rowLength = (int)Math.floor((double)this.totalHullBoxes / (double)this.numberOfRows);
        for (i = 0; i < this.numberOfRows; ++i) {
            this.rows[i] = rowLength;
        }
        int excess = this.totalHullBoxes - rowLength * this.numberOfRows;
        i = 0;
        while (i < excess) {
            int n = i++;
            this.rows[n] = this.rows[n] + 1;
        }
        this.thresholdCheckSum = 0;
    }

    public void setHullStrength(String s) {
        this.hullStrength = s;
    }

    public String getHullStrength() {
        return this.hullStrength;
    }

    public void setHullClass(String s) {
        this.hullClass = s;
    }

    public String getHullClass() {
        return this.hullClass;
    }

    public void setTotalHullStealth(int h) {
        this.totalHullStealth = h;
    }

    public int getTotalHullStealth() {
        return this.totalHullStealth;
    }

    public int getHullSize() {
        return this.hullSize;
    }

    public int getTotalHull() {
        return this.totalHullBoxes;
    }

    public void setTotalHull(int h) {
        this.totalHullBoxes = h;
    }

    public int getRemainingHull() {
        return this.remainingHullBoxes;
    }

    public void setRemainingHull(int h) {
        this.remainingHullBoxes = h;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getThresholdCheckSum() {
        return this.thresholdCheckSum;
    }

    public void incrThresholdCheckSum(int t) {
        this.thresholdCheckSum += t;
    }

    public void zeroThresholdCheckSum() {
        this.thresholdCheckSum = 0;
    }

    public int getRemainingDamageControl() {
        String hullString = this.toString();
        char[] chars = hullString.toCharArray();
        int result = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '*') continue;
            ++result;
        }
        return result;
    }

    public int getRemainingHullStealth() {
        String hullString = this.toString();
        char[] chars = hullString.toCharArray();
        int result = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != 'Q') continue;
            ++result;
        }
        return result;
    }

    public int takeDamage(int damage) {
        if (damage == 0) {
            return 0;
        }
        if (this.remainingHullBoxes >= damage) {
            int r0sum = this.rows[5] + this.rows[4];
            int r1sum = r0sum + this.rows[3];
            int r2sum = r1sum + this.rows[2];
            int r3sum = r2sum + this.rows[1];
            for (int i = 0; i < damage; ++i) {
                --this.remainingHullBoxes;
                if (this.remainingHullBoxes == r3sum) {
                    this.incrThresholdCheckSum(FIRST_THRESHOLD_CHECK);
                }
                if (this.remainingHullBoxes == r2sum) {
                    this.incrThresholdCheckSum(SECOND_THRESHOLD_CHECK);
                }
                if (this.remainingHullBoxes != r1sum && this.remainingHullBoxes != r0sum && this.remainingHullBoxes != this.rows[5]) continue;
                this.incrThresholdCheckSum(THIRD_THRESHOLD_CHECK);
            }
            return 0;
        }
        this.remainingHullBoxes = 0;
        return damage - this.remainingHullBoxes;
    }

    public String evaluateStatus() {
        if (this.remainingHullBoxes <= 0) {
            return DESTROYED;
        }
        if (this.remainingHullBoxes == this.totalHullBoxes) {
            return NO_DAMAGE;
        }
        if (this.remainingHullBoxes <= 2) {
            return CRITICAL_DAMAGE;
        }
        if (this.remainingHullBoxes <= 4 && this.totalHullBoxes >= 40) {
            return CRITICAL_DAMAGE;
        }
        int diff = this.totalHullBoxes - this.remainingHullBoxes;
        if (diff < this.rows[0]) {
            return LIGHT_DAMAGE;
        }
        if (diff < this.rows[0] + this.rows[1]) {
            return MODERATE_DAMAGE;
        }
        return HEAVY_DAMAGE;
    }

    public int computeMass() {
        int mass;
        double mult = 0.3;
        if (!this.hullStrength.equals(CUSTOM)) {
            if (this.hullStrength.equals(FRAGILE)) {
                mult = 0.1;
            }
            if (this.hullStrength.equals(WEAK)) {
                mult = 0.2;
            }
            if (this.hullStrength.equals(AVERAGE)) {
                mult = 0.3;
            }
            if (this.hullStrength.equals(STRONG)) {
                mult = 0.4;
            }
            if (this.hullStrength.equals(SUPER)) {
                mult = 0.5;
            }
            if ((mass = (int)Math.round(mult * (double)this.hullSize)) <= 0) {
                mass = 1;
            }
        } else {
            mass = this.getTotalHull();
        }
        return mass;
    }

    public int computePointCost() {
        double factor = 2.0;
        switch (this.numberOfRows) {
            case 3: {
                factor = 3.0;
                break;
            }
            case 4: {
                factor = 2.0;
                break;
            }
            case 5: {
                factor = 1.5;
                break;
            }
            case 6: {
                factor = 1.0;
            }
        }
        int standardCost = this.hullSize + (int)((double)this.computeMass() * factor);
        int stealthCost = this.totalHullBoxes * this.totalHullStealth * 2;
        return standardCost + stealthCost;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        String result = "   ";
        String padding = "          ";
        int crewCount = 0;
        boolean damaged = false;
        boolean[] addStealth = new boolean[this.numberOfRows];
        boolean padStealth = false;
        for (int i = 0; i < this.numberOfRows; ++i) {
            addStealth[i] = false;
        }
        if (this.totalHullStealth == 1) {
            if (this.numberOfRows > 2) {
                addStealth[1] = true;
            } else {
                addStealth[0] = true;
            }
        }
        if (this.totalHullStealth == 2) {
            addStealth[0] = true;
            if (this.numberOfRows > 3) {
                addStealth[2] = true;
                if (this.rows[2] != this.rows[0]) {
                    padStealth = true;
                }
            } else {
                addStealth[1] = true;
                if (this.rows[1] != this.rows[0]) {
                    padStealth = true;
                }
            }
        }
        result = "   Hull:  ";
        int index = 1;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.rows[i]; ++j) {
                if (this.totalHullBoxes - index + 1 <= this.remainingHullBoxes) {
                    if (index == 1 || index % this.incrDC != 0) {
                        if (index != this.totalHullBoxes) {
                            sb.append("o");
                            damaged = false;
                        } else {
                            sb.append("*");
                            damaged = false;
                            ++crewCount;
                        }
                    } else {
                        sb.append("*");
                        damaged = false;
                        ++crewCount;
                    }
                } else {
                    sb.append("-");
                    damaged = true;
                    if (index == 1 || index % this.incrDC != 0) {
                        if (index == this.totalHullBoxes) {
                            ++crewCount;
                        }
                    } else {
                        ++crewCount;
                    }
                }
                ++index;
            }
            if (addStealth[i]) {
                if (!damaged) {
                    if (i > 0 && padStealth) {
                        sb.append(" ");
                    }
                    sb.append("Q");
                } else {
                    sb.append(" ");
                }
            }
            if (i == this.numberOfRows - 1) continue;
            sb.append(sep);
            sb.append(padding);
        }
        if (crewCount != this.totalDamageControl) {
            int diff = this.totalDamageControl - crewCount;
            for (index = sb.length() - 1; diff > 0 && index >= 0; --index) {
                if (sb.charAt(index) != 'o') continue;
                sb.setCharAt(index, '*');
                --diff;
            }
        }
        result = result + sb.toString();
        return result;
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        StringBuffer sb = new StringBuffer();
        String s = "";
        String t = XMLUtilities.getIndent();
        String sep = System.getProperty("line.separator");
        if (level > 9) {
            return s;
        }
        if (level == 8 || level == 9) {
            sb.append(t + "<Hull value=\"10\" type=\"Fragile\"");
        } else {
            sb.append(t + "<Hull value=\"" + this.hullSize + "\"");
            sb.append(" type=\"" + this.hullStrength + "\"");
            sb.append(" class=\"" + this.hullClass + "\"");
            sb.append(" stealth=\"" + this.totalHullStealth + "\"");
            if (this.numberOfRows != 4) {
                sb.append(" rows=\"" + this.numberOfRows + "\"");
            }
            if (this.hullStrength.equals(CUSTOM)) {
                sb.append(" totalHullBoxes=\"" + this.totalHullBoxes + "\"");
            }
            if (level >= 1) {
                sb.append(" remainingHullBoxes=\"" + this.remainingHullBoxes + "\"");
            }
        }
        sb.append("/>" + sep);
        return sb.toString();
    }
}

