/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.mailman.MailToServer;
import ftjava.std.AntiMatterTorpedo;
import ftjava.std.FighterBay;
import ftjava.std.FighterGroup;
import ftjava.std.FighterOrders;
import ftjava.std.HeavenlyBody;
import ftjava.std.LogRecord;
import ftjava.std.Missile;
import ftjava.std.MissileSalvo;
import ftjava.std.NovaCannonBolt;
import ftjava.std.PlasmaBolt;
import ftjava.std.Player;
import ftjava.std.PostOffice;
import ftjava.std.Ship;
import ftjava.std.ShipUtilities;
import ftjava.std.SpaceObject;
import ftjava.std.WaveGunBolt;
import ftjava.std.victoryconditions.FalseCondition;
import ftjava.std.victoryconditions.VictoryCondition;
import ftjava.util.Dice;
import ftjava.util.GameOptions;
import ftjava.util.ParserUtilities;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;

public class GameEngine {
    private String name = "";
    private String scenarioBriefing = "";
    private int id = 0;
    private GameOptions options;
    private int gameTurn = 0;
    private boolean combatPhase = false;
    private ArrayList activeObjects;
    private ArrayList heavenlyBodies;
    private ArrayList AllShips;
    private ArrayList Players;
    private HashMap Teams = new HashMap();
    private ArrayList report;
    private VictoryCondition Condition;
    private HashSet idCheck;
    private static int ftlTestRoll = 0;

    public GameEngine() {
        this.activeObjects = new ArrayList();
        this.heavenlyBodies = new ArrayList();
        this.AllShips = new ArrayList();
        this.Players = new ArrayList();
        this.report = new ArrayList();
        this.Teams = new HashMap();
        this.Condition = new FalseCondition();
        this.idCheck = new HashSet();
        this.options = new GameOptions();
    }

    public boolean isCurrentGame() {
        return GameOptions.current() == this.options;
    }

    public void setCurrentGame(boolean isCurrent) {
        if (isCurrent && !this.isCurrentGame()) {
            GameOptions.push(this.options);
        } else if (this.isCurrentGame()) {
            GameOptions.pop();
        }
    }

    public GameOptions getOptions() {
        return this.options;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setScenarioBriefing(String n) {
        this.scenarioBriefing = n;
    }

    public String getScenarioBriefing() {
        return this.scenarioBriefing;
    }

    public void setVictoryCondition(VictoryCondition c) {
        this.Condition = c;
    }

    public VictoryCondition getVictoryCondition() {
        return this.Condition;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public void setGameTurn(int i) {
        this.gameTurn = i;
    }

    public int getGameTurn() {
        return this.gameTurn;
    }

    public int getDeadline() {
        return this.options.getDeadline();
    }

    public void setCombatPhase(boolean j) {
        this.combatPhase = j;
    }

    public boolean isCombatPhase() {
        return this.combatPhase;
    }

    public ArrayList getPlayers() {
        return this.Players;
    }

    public int getNumberOfPlayers() {
        return this.Players.size();
    }

    public void incrementGameTurn() {
        ++this.gameTurn;
    }

    public ArrayList getTurnReport() {
        return this.report;
    }

    public void addTurnReport(String event, String priority, String mess) {
        LogRecord entry = new LogRecord();
        entry.setTurn(this.getGameTurn());
        entry.setEvent(event);
        entry.setPriority(priority);
        entry.setRecord(mess);
        this.report.add(entry);
    }

    public void addTurnReport(String event, String mess) {
        this.addTurnReport(event, "Low", mess);
    }

    public void addTurnReport(String s) {
        this.addTurnReport("Misc.", "Somebody Else's Problem", s);
    }

    public void addTurnReport(LogRecord lr) {
        this.report.add(lr);
    }

    public void addPlayer(Player p) {
        this.Players.add(p);
        if (!this.Teams.containsKey(p.getTeam())) {
            ArrayList l = new ArrayList();
            this.Teams.put(p.getTeam(), l);
        }
    }

    public void addObject(SpaceObject o) {
        Integer i = new Integer(o.getId());
        boolean result = this.idCheck.add(i);
        if (!result) {
            String message = "Error: Duplicate ID found in Game " + this.getId() + "  ID = " + o.getId();
            throw new RuntimeException(message);
        }
        this.activeObjects.add(o);
        if (o instanceof HeavenlyBody) {
            this.heavenlyBodies.add(o);
        }
    }

    public HashMap getTeams() {
        return this.Teams;
    }

    public void removeShip(Ship s) {
        Player p = s.getPlayer();
        this.activeObjects.remove(this.activeObjects.indexOf(s));
        this.AllShips.remove(this.AllShips.indexOf(s));
        ArrayList l = (ArrayList)this.Teams.get(s.getTeam());
        l.remove(l.indexOf(s));
        if (p != null) {
            p.removeShip(s);
        }
    }

    public void removeSpaceObject(SpaceObject so) {
        Player p = so.getPlayer();
        this.activeObjects.remove(this.activeObjects.indexOf(so));
        if (p != null) {
            p.removeSpaceObject(so);
        }
        if (so instanceof HeavenlyBody) {
            this.heavenlyBodies.remove(this.heavenlyBodies.indexOf(so));
        }
    }

    public void removePlayer(Player p, boolean removeships) {
        if (removeships) {
            Iterator i = p.getShips().iterator();
            while (i.hasNext()) {
                this.removeShip((Ship)i.next());
                i.remove();
            }
        }
        this.Players.remove(this.Players.indexOf(p));
    }

    public void addShip(Ship s) {
        this.addObject(s);
        this.AllShips.add(s);
        if (this.Teams.containsKey(s.getTeam())) {
            ArrayList l = (ArrayList)this.Teams.get(s.getTeam());
            l.add(s);
        } else {
            ArrayList<Ship> l = new ArrayList<Ship>();
            l.add(s);
            this.Teams.put(s.getTeam(), l);
        }
    }

    public ArrayList getShips() {
        return this.AllShips;
    }

    public ArrayList getActiveObjects() {
        return this.activeObjects;
    }

    public ArrayList getHeavenlyBodies() {
        return this.heavenlyBodies;
    }

    public int getNumberOfShips() {
        return this.AllShips.size();
    }

    public Ship getShip(int i) {
        return (Ship)this.AllShips.get(i);
    }

    public Ship getShipById(int id) {
        int count = this.getNumberOfShips();
        for (int i = 0; i < count; ++i) {
            Ship s = this.getShip(i);
            if (s.getId() != id) continue;
            return s;
        }
        return null;
    }

    public SpaceObject getObjectById(int id) {
        SpaceObject o;
        int i;
        int count = this.activeObjects.size();
        for (i = 0; i < count; ++i) {
            o = (SpaceObject)this.activeObjects.get(i);
            if (o.getId() != id) continue;
            return o;
        }
        count = this.AllShips.size();
        for (i = 0; i < count; ++i) {
            o = (SpaceObject)this.AllShips.get(i);
            if (o.getId() != id) continue;
            return o;
        }
        return null;
    }

    public SpaceObject getObjectByName(String aName) {
        if (aName == null) {
            return null;
        }
        String matchTo = null;
        int count = this.activeObjects.size();
        for (int i = 0; i < count; ++i) {
            SpaceObject o = (SpaceObject)this.activeObjects.get(i);
            matchTo = null;
            if (o instanceof Ship) {
                Ship s = (Ship)o;
                matchTo = s.getClassAbbrev() + " " + s.getName();
            }
            if (o instanceof FighterGroup) {
                FighterGroup fg = (FighterGroup)o;
                matchTo = fg.getName();
            }
            if (!aName.equals(matchTo)) continue;
            return o;
        }
        return null;
    }

    public Player getPlayer(int i) {
        if (i + 1 > this.Players.size()) {
            return null;
        }
        return (Player)this.Players.get(i);
    }

    public Player getPlayerById(int id) {
        int count = this.Players.size();
        for (int i = 0; i < count; ++i) {
            Player p = (Player)this.Players.get(i);
            if (p.getId() != id) continue;
            return p;
        }
        return null;
    }

    public Player getActivePlayer() {
        Player p;
        int i;
        Player ap = null;
        int count = this.Players.size();
        int sum = 0;
        for (i = 0; i < count; ++i) {
            p = (Player)this.Players.get(i);
            sum += p.getKey();
        }
        if (sum == 0) {
            return ap;
        }
        int prod = 1;
        for (i = 0; i < count; ++i) {
            p = (Player)this.Players.get(i);
            prod *= p.getKey();
        }
        if (prod != 0) {
            return ap;
        }
        for (i = 0; i < count; ++i) {
            p = (Player)this.Players.get(i);
            int key = p.getKey();
            if (key == 0) continue;
            return p;
        }
        return null;
    }

    public int getNumberOfShipsAlive() {
        int count = 0;
        for (int i = 0; i < this.activeObjects.size(); ++i) {
            Ship s;
            SpaceObject o = (SpaceObject)this.activeObjects.get(i);
            if (!(o instanceof Ship) || (s = (Ship)o).isDestroyed()) continue;
            ++count;
        }
        return count;
    }

    public int findUniqueId() {
        int start;
        SpaceObject test = null;
        for (int result = start = Dice.rollD(9) * 1000 + Dice.rollD(100); result < 9999; ++result) {
            test = this.getObjectById(result);
            if (test != null) continue;
            return result;
        }
        return -1;
    }

    public void initializeMovementOrders() {
        SpaceObject o;
        int i;
        for (i = 0; i < this.AllShips.size(); ++i) {
            Ship s;
            o = (SpaceObject)this.AllShips.get(i);
            if (!(o instanceof Ship) || (s = (Ship)o).isDestroyed()) continue;
            s.setOrders("0");
            if (s.getMainDrive() == null) continue;
            s.getMainDrive().setActive(false);
        }
        for (i = 0; i < this.activeObjects.size(); ++i) {
            o = (SpaceObject)this.activeObjects.get(i);
            if (!(o instanceof FighterGroup)) continue;
            FighterGroup fg = (FighterGroup)o;
            fg.setDefaultOrders();
        }
    }

    public void resetFireControls() {
        for (int i = 0; i < this.AllShips.size(); ++i) {
            SpaceObject o = (SpaceObject)this.AllShips.get(i);
            if (!(o instanceof Ship)) continue;
            Ship s = (Ship)o;
            s.shutdownAllWeapons();
        }
    }

    public boolean validateScenario() {
        boolean result = true;
        ArrayList ships = this.getShips();
        for (int i = 0; i < ships.size(); ++i) {
            if (ShipUtilities.validateShip((Ship)ships.get(i))) continue;
            result = false;
        }
        return result;
    }

    public void resetWeapons() {
        for (int i = 0; i < this.AllShips.size(); ++i) {
            SpaceObject o = (SpaceObject)this.AllShips.get(i);
            if (!(o instanceof Ship)) continue;
            Ship s = (Ship)o;
            s.resetWeapons();
            s.evaluateFireControlTargets();
        }
    }

    public void evaluateFireControlTargets() {
        for (int i = 0; i < this.AllShips.size(); ++i) {
            SpaceObject o = (SpaceObject)this.AllShips.get(i);
            if (!(o instanceof Ship)) continue;
            ((Ship)o).evaluateFireControlTargets();
        }
    }

    public void rechargeFTLDrives() {
        for (int i = 0; i < this.AllShips.size(); ++i) {
            SpaceObject o = (SpaceObject)this.AllShips.get(i);
            if (!(o instanceof Ship)) continue;
            Ship s = (Ship)o;
            s.resetFTLDrive();
        }
    }

    public void resetDeadWeapons() {
        for (int i = 0; i < this.AllShips.size(); ++i) {
            Ship s;
            SpaceObject o = (SpaceObject)this.AllShips.get(i);
            if (!(o instanceof Ship) || !(s = (Ship)o).isDestroyed() && !s.hasStruck()) continue;
            s.resetWeapons();
            s.evaluateFireControlTargets();
        }
    }

    public void resetNotes() {
        Ship s;
        SpaceObject o;
        int i;
        for (i = 0; i < this.AllShips.size(); ++i) {
            o = (SpaceObject)this.AllShips.get(i);
            if (!(o instanceof Ship)) continue;
            s = (Ship)o;
            s.resetNotes();
        }
        for (i = 0; i < this.activeObjects.size(); ++i) {
            o = (SpaceObject)this.activeObjects.get(i);
            if (!(o instanceof Ship)) continue;
            s = (Ship)o;
            s.resetNotes();
        }
    }

    public void transferMessages() {
        PostOffice pOffice = new PostOffice(this.Players);
        pOffice.execute();
    }

    public void movementPhase() {
        int i;
        ArrayList<Integer> jumpedThisTurn = new ArrayList<Integer>();
        ArrayList<Integer> struckThisTurn = new ArrayList<Integer>();
        ArrayList<SpaceObject> arrivedThisTurn = new ArrayList<SpaceObject>();
        for (i = 0; i < this.activeObjects.size(); ++i) {
            SpaceObject so = (SpaceObject)this.activeObjects.get(i);
            if (!(so instanceof FighterGroup)) continue;
            FighterGroup fg = (FighterGroup)so;
            fg.setScreenMove();
        }
        for (i = 0; i < this.activeObjects.size(); ++i) {
            SpaceObject o = (SpaceObject)this.activeObjects.get(i);
            boolean striking = false;
            boolean arrived = false;
            if (this.gameTurn < o.getArrivalTurn()) continue;
            if (this.gameTurn == o.getArrivalTurn()) {
                arrivedThisTurn.add(o);
            }
            if (o instanceof NovaCannonBolt) {
                ((NovaCannonBolt)o).moveBolt();
            }
            if (o instanceof Missile) {
                ((Missile)o).move();
            }
            if (o instanceof Ship) {
                Ship s = (Ship)o;
                if (s.isDestroyed() || s.hasJumped()) continue;
                if (!arrived) {
                    if (s.hasFiredNovaCannon() || s.hasLaunchedOrLandedFighters()) {
                        s.setOrders("0");
                    }
                    if (this.options.getCinematicMovement()) {
                        int[] parsedOrders = ParserUtilities.parseCinematicOrders(s.getOrders());
                        if (!this.options.getShipRoll()) {
                            s.moveShip(parsedOrders[0], parsedOrders[1], parsedOrders[5], 0, parsedOrders[3], parsedOrders[4]);
                        } else {
                            s.moveShip(parsedOrders[0], parsedOrders[1], parsedOrders[5], parsedOrders[2], parsedOrders[3], parsedOrders[4]);
                        }
                        if (parsedOrders[4] == 1) {
                            striking = true;
                        }
                    } else {
                        boolean changed = s.hasStruck();
                        s.moveShip();
                        if (changed != s.hasStruck()) {
                            striking = true;
                        }
                    }
                }
                if (s.hasJumped()) {
                    jumpedThisTurn.add(new Integer(i));
                }
                if (striking) {
                    struckThisTurn.add(new Integer(i));
                }
                if (s.hasActiveVapourShroud()) {
                    this.addTurnReport("Status", "Medium", s.getName() + " has activated a Vapour Shroud.");
                }
            }
            if (!(o instanceof FighterGroup)) continue;
            FighterGroup fg = (FighterGroup)o;
            FighterOrders fo = fg.getFighterOrders();
            fo.doMove(fg);
        }
        this.handleArrivingObjects(arrivedThisTurn);
        for (i = 0; i < jumpedThisTurn.size(); ++i) {
            int jumpedShip = (Integer)jumpedThisTurn.get(i);
            Ship s = (Ship)this.activeObjects.get(jumpedShip);
            boolean areObjectsNearby = false;
            for (int k = 0; k < this.activeObjects.size(); ++k) {
                SpaceObject o;
                if (k == jumpedShip || !(o = (SpaceObject)this.activeObjects.get(k)).hasArrived() || !(s.rangeTo(o) <= 6.0)) continue;
                if (o instanceof Ship) {
                    Ship badShip = (Ship)o;
                    if (badShip.isDestroyed() || badShip.hasJumped()) continue;
                    areObjectsNearby = true;
                    break;
                }
                areObjectsNearby = true;
                break;
            }
            if (areObjectsNearby) {
                int roll = Dice.rollD6();
                int[] damageDealt = new int[]{0};
                if (GameOptions.getTestingMode()) {
                    roll = ftlTestRoll % 6 + 1;
                    ++ftlTestRoll;
                }
                switch (roll) {
                    case 1: {
                        s.setStatus("");
                        s.setStatus(s.evaluateShipStatus());
                        s.getFTLDrive().deactivate();
                        s.addLog("Status", "Critical", "Jump Drive Failed!");
                        this.addTurnReport("Status", "Critical", s.getName() + " experienced a FTL Drive failure!");
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        damageDealt[0] = Dice.rollD6();
                        s.addLog("Status", "High", "Out of System");
                        this.addTurnReport("Status", "High", s.getName() + " is now " + "Out of System");
                        break;
                    }
                    case 5: 
                    case 6: {
                        damageDealt[0] = s.getHull().getTotalHull();
                        s.takeDamage(new int[]{Integer.MAX_VALUE});
                        break;
                    }
                }
                for (int k = 0; k < this.activeObjects.size(); ++k) {
                    Ship badShip;
                    SpaceObject o = (SpaceObject)this.activeObjects.get(k);
                    if (!o.hasArrived() || !(s.rangeTo(o) <= 6.0) || !(o instanceof Ship) || (badShip = (Ship)o).isDestroyed() || badShip.hasJumped()) continue;
                    String theRecord = badShip.getName() + " has taken " + damageDealt[0] + " points from " + s.getName() + "'s FTL energy discharge.";
                    badShip.addLog("Damage", "High", theRecord);
                    this.addTurnReport("Damage", "High", theRecord);
                    badShip.takeDamage(damageDealt);
                }
                continue;
            }
            s.addLog("Status", "High", "Out of System");
            this.addTurnReport("Status", "High", s.getName() + " is now " + "Out of System");
        }
        for (i = 0; i < struckThisTurn.size(); ++i) {
            int strikingShip = (Integer)struckThisTurn.get(i);
            Ship s = (Ship)this.activeObjects.get(strikingShip);
            s.addLog("Status", "High", "Striking its Colors");
            this.addTurnReport("Status", "High", s.getName() + " is " + "Striking its Colors");
        }
        this.handleFighterGroupReactionNoScreeners(false);
        this.handleFighterGroupReaction(false);
        for (i = 0; i < this.activeObjects.size(); ++i) {
            SpaceObject so = (SpaceObject)this.activeObjects.get(i);
            if (!(so instanceof FighterGroup)) continue;
            FighterGroup fg = (FighterGroup)so;
            FighterOrders fo = fg.getFighterOrders();
            fo.doSecondaryMove(fg);
        }
        this.recoverFighterGroups();
        this.handleFighterGroupReactionNoScreeners(true);
        this.handleFighterGroupReaction(true);
        for (int k = 0; k < this.heavenlyBodies.size(); ++k) {
            SpaceObject hb = (SpaceObject)this.heavenlyBodies.get(k);
            for (int i2 = 0; i2 < this.activeObjects.size(); ++i2) {
                SpaceObject so = (SpaceObject)this.activeObjects.get(i2);
                if (so instanceof Ship || so instanceof HeavenlyBody || !so.inside(hb)) continue;
                so.takeDamage(new int[]{1000});
                so.addLog("Damage", "High", so.getName() + " collided with " + hb.getName() + ".");
                this.addTurnReport("Damage", "High", so.getName() + " collided with " + hb.getName() + ".");
            }
        }
    }

    private void handleFighterGroupReactionNoScreeners(boolean second) {
        for (int i = 0; i < this.activeObjects.size(); ++i) {
            FighterGroup fg;
            SpaceObject so = (SpaceObject)this.activeObjects.get(i);
            if (!(so instanceof FighterGroup) || (fg = (FighterGroup)so).isOnBoard() || fg.isDead() || fg.getFighterOrders().toString().equals("Screen")) continue;
            fg.getFighterOrders().doReaction(fg, second);
        }
    }

    private void handleFighterGroupReaction(boolean second) {
        for (int i = 0; i < this.activeObjects.size(); ++i) {
            FighterGroup fg;
            SpaceObject so = (SpaceObject)this.activeObjects.get(i);
            if (!(so instanceof FighterGroup) || (fg = (FighterGroup)so).isOnBoard() || fg.isDead()) continue;
            fg.getFighterOrders().doReaction(fg, second);
        }
    }

    private void recoverFighterGroups() {
        for (int i = 0; i < this.activeObjects.size(); ++i) {
            FighterBay fb;
            Ship carrier;
            SpaceObject so = (SpaceObject)this.activeObjects.get(i);
            if (!(so instanceof FighterGroup)) continue;
            FighterGroup fg = (FighterGroup)so;
            boolean toHome = false;
            boolean toNearest = false;
            if (fg.getCount() <= 0) continue;
            if (fg.getFighterOrders().getBriefDescription().equals("Return Home")) {
                toHome = true;
            }
            if (fg.getFighterOrders().getBriefDescription().equals("Emergency Landing")) {
                toNearest = true;
            }
            if (!toHome && !toNearest || toHome && fg.getTargetId() != fg.getCarrierShipId() || this.getShipById(fg.getTargetId()) == null || fg.rangeTo(carrier = this.getShipById(fg.getTargetId())) > 6.0 || (fb = carrier.getFighterBayForRecovery()) == null) continue;
            fb.setLandedFighterGroup(fg);
            fg.setOnBoard(true);
            fg.setFighterBayId(fb.getId());
            fg.setCarrierShipId(carrier.getId());
            fg.resetCombatEndurance();
            fg.addLog("Status", "Medium", fg.getName() + " has landed on " + carrier.getClassAbbrev() + " " + carrier.getName() + ".");
            switch (Dice.rollD6()) {
                case 1: {
                    fb.setRecharge(-1);
                    break;
                }
                case 6: {
                    fb.setRecharge(0);
                    break;
                }
                default: {
                    fb.setRecharge(1);
                }
            }
            if (fb.getRecharge() > 0) {
                carrier.addLog("Status", "Medium", fg.getName() + " will be rearmed in " + StringUtils.turns(fb.getRecharge()) + ".");
                fg.addLog("Status", "Medium", fg.getName() + " will be rearmed in " + StringUtils.turns(fb.getRecharge()) + ".");
            } else {
                carrier.addLog("Status", "High", fg.getName() + " has suffered a fighter bay mishap.");
                fg.addLog("Status", "High", fg.getName() + " has suffered a fighter bay mishap.");
            }
            Player pFighter = fg.getPlayer();
            Player pCarrier = carrier.getPlayer();
            if (pFighter != pCarrier) {
                pFighter.removeSpaceObject(fg);
                pCarrier.addSpaceObject(fg);
            }
            fg.setFighterOrders((FighterOrders)FighterGroup.orderChoices.get(0));
            fg.setTargetId(0);
            fg.setTarget(null);
        }
    }

    private void handleArrivingObjects(ArrayList theList) {
        for (int i = 0; i < theList.size(); ++i) {
            SpaceObject so = (SpaceObject)theList.get(i);
            double direction = (double)Dice.rollD12() * 30.0 * Math.PI / 180.0;
            double distance = Dice.rollD6();
            if (distance > 5.1) {
                distance *= (double)Dice.rollD6();
            }
            double deltaX = distance * Math.cos(direction);
            double deltaY = distance * Math.sin(direction);
            so.setXPosition(so.getXPosition() + deltaX);
            so.setYPosition(so.getYPosition() + deltaY);
        }
    }

    public void resolveExtent() {
        if (!this.options.hasActiveExtent()) {
            return;
        }
        for (int i = 0; i < this.activeObjects.size(); ++i) {
            boolean okInY;
            SpaceObject o = (SpaceObject)this.activeObjects.get(i);
            boolean okInX = o.getXPosition() > this.options.getXMin() && o.getXPosition() < this.options.getXMax();
            boolean bl = okInY = o.getYPosition() > this.options.getYMin() && o.getYPosition() < this.options.getYMax();
            if (okInX && okInY) continue;
            String message = o.getName() + " has left the game.";
            if (o instanceof Ship) {
                Ship s = (Ship)o;
                if (s.isDestroyed() || s.hasJumped()) continue;
                s.setStatus("Out of System");
                s.addLog("Status", "High", message);
            } else if (o instanceof FighterGroup) {
                FighterGroup fg = (FighterGroup)o;
                if (fg.getCount() == 0) continue;
                fg.setCount(0);
                fg.addLog("Status", "High", message);
            }
            this.addTurnReport("Status", "High", message);
        }
    }

    public void resolveMissileSalvoTargeting() {
        SpaceObject m;
        SpaceObject o;
        int i;
        double radius = this.options.getSalvoMissileLockOn();
        for (i = 0; i < this.activeObjects.size(); ++i) {
            o = (SpaceObject)this.activeObjects.get(i);
            if (!(o instanceof MissileSalvo)) continue;
            m = (MissileSalvo)o;
            ((MissileSalvo)m).acquireTarget(this.activeObjects, radius);
        }
        radius = this.options.getAntiMatterTorpedoLockOnRange();
        for (i = 0; i < this.activeObjects.size(); ++i) {
            o = (SpaceObject)this.activeObjects.get(i);
            if (!(o instanceof AntiMatterTorpedo)) continue;
            m = (AntiMatterTorpedo)o;
            ((AntiMatterTorpedo)m).acquireTarget(this.activeObjects, radius);
        }
        radius = this.options.getMissileLockOnRange();
        for (i = 0; i < this.activeObjects.size(); ++i) {
            o = (SpaceObject)this.activeObjects.get(i);
            if (!(o instanceof Missile)) continue;
            m = (Missile)o;
            ((Missile)m).acquireTarget(this.activeObjects, radius);
        }
    }

    public void resolveMissileSalvoLockOn() {
        for (int i = 0; i < this.activeObjects.size(); ++i) {
            SpaceObject o = (SpaceObject)this.activeObjects.get(i);
            if (!(o instanceof MissileSalvo)) continue;
            MissileSalvo m = (MissileSalvo)o;
            m.missilesLockingOn();
        }
    }

    public void resolvePointDefense() {
        for (int i = 0; i < this.activeObjects.size(); ++i) {
            SpaceObject o = (SpaceObject)this.activeObjects.get(i);
            if (!(o instanceof Ship)) continue;
            Ship s = (Ship)o;
            s.firePointDefense(true);
        }
    }

    public void resolveSalvoMissiles() {
        for (int i = 0; i < this.activeObjects.size(); ++i) {
            SpaceObject m;
            SpaceObject o = (SpaceObject)this.activeObjects.get(i);
            if (o instanceof MissileSalvo) {
                m = (MissileSalvo)o;
                ((MissileSalvo)m).fireAt();
            }
            if (!(o instanceof Missile)) continue;
            m = (Missile)o;
            ((Missile)m).fireAt();
            ((Missile)m).setEndurance(((Missile)m).getEndurance() - 1);
        }
    }

    public void resolveFighterAttacks() {
        FighterGroup fg;
        SpaceObject o;
        int i;
        for (i = 0; i < this.activeObjects.size(); ++i) {
            o = (SpaceObject)this.activeObjects.get(i);
            if (!(o instanceof FighterGroup) || !(fg = (FighterGroup)o).isTargetAFighterGroup()) continue;
            fg.getFighterOrders().doCombat(fg);
        }
        this.resolveFighterDamage(false);
        for (i = 0; i < this.activeObjects.size(); ++i) {
            o = (SpaceObject)this.activeObjects.get(i);
            if (!(o instanceof FighterGroup)) continue;
            fg = (FighterGroup)o;
            fg.getFighterOrders().doCombat(fg);
        }
    }

    public void resolveFighterDamage(boolean endOfTurn) {
        for (int i = 0; i < this.activeObjects.size(); ++i) {
            SpaceObject o = (SpaceObject)this.activeObjects.get(i);
            if (!(o instanceof FighterGroup)) continue;
            FighterGroup fg = (FighterGroup)o;
            fg.resolveDamage(endOfTurn);
        }
    }

    public void resolveExplosiveWeapons() {
        for (int i = 0; i < this.activeObjects.size(); ++i) {
            SpaceObject o = (SpaceObject)this.activeObjects.get(i);
            if (o instanceof NovaCannonBolt) {
                NovaCannonBolt ncb = (NovaCannonBolt)o;
                ncb.fireAt();
            }
            if (o instanceof WaveGunBolt) {
                WaveGunBolt wgb = (WaveGunBolt)o;
                wgb.fireAt();
            }
            if (o instanceof PlasmaBolt) {
                PlasmaBolt pb = (PlasmaBolt)o;
                pb.fireAt();
            }
            if (!(o instanceof AntiMatterTorpedo)) continue;
            AntiMatterTorpedo amt = (AntiMatterTorpedo)o;
            amt.fireAt();
        }
    }

    public void resolveShipAttacks() {
        for (int i = 0; i < this.activeObjects.size(); ++i) {
            SpaceObject o = (SpaceObject)this.activeObjects.get(i);
            if (!(o instanceof Ship)) continue;
            Ship s = (Ship)o;
            if (this.options.getTargetResolution() == 0) {
                s.fireWeaponsInPrioritySequence();
                continue;
            }
            s.fireTargetedWeapons();
            s.firePointDefense(false);
        }
    }

    public void resolveCoreSystems() {
        for (int i = 0; i < this.activeObjects.size(); ++i) {
            SpaceObject o = (SpaceObject)this.activeObjects.get(i);
            if (!(o instanceof Ship)) continue;
            Ship s = (Ship)o;
            s.resolveCoreSystems();
        }
    }

    public void makeThresholdChecks() {
        for (int i = 0; i < this.activeObjects.size(); ++i) {
            SpaceObject o = (SpaceObject)this.activeObjects.get(i);
            if (!(o instanceof Ship)) continue;
            Ship s = (Ship)o;
            s.checkForThreshold();
        }
    }

    public void resolveDamageControl() {
        for (int i = 0; i < this.activeObjects.size(); ++i) {
            SpaceObject o = (SpaceObject)this.activeObjects.get(i);
            if (!(o instanceof Ship)) continue;
            Ship s = (Ship)o;
            s.orderedRepair();
        }
    }

    public void cleanUp() {
        this.cleanUp(false);
    }

    public void cleanUp(boolean initialGameInput) {
        SpaceObject o;
        Iterator it;
        if (!initialGameInput) {
            it = this.activeObjects.iterator();
            while (it.hasNext()) {
                Missile m;
                int age;
                o = (SpaceObject)it.next();
                if (o instanceof MissileSalvo) {
                    it.remove();
                }
                if (o instanceof PlasmaBolt) {
                    it.remove();
                }
                if (o instanceof AntiMatterTorpedo) {
                    it.remove();
                }
                if (o instanceof WaveGunBolt) {
                    it.remove();
                }
                if (o instanceof NovaCannonBolt && (age = ((NovaCannonBolt)o).getAge()) >= 3) {
                    it.remove();
                }
                if (!(o instanceof Missile) || (m = (Missile)o).getEndurance() > 0 && !m.hasAttacked() && !m.isDestroyed()) continue;
                it.remove();
            }
            for (int j = 0; j < this.Players.size(); ++j) {
                Player p = (Player)this.Players.get(j);
                it = p.SpaceObjects.iterator();
                while (it.hasNext()) {
                    Missile m;
                    int age;
                    o = (SpaceObject)it.next();
                    if (o instanceof MissileSalvo) {
                        it.remove();
                    }
                    if (o instanceof PlasmaBolt) {
                        it.remove();
                    }
                    if (o instanceof AntiMatterTorpedo) {
                        it.remove();
                    }
                    if (o instanceof WaveGunBolt) {
                        it.remove();
                    }
                    if (o instanceof NovaCannonBolt && (age = ((NovaCannonBolt)o).getAge()) >= 3) {
                        it.remove();
                    }
                    if (!(o instanceof Missile) || (m = (Missile)o).getEndurance() > 0 && !m.hasAttacked() && !m.isDestroyed()) continue;
                    it.remove();
                }
            }
        }
        it = this.activeObjects.iterator();
        while (it.hasNext()) {
            Ship s;
            o = (SpaceObject)it.next();
            if (!(o instanceof Ship) || !(s = (Ship)o).isDestroyed()) continue;
            it.remove();
        }
    }

    public String createPlayerReport() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.Players.size(); ++i) {
            Player player = (Player)this.Players.get(i);
            buffer.append(player.getName() + " <" + player.getEmail() + ">\n");
            for (int j = 0; j < player.Ships.size(); ++j) {
                Ship s = (Ship)player.Ships.get(j);
                buffer.append("\t" + s.getName() + " " + s.evaluateShipStatus() + "\n");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public String createSensorReport() {
        String line = "";
        String results = "";
        String newLine = "\n";
        String one = "  ";
        DecimalFormat df = new DecimalFormat("0.0");
        results = results + one + "Ships" + newLine;
        results = results + one + "Name                   Status";
        if (this.options.isCinematic()) {
            results = results + "          Position        Heading   Speed    " + newLine;
        } else {
            results = results + "          Position        Heading";
            results = results + "   Course  Velocity" + newLine;
        }
        for (int j = 0; j < this.Players.size(); ++j) {
            Player p = (Player)this.Players.get(j);
            results = results + newLine;
            results = results + one + "Player " + p.getName() + newLine;
            for (int i = 0; i < p.Ships.size(); ++i) {
                line = "";
                Ship s = (Ship)p.Ships.get(i);
                line = line + one + s.getClassAbbrev() + " " + s.getName();
                while (line.length() < 25) {
                    line = line + " ";
                }
                line = line + s.evaluateShipStatus();
                while (line.length() < 41) {
                    line = line + " ";
                }
                line = line + "(" + df.format(s.getXPosition()) + ", ";
                line = line + df.format(s.getYPosition()) + ")     ";
                while (line.length() < 59) {
                    line = line + " ";
                }
                line = line + s.getHeading();
                while (line.length() < 68) {
                    line = line + " ";
                }
                if (this.options.isCinematic()) {
                    line = line + s.getSpeed();
                } else {
                    line = line + df.format(s.getCourse());
                    while (line.length() < 75) {
                        line = line + " ";
                    }
                    line = line + df.format(s.getVectorSpeed());
                }
                results = results + line + newLine;
            }
        }
        return results;
    }

    public String createGameReport() {
        String one = " ";
        String newLine = "\n";
        StringBuffer sb = new StringBuffer();
        sb.append(newLine);
        sb.append(one + this.getName() + newLine + newLine);
        if (this.getGameTurn() == 0) {
            sb.append(one + "Initial Setup" + newLine);
        } else {
            sb.append(one + "Turn " + this.getGameTurn() + newLine);
        }
        sb.append(newLine);
        sb.append(this.createSensorReport());
        sb.append(newLine);
        int i = 0;
        Ship s = null;
        Player p = null;
        while ((p = this.getPlayer(i)) != null) {
            for (int j = 0; j < p.Ships.size(); ++j) {
                s = (Ship)p.Ships.get(j);
                sb.append(s.getTextSSD() + newLine);
                if (this.getGameTurn() != 0) {
                    sb.append(s.logToString() + newLine);
                    sb.append(s.getAllNotes() + newLine);
                }
                sb.append(newLine);
            }
            ++i;
        }
        sb.append(newLine);
        return sb.toString();
    }

    public void writeAllFiles(boolean combatTurn) {
        this.writeAllFiles(combatTurn, ".");
    }

    public void writeAllFiles(boolean combatTurn, String path) {
        this.writeAllFiles(combatTurn, path, false);
    }

    public void sendAllFiles(boolean combatTurn, String path) {
        this.writeAllFiles(combatTurn, path, true);
    }

    public void writeAllFiles(boolean combatTurn, String path, boolean email) {
        Player p;
        String prefix = "Game" + this.getId() + "_Turn" + StringUtils.turnNumber(this.getGameTurn());
        String suffix = ".xml";
        String combat = combatTurn ? "_D" : "_B_Combat";
        String masterFileName = prefix + combat + suffix;
        int j = 0;
        while ((p = this.getPlayer(j++)) != null) {
            p.setKey(Dice.makeKey());
        }
        File f = new File(path, masterFileName);
        this.writeGameEngine(f);
        j = 0;
        while ((p = this.getPlayer(j++)) != null) {
            if (p.isGameMaster()) {
                if (!email) continue;
                this.sendGameEngine(masterFileName, p);
                continue;
            }
            boolean useGZip = p.getSendCompressed();
            String player = "_Player" + p.getId();
            String fileName = prefix + player + combat + suffix;
            f = useGZip ? new File(path, fileName + ".gz") : new File(path, fileName);
            this.writeGameEngine(f, p);
            if (!email) continue;
            if (useGZip) {
                try {
                    MailToServer.sendZipFile(p.getEmail(), fileName, f.getAbsolutePath(), "Server Game Turn");
                }
                catch (Exception e) {
                    System.err.println("Error sending GZip game file.");
                    System.err.println("Sending plain text instead.");
                    this.sendGameEngine(fileName, p);
                }
                continue;
            }
            this.sendGameEngine(fileName, p);
        }
    }

    public void saveToFile(File f) throws Exception {
        FileOutputStream fos = new FileOutputStream(f);
        PrintWriter out = new PrintWriter(fos);
        out.println("<?xml version=\"1.0\" standalone=\"yes\" ?>");
        out.println(this.toXML());
        out.close();
        fos.close();
    }

    public void saveToScenarioFile(File f) throws Exception {
        FileOutputStream fos = new FileOutputStream(f);
        PrintWriter out = new PrintWriter(fos);
        out.println("<?xml version=\"1.0\" standalone=\"yes\" ?>");
        out.println(this.toXML(1));
        out.close();
        fos.close();
    }

    public void writeGameEngine(File f) {
        try {
            this.saveToFile(f);
        }
        catch (Exception e) {
            System.err.println("Unable to open file " + f + " for writing!");
        }
    }

    public void sendGameEngine(String subject, Player p) {
        if (p == null || p.getEmail().equals("")) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" standalone=\"yes\" ?>");
        buffer.append(System.getProperty("line.separator"));
        if (p.isGameMaster()) {
            buffer.append(this.toXML());
        } else {
            buffer.append(this.toXML(p));
        }
        try {
            MailToServer.sendMail(p.getEmail(), subject, buffer.toString(), "Server Game Turn", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendGameEngine(Player p) {
        String subject = "";
        String suffix = ".xml";
        subject = subject + "Game" + this.getId() + "_Turn" + StringUtils.turnNumber(this.getGameTurn());
        String combat = this.isCombatPhase() ? "_B_Combat" : "_D";
        subject = subject + "_Player" + p.getId() + combat + suffix;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" standalone=\"yes\" ?>");
        buffer.append(System.getProperty("line.separator"));
        buffer.append(this.toXML(p));
        try {
            MailToServer.sendMail(p.getEmail(), subject, buffer.toString(), "Server Game Turn", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeGameEngine(File f, Player p) {
        try {
            OutputStream fos = new FileOutputStream(f);
            if (f.getName().endsWith(".gz")) {
                fos = new GZIPOutputStream(fos);
            }
            PrintWriter out = new PrintWriter(fos);
            out.println("<?xml version=\"1.0\" standalone=\"yes\" ?>");
            out.println(this.toXML(p));
            out.close();
            fos.close();
        }
        catch (Exception e) {
            System.err.println("Unable to open file " + f + " for writing!");
        }
    }

    public String getSuggestMovementOrdersFilename(Player p) {
        StringBuffer sb = new StringBuffer();
        int currentTurn = this.getGameTurn() + 1;
        sb.append("Game");
        sb.append(this.getId());
        sb.append("_T");
        sb.append(StringUtils.turnNumber(currentTurn));
        sb.append("_P");
        sb.append(p.getId());
        sb.append("_A_MOrders.xml");
        return sb.toString();
    }

    public void writeMovementOrders(Player p, Writer out) throws IOException {
        String sep = System.getProperty("line.separator");
        String s = "<GameEngine id=\"" + this.getId() + "\" name=\"" + this.getName() + "\" turn=\"" + this.getGameTurn() + "\" combat=\"false\">";
        out.write("<?xml version=\"1.0\" standalone=\"yes\" ?>");
        out.write(sep);
        out.write(s);
        out.write(sep);
        out.write(p.movementOrdersToXML());
        out.write("</GameEngine>");
        out.write(sep);
    }

    public void saveMovementOrders(Player p, File f) {
        try {
            FileOutputStream fos = new FileOutputStream(f);
            PrintWriter out = new PrintWriter(fos);
            this.writeMovementOrders(p, out);
            out.close();
            fos.close();
        }
        catch (Exception e) {
            System.err.println("Unable to open file " + f + " for writing!");
        }
    }

    public String getSuggestCombatOrdersFilename(Player p) {
        StringBuffer sb = new StringBuffer();
        sb.append("Game");
        sb.append(this.getId());
        sb.append("_T");
        sb.append(StringUtils.turnNumber(this.getGameTurn()));
        sb.append("_P");
        sb.append(p.getId());
        sb.append("_C_COrders.xml");
        return sb.toString();
    }

    public void saveCombatOrders(Player p, File f) {
        try {
            FileOutputStream fos = new FileOutputStream(f);
            PrintWriter out = new PrintWriter(fos);
            this.writeCombatOrders(p, out);
            out.close();
            fos.close();
        }
        catch (Exception e) {
            System.err.println("Unable to open file " + f + " for writing!");
        }
    }

    public void writeCombatOrders(Player p, Writer out) throws IOException {
        String sep = System.getProperty("line.separator");
        String s = "<GameEngine id=\"" + this.getId() + "\" name=\"" + this.getName() + "\" turn=\"" + this.getGameTurn() + "\" combat=\"true\">";
        out.write("<?xml version=\"1.0\" standalone=\"yes\" ?>");
        out.write(sep);
        out.write(s);
        out.write(sep);
        out.write(p.combatOrdersToXML());
        out.write("</GameEngine>");
        out.write(sep);
    }

    public String toString() {
        return this.getName();
    }

    public String toXML() {
        String s = "";
        String nL = System.getProperty("line.separator");
        s = s + "<GameEngine id=\"" + this.getId() + "\" name=\"" + this.getName() + "\" turn=\"" + this.getGameTurn() + "\" combat=\"" + this.isCombatPhase() + "\">" + nL;
        s = s + nL;
        s = s + this.options.toXML();
        s = s + nL;
        s = s + this.briefingToXML();
        s = s + nL;
        s = s + this.reportToXML();
        s = s + nL;
        int count = this.Players.size();
        for (int i = 0; i < count; ++i) {
            Player p = (Player)this.Players.get(i);
            s = s + p.toXML(1);
            s = s + nL;
        }
        s = s + "</GameEngine>" + nL;
        return s;
    }

    public String toXML(int level) {
        String s = "";
        String nL = System.getProperty("line.separator");
        s = s + "<GameEngine id=\"" + this.getId() + "\" name=\"" + this.getName() + "\" turn=\"" + this.getGameTurn() + "\" combat=\"" + this.isCombatPhase() + "\">" + nL;
        s = s + nL;
        s = s + this.options.toXML();
        s = s + nL;
        s = s + this.briefingToXML();
        s = s + nL;
        s = s + this.reportToXML();
        s = s + nL;
        int count = this.Players.size();
        for (int i = 0; i < count; ++i) {
            Player p = (Player)this.Players.get(i);
            s = s + p.toXML(level);
            s = s + nL;
        }
        s = s + "</GameEngine>" + nL;
        return s;
    }

    public String toXML(Player primary) {
        String s = "";
        String nL = System.getProperty("line.separator");
        if (primary == null) {
            s = this.toXML();
            return s;
        }
        ArrayList<Player> playerAndAllies = new ArrayList<Player>();
        String primaryTeam = primary.getTeam();
        for (int i = 0; i < this.Players.size(); ++i) {
            Player query = (Player)this.Players.get(i);
            if (!query.getTeam().equals(primaryTeam)) continue;
            playerAndAllies.add(query);
        }
        s = s + "<GameEngine id=\"" + this.getId() + "\" name=\"" + this.getName() + "\" turn=\"" + this.getGameTurn() + "\" combat=\"" + this.isCombatPhase() + "\">" + nL;
        s = s + this.briefingToXML();
        s = s + nL;
        s = s + this.options.toXML();
        s = s + nL;
        s = s + this.reportToXML();
        s = s + nL;
        s = s + primary.toXML(2);
        s = s + nL;
        int count = this.Players.size();
        for (int i = 0; i < count; ++i) {
            Player p = (Player)this.Players.get(i);
            if (p == primary) continue;
            String team = p.getTeam();
            if (primaryTeam.equals(team)) {
                s = s + p.toXML(3);
            } else {
                int sensors = this.options.getSensorRules();
                switch (sensors) {
                    case 0: {
                        s = s + p.toXML(4);
                        break;
                    }
                    case 1: {
                        s = s + p.toXML(this.options.getSensorLevel());
                        break;
                    }
                    case 2: {
                        s = s + p.toXML(playerAndAllies);
                        break;
                    }
                    case 3: {
                        s = s + p.toXML(playerAndAllies);
                        break;
                    }
                    default: {
                        s = s + p.toXML(4);
                    }
                }
            }
            s = s + nL;
        }
        s = s + "</GameEngine>" + nL;
        return s;
    }

    private String briefingToXML() {
        String sep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String briefing = XMLUtilities.wrapSpecialCharsXML(this.getScenarioBriefing());
        sb.append("    <Briefing>" + briefing + "</Briefing>" + sep);
        return sb.toString();
    }

    private String reportToXML() {
        String sep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String t = XMLUtilities.getIndent();
        sb.append(t).append("<Report>").append(sep);
        for (int i = 0; i < this.report.size(); ++i) {
            LogRecord l = (LogRecord)this.report.get(i);
            sb.append(l.toTurnReportXML());
        }
        sb.append(t).append("</Report>").append(sep);
        return sb.toString();
    }

    public String gameStatus() {
        StringBuffer sb = new StringBuffer();
        if (this.getActivePlayer() == null) {
            for (int i = 0; i < this.AllShips.size(); ++i) {
                Ship s = (Ship)this.AllShips.get(i);
                sb.append(s.getName() + ", ");
                sb.append(s.getHull().getRemainingHull() + ", ");
                sb.append(s.getHull().getTotalHull() + ", ");
                sb.append(System.getProperty("line.separator"));
            }
        }
        return sb.toString();
    }
}

