/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.FighterGroup;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;
import java.util.ArrayList;

public abstract class FighterOrders {
    public String toXML(FighterGroup fg) {
        return this.toXML(fg, 2);
    }

    public String toXML(FighterGroup fg, int numberOfIndents) {
        StringBuffer s = new StringBuffer();
        String sep = System.getProperty("line.separator");
        String ind = XMLUtilities.getIndent();
        DecimalFormat df = new DecimalFormat("0.0");
        s.append(ind).append(ind);
        if (numberOfIndents == 3) {
            s.append(ind);
        }
        s.append("<FighterOrders");
        s.append(" id=\"").append(fg.getId()).append("\">");
        s.append(sep);
        s.append(ind).append(ind).append(ind);
        if (numberOfIndents == 3) {
            s.append(ind);
        }
        s.append("<Orders>");
        s.append(this.toString());
        s.append("</Orders>");
        s.append(sep);
        s.append(ind).append(ind).append(ind);
        if (numberOfIndents == 3) {
            s.append(ind);
        }
        s.append("<MoveTo");
        s.append(" x=\"");
        s.append(df.format(fg.getXPosition())).append("\"");
        s.append(" y=\"");
        s.append(df.format(fg.getYPosition())).append("\"");
        s.append(" heading=\"");
        s.append(fg.getHeading()).append("\"");
        s.append("/>");
        s.append(sep);
        s.append(ind).append(ind).append(ind);
        if (numberOfIndents == 3) {
            s.append(ind);
        }
        s.append("<SecondaryMovement");
        s.append(" value=\"");
        s.append(fg.mayUseSecondaryMove()).append("\"");
        s.append("/>");
        s.append(sep);
        s.append(ind).append(ind).append(ind);
        if (numberOfIndents == 3) {
            s.append(ind);
        }
        s.append("<OnBoard");
        s.append(" value=\"");
        s.append(fg.isOnBoard()).append("\"");
        s.append("/>");
        s.append(sep);
        s.append(ind).append(ind).append(ind);
        if (numberOfIndents == 3) {
            s.append(ind);
        }
        s.append("<Target");
        s.append(" id=\"").append(fg.getTargetId()).append("\"");
        s.append("/>");
        s.append(sep);
        s.append(ind).append(ind);
        if (numberOfIndents == 3) {
            s.append(ind);
        }
        s.append("</FighterOrders>").append(sep);
        return s.toString();
    }

    public void setDestinationToCarrier(FighterGroup fg, boolean findCarrier) {
        Ship s;
        if (findCarrier || fg.getTargetId() < 0) {
            Ship sCarrier = fg.getClosestFriendlyCarrier();
            if (sCarrier == null) {
                return;
            }
            fg.setTargetId(sCarrier.getId());
        }
        if ((s = fg.getGameEngine().getShipById(fg.getTargetId())) == null || s.isDestroyed() || s.hasJumped()) {
            return;
        }
        fg.setMoveToX(s.getXPosition());
        fg.setMoveToY(s.getYPosition());
        fg.setMoveToHeading(fg.headingTo(s.getXPosition(), s.getYPosition()));
        String targetName = s.getClassAbbrev() + " " + s.getName();
        fg.addLog("Status", "Low", fg.getName() + " is returning to " + targetName + ".");
        s.addLog("Status", "Low", fg.getName() + " is returning to " + targetName + ".");
    }

    public void moveToOrderedPosition(FighterGroup fg, boolean secondaryMovePhase) {
        boolean maySecMove = fg.mayUseSecondaryMove();
        boolean onBoardCarrier = fg.isOnBoard();
        if (secondaryMovePhase && !maySecMove) {
            return;
        }
        if (onBoardCarrier) {
            this.moveWithCarrier(fg);
            return;
        }
        double[] point = new double[2];
        double secMove = fg.getOptions().getFighterSecondaryRange();
        double range = SpaceObject.range(fg.getMoveToX(), fg.getMoveToY(), fg.getXPosition(), fg.getYPosition());
        fg.setHeading(fg.getMoveToHeading());
        if (!secondaryMovePhase) {
            if (range <= (double)fg.getSpeed()) {
                fg.setXPosition(fg.getMoveToX());
                fg.setYPosition(fg.getMoveToY());
            } else {
                point = fg.rangeBoundsAlongVector(fg.getMoveToX(), fg.getMoveToY(), fg.getSpeed());
                fg.setXPosition(point[0]);
                fg.setYPosition(point[1]);
            }
        } else {
            fg.useCombatEndurance();
            fg.addLog("Status", "Low", fg.getName() + " is using combat endurance for movement.");
            if (range > 0.1 && range <= secMove) {
                fg.setXPosition(fg.getMoveToX());
                fg.setYPosition(fg.getMoveToY());
            } else {
                point = fg.rangeBoundsAlongVector(fg.getMoveToX(), fg.getMoveToY(), secMove);
                fg.setXPosition(point[0]);
                fg.setYPosition(point[1]);
            }
        }
    }

    public void moveWithCarrier(FighterGroup fg) {
        if (fg.getCount() == 0) {
            return;
        }
        Ship carrier = fg.getCarrierShip();
        if (carrier != null) {
            fg.setXPosition(carrier.getXPosition());
            fg.setYPosition(carrier.getYPosition());
        }
    }

    public void moveToScreenShip(FighterGroup fg) {
        boolean maySecMove = fg.mayUseSecondaryMove();
        double secMove = fg.getOptions().getFighterSecondaryRange();
        Ship s = fg.getGameEngine().getShipById(fg.getTargetId());
        if (s == null || s.isDestroyed() || s.hasJumped()) {
            this.moveToOrderedPosition(fg, false);
            return;
        }
        double range = SpaceObject.range(s.getXPosition(), s.getYPosition(), fg.getXPosition(), fg.getYPosition());
        double[] point = new double[2];
        double xTickle = 0.5 - Math.random();
        double yTickle = 0.5 - Math.random();
        double rangeTickle = 2.4 - 4.8 * Math.random();
        if (fg.mayScreenMove() || range <= (double)fg.getSpeed()) {
            point = fg.rangeBoundsAlongVector(s.getXPosition() + xTickle, s.getYPosition() + yTickle, range + rangeTickle);
            fg.addLog("Status", "Medium", fg.getName() + " is screening " + s.getClassAbbrev() + " " + s.getName() + ".");
            s.addLog("Status", "Medium", fg.getName() + " is screening " + s.getClassAbbrev() + " " + s.getName() + ".");
        } else if (range <= (double)fg.getSpeed() + secMove && maySecMove) {
            point = fg.rangeBoundsAlongVector(s.getXPosition() + xTickle, s.getYPosition() + yTickle, range + rangeTickle);
            fg.useCombatEndurance();
            fg.addLog("Status", "Low", fg.getName() + " is using combat endurance for movement.");
            fg.addLog("Status", "Medium", fg.getName() + " is screening " + s.getClassAbbrev() + " " + s.getName() + ".");
            s.addLog("Status", "Medium", fg.getName() + " is screening " + s.getClassAbbrev() + " " + s.getName() + ".");
        } else {
            double maxRange = fg.getSpeed();
            if (maySecMove) {
                maxRange += secMove;
            }
            point = fg.rangeBoundsAlongVector(s.getXPosition(), s.getYPosition(), maxRange);
            if (maySecMove) {
                fg.useCombatEndurance();
                fg.addLog("Status", "Low", fg.getName() + " is using combat endurance for movement.");
            }
        }
        fg.setXPosition(point[0]);
        fg.setYPosition(point[1]);
        fg.setHeading(s.getHeading());
    }

    public void closeToTarget(FighterGroup fg) {
        double targetY;
        double targetX;
        boolean maySecMove = fg.mayUseSecondaryMove();
        int targetId = fg.getTargetId();
        if (!maySecMove) {
            return;
        }
        if (targetId == 0) {
            return;
        }
        double[] point = new double[2];
        double secMove = fg.getOptions().getFighterSecondaryRange();
        SpaceObject so = null;
        Ship s = null;
        String targetName = null;
        if (targetId == -1) {
            s = fg.getClosestEnemyShip();
            if (s == null) {
                fg.setTargetId(0);
                return;
            }
            fg.setTargetId(s.getId());
            targetX = s.getXPosition();
            targetY = s.getYPosition();
            targetName = s.getClassAbbrev() + " " + s.getName();
        } else if (targetId == -2) {
            double theRange = fg.getOptions().getFighterRange() + fg.getOptions().getFighterSecondaryRange();
            ArrayList tLt = fg.whoIsInMyAttackRange(theRange);
            FighterGroup efg = fg.whoIsThePriorityTarget(tLt);
            so = efg;
            if (so == null) {
                fg.setTargetId(0);
                return;
            }
            fg.setTargetId(so.getId());
            targetX = so.getXPosition();
            targetY = so.getYPosition();
            targetName = so.getName();
        } else {
            so = fg.getGameEngine().getObjectById(targetId);
            if (so == null) {
                fg.setTargetId(0);
                return;
            }
            fg.setTargetId(so.getId());
            targetX = so.getXPosition();
            targetY = so.getYPosition();
            targetName = so instanceof Ship ? ((Ship)so).getClassAbbrev() + " " + so.getName() : so.getName();
        }
        double range = SpaceObject.range(targetX, targetY, fg.getXPosition(), fg.getYPosition());
        fg.setHeading(fg.headingTo(targetX, targetY));
        if (range <= fg.getOptions().getFighterRange()) {
            return;
        }
        if (range <= secMove) {
            point = fg.rangeBoundsAlongVector(targetX, targetY, range - 0.5);
            fg.setXPosition(point[0]);
            fg.setYPosition(point[1]);
            fg.useCombatEndurance();
            fg.addLog("Attack", "Low", fg.getName() + " is using combat endurance to engage " + targetName + ".");
        } else if (range <= secMove + fg.getOptions().getFighterRange()) {
            point = fg.rangeBoundsAlongVector(targetX, targetY, secMove);
            fg.setXPosition(point[0]);
            fg.setYPosition(point[1]);
            fg.useCombatEndurance();
            fg.addLog("Attack", "Low", fg.getName() + " is using combat endurance to engage " + targetName + ".");
        } else {
            fg.addLog("Status", "Low", fg.getName() + " is unable to close to engage " + targetName + ".");
        }
    }

    public abstract String toString();

    public abstract String getBriefDescription();

    public abstract String getDescription();

    public abstract void doMove(FighterGroup var1);

    public abstract void doReaction(FighterGroup var1, boolean var2);

    public abstract void doSecondaryMove(FighterGroup var1);

    public abstract void doCombat(FighterGroup var1);
}

