/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.ShipSystem;
import ftjava.util.Dice;

public class CoreCommandBridge
extends ShipSystem {
    private int turnsDisabled;
    private final int MAXIMUM_TURNS = 6;

    public CoreCommandBridge() {
        this.setSystemName("Command Bridge");
        this.setTurnsDisabled(0);
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
    }

    public void takeThresholdCheck(int level) {
        if (this.getSystemStatus().equals("Destroyed")) {
            return;
        }
        if (Dice.rollD6() < level + 1) {
            return;
        }
        if (this.getSystemStatus().equals("Damaged")) {
            this.setDestroyed();
            this.setTurnsDisabled(6);
        } else {
            this.setTurnsDisabled(Dice.rollD6());
            this.setDamaged();
            if (this.getTurnsDisabled() >= 6) {
                this.setDestroyed();
            }
        }
    }

    public void setTurnsDisabled(int turns) {
        this.turnsDisabled = turns;
    }

    public int getTurnsDisabled() {
        return this.turnsDisabled;
    }

    public void decrementTurnsDisabled() {
        if (this.getSystemStatus().equals("Destroyed")) {
            return;
        }
        --this.turnsDisabled;
        if (this.turnsDisabled <= 0) {
            this.setRepaired();
            this.turnsDisabled = 0;
        }
    }

    public int computeMass() {
        return 0;
    }

    public int computePointCost() {
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("   ");
        sb.append(this.getSystemName());
        if (!this.getSystemStatus().equals("Operational")) {
            while (sb.length() < this.getOptions().getStatusSpacing()) {
                sb.append(" ");
            }
            sb.append(this.getSystemStatus());
            sb.append(" (");
            sb.append(this.getTurnsDisabled());
            sb.append(")");
        }
        return sb.toString();
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String result = "";
        StringBuffer sb = new StringBuffer();
        if (level == 0) {
            return result;
        }
        if (level >= 5) {
            return result;
        }
        sb.append("<CoreCommandBridge id=\"");
        sb.append(this.getId());
        sb.append("\"");
        sb.append(" status=\"" + this.getSystemStatus() + "\"");
        if (!this.getSystemStatus().equals("Operational")) {
            sb.append(" turnsDisabled=\"" + this.getTurnsDisabled() + "\"");
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"" + this.getNotes() + "\"");
        }
        sb.append("/>");
        return sb.toString();
    }
}

