/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.Holds;
import ftjava.std.ShipSystem;
import ftjava.util.XMLUtilities;

public class CargoHold
extends Holds {
    private String type;
    private int totalSize;
    private int[] rowSize;
    private String[] holdStatus;
    private int damageLevel;

    public CargoHold() {
        this(8);
    }

    public CargoHold(int s) {
        this("Cargo Hold", s);
    }

    public CargoHold(String t, int s) {
        this.setTotalSize(s);
        this.type = t;
        this.setSystemName(this.type);
        this.setDamageLevel(7);
        this.rowInitialize();
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
    }

    public void setDamageLevel(int level) {
        this.damageLevel = level;
    }

    public int getDamageLevel() {
        return this.damageLevel;
    }

    private void rowInitialize() {
        int i;
        this.rowSize = new int[4];
        this.holdStatus = new String[4];
        for (i = 0; i < 4; ++i) {
            this.holdStatus[i] = "Operational";
        }
        this.takeThresholdCheck(this.damageLevel);
        for (i = 0; i < this.getTotalSize(); ++i) {
            int n = i % 4;
            this.rowSize[n] = this.rowSize[n] + 1;
        }
    }

    public void setValue(String Name, String Value) {
        boolean handled = false;
        if (Name.equals("type")) {
            this.type = Value;
            this.setSystemName(Value);
            handled = true;
        }
        if (Name.equals("totalSize")) {
            this.setTotalSize(Integer.parseInt(Value));
            this.rowInitialize();
            handled = true;
        }
        if (Name.equals("damageLevel")) {
            this.setDamageLevel(Integer.parseInt(Value));
            this.takeThresholdCheck(this.getDamageLevel());
            handled = true;
        }
        if (!handled) {
            super.setValue(Name, Value);
        }
    }

    public void setType(String t) {
        this.type = t;
    }

    public String getType() {
        return this.type;
    }

    public void setTotalSize(int s) {
        if (s <= 3) {
            s = 4;
        }
        this.totalSize = s;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void takeThresholdCheck(int level) {
        if (level <= 6) {
            this.holdStatus[0] = "Destroyed";
        }
        if (level <= 5) {
            this.holdStatus[1] = "Destroyed";
        }
        if (level <= 4) {
            this.holdStatus[2] = "Destroyed";
        }
        this.setDamageLevel(level);
    }

    public int computeMass() {
        return this.totalSize;
    }

    public int computePointCost() {
        return 0;
    }

    public String toString() {
        String padding = "   ";
        String newLine = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            StringBuffer ln = new StringBuffer();
            ln.append(padding + this.getSystemName() + " (" + this.rowSize[i] + ") ");
            if (!this.holdStatus[i].equals("Operational")) {
                while (ln.length() < this.getOptions().getStatusSpacing()) {
                    ln.append(" ");
                }
                ln.append(this.holdStatus[i]);
            }
            if (i != 3) {
                ln.append(newLine);
            }
            sb.append(ln.toString());
        }
        return sb.toString();
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String t = XMLUtilities.getIndent();
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        if (level >= 6) {
            return "";
        }
        sb.append(t + "<CargoHold ");
        if (level > 0) {
            sb.append("id=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        sb.append(" type=\"" + this.getType());
        sb.append("\" totalSize=\"" + this.getTotalSize() + "\"");
        if (level != 0 && level != 5 && this.damageLevel <= 6) {
            sb.append(" damageLevel=\"");
            sb.append(this.getDamageLevel());
            sb.append("\"");
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"" + this.getNotes() + "\"");
        }
        sb.append("/>");
        sb.append(sep);
        return sb.toString();
    }

    static {
        Holds.addSystem("CargoHold", new CargoHold());
    }
}

