/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.Electronics;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import ftjava.util.XMLUtilities;

public class AreaDefenseFireControl
extends Electronics {
    private int defendedTargetId;

    public AreaDefenseFireControl() {
        this.setDefendedTargetId(0);
        this.setSystemName("Area Defense Fire Control");
        this.setId(ShipSystem.getIdCounter());
        ShipSystem.incrementIdCounter();
    }

    public void setDefendedTargetId(int id) {
        this.defendedTargetId = id;
    }

    public int getDefendedTargetId() {
        return this.defendedTargetId;
    }

    public void setDefendedTarget(SpaceObject t) {
        if (t != null) {
            this.setDefendedTargetId(t.getId());
        } else {
            this.setDefendedTargetId(0);
        }
    }

    public int computeMass() {
        return 2;
    }

    public int computePointCost() {
        return 8;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("   ");
        sb.append(this.getSystemName());
        while (sb.length() < this.getOptions().getStatusSpacing()) {
            sb.append(" ");
        }
        if (!this.getSystemStatus().equals("Operational")) {
            sb.append(this.getSystemStatus());
        } else if (this.defendedTargetId != 0) {
            sb.append("(");
            sb.append(this.defendedTargetId);
            sb.append(")");
        }
        return sb.toString();
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String s = "";
        String t = XMLUtilities.getIndent();
        String newLine = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        if (level >= 6) {
            return s;
        }
        sb.append(t);
        sb.append(t);
        sb.append("<AreaDefenseFireControl");
        if (level > 0) {
            sb.append(" id=\"");
            sb.append(this.getId());
            sb.append("\"");
        }
        if (this.isSSDDefined()) {
            sb.append(" xSSD=\"" + this.getXSSD() + "\"");
            sb.append(" ySSD=\"" + this.getYSSD() + "\"");
        }
        if (level != 0 && level != 5) {
            if (this.defendedTargetId != 0) {
                sb.append(" defendedTargetId=\"");
                sb.append(this.defendedTargetId);
                sb.append("\"");
            }
            sb.append(" status=\"");
            sb.append(this.getSystemStatus());
            sb.append("\"");
        }
        if ((level == 2 || level == 1) && this.anyNotes()) {
            sb.append(" notes=\"");
            sb.append(this.getNotes());
            sb.append("\"");
        }
        sb.append("/>");
        sb.append(newLine);
        return sb.toString();
    }

    static {
        Electronics.addSystem("AreaDefenseFireControl", new AreaDefenseFireControl());
    }
}

