/*
 * Decompiled with CFR 0.152.
 */
package ftjava.std;

import ftjava.std.FighterGroup;
import ftjava.std.GameEngine;
import ftjava.std.MissileSalvo;
import ftjava.std.PlasmaBolt;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import ftjava.std.Weapon;
import ftjava.util.Dice;
import ftjava.util.StringUtils;
import ftjava.util.XMLUtilities;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;

public class AntiMatterTorpedo
extends SpaceObject {
    private String team = "";
    private String race = "";
    private int strength = 3;
    private int launchingShipId = 0;
    private int launcherId = 0;
    private SpaceObject target = null;
    private int targetId = 0;
    private boolean hasAttacked = false;

    public void setName() {
        this.setName("AMT " + this.getId());
    }

    public void setTeam(String s) {
        this.team = s;
    }

    public String getTeam() {
        return this.team;
    }

    public void setRace(String s) {
        this.race = s;
    }

    public String getRace() {
        return this.race;
    }

    public void setStrength(int t) {
        this.strength = t;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setLaunchingShipId(int id) {
        this.launchingShipId = id;
    }

    public int getLaunchingShipId() {
        return this.launchingShipId;
    }

    public void setLauncherId(int id) {
        this.launcherId = id;
    }

    public int getLauncherId() {
        return this.launcherId;
    }

    public void setTarget(SpaceObject t) {
        this.target = t;
    }

    public SpaceObject getTarget() {
        return this.target;
    }

    public void setTargetId(int t) {
        this.targetId = t;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public void setHasAttacked(boolean b) {
        this.hasAttacked = b;
    }

    public boolean hasAttacked() {
        return this.hasAttacked;
    }

    private Ship getLaunchingShip() {
        return this.getGameEngine().getShipById(this.launchingShipId);
    }

    private Weapon getLauncher() {
        Ship s = this.getLaunchingShip();
        if (s == null) {
            return null;
        }
        return s.getWeaponById(this.launcherId);
    }

    public double getMaximumRange() {
        double result = this.getOptions().getAntiMatterTorpedoRange();
        return result;
    }

    public void takeDamage(int[] hits) {
        for (int i = 0; i < hits.length; ++i) {
            this.strength -= hits[i];
        }
        if (this.strength < 0) {
            this.strength = 0;
        }
    }

    public void acquireTarget(ArrayList allShips, double lockOnRange) {
        SpaceObject bestShipSoFar = null;
        double bestShipRange = lockOnRange;
        Weapon launcher = this.getLauncher();
        for (int i = 0; i < allShips.size(); ++i) {
            double thisRange;
            Ship s;
            SpaceObject o = (SpaceObject)allShips.get(i);
            if (!(o instanceof Ship) || (s = (Ship)o).isDestroyed() || s.hasJumped() || s.getTeam().equals(this.getTeam()) || (thisRange = this.rangeTo(s) * s.getRangeStealthModifier()) > lockOnRange || bestShipSoFar != null && thisRange >= bestShipRange) continue;
            bestShipSoFar = s;
            bestShipRange = thisRange;
        }
        if (bestShipSoFar != null) {
            this.setTarget(bestShipSoFar);
            this.setTargetId(bestShipSoFar.getId());
            this.target.addLog("Attack", "Medium", this.getName() + ": AntiMatter torpedo targeting.");
            launcher.setNotes("Targeting " + this.target.getName());
        } else {
            launcher.setNotes("No targets in range.");
        }
    }

    public void fireAt() {
        String playTestResults = "";
        Weapon launcher = this.getLauncher();
        this.setHasAttacked(true);
        if (this.strength == 0) {
            launcher.setNotes("Torpedo was destroyed.");
            return;
        }
        this.target = this.getGameEngine().getShipById(this.targetId);
        if (this.targetId != 0 && this.target != null) {
            this.setXPosition(this.target.getXPosition());
            this.setYPosition(this.target.getYPosition());
        }
        double blastRadius = this.getOptions().getAntiMatterTorpedoBlastRange();
        int[] damage = new int[1];
        GameEngine game = this.getGameEngine();
        ArrayList allObjects = game.getActiveObjects();
        for (int i = 0; i < allObjects.size(); ++i) {
            SpaceObject so = (SpaceObject)allObjects.get(i);
            int screenLevel = 0;
            if (so instanceof AntiMatterTorpedo || so instanceof PlasmaBolt || this.rangeTo(so) > blastRadius) continue;
            if (so.isShip()) {
                Ship s = (Ship)so;
                if (s.isDestroyed() || s.hasJumped() || !s.hasArrived()) continue;
                screenLevel = ((Ship)so).getNumberOfActiveScreens();
            }
            if (so instanceof FighterGroup) {
                if (((FighterGroup)so).isOnBoard()) continue;
                FighterGroup fg = (FighterGroup)so;
                if (fg.getType().isAHeavyFighter()) {
                    screenLevel = 1;
                }
            }
            damage[0] = 0;
            playTestResults = "";
            int reduction = (int)Math.floor(this.rangeTo(so));
            int attack = this.strength - reduction;
            block6: for (int j = 0; j < attack; ++j) {
                int die = Dice.rollD6();
                playTestResults = playTestResults + "(" + die + ") ";
                switch (die) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        damage[0] = damage[0] + die;
                        continue block6;
                    }
                    case 5: {
                        if (screenLevel < 2) {
                            damage[0] = damage[0] + die;
                            continue block6;
                        }
                    }
                    case 6: {
                        if (screenLevel >= 1) continue block6;
                        damage[0] = damage[0] + die;
                    }
                }
            }
            String record = this.getName() + ": AntiMatter Torpedo hit for " + StringUtils.points(damage[0]) + ".";
            String report = this.getName() + " hit " + so.getName() + " for " + StringUtils.points(damage[0]) + ".";
            if (this.getOptions().getPlayTest()) {
                record = record + " " + playTestResults;
                report = report + " " + playTestResults;
            }
            game.addTurnReport("Attack", "High", report);
            if (so instanceof MissileSalvo) {
                ((MissileSalvo)so).takeDamage(damage);
            }
            if (so instanceof FighterGroup) {
                ((FighterGroup)so).takeDamage(damage);
            }
            if (!so.isShip()) continue;
            ((Ship)so).takeDamage(damage);
            so.addLog("Attack", "High", record);
        }
    }

    public String toString() {
        String result = "";
        String sep = System.getProperty("line.separator");
        DecimalFormat df = new DecimalFormat("0.0");
        result = result + this.team + " " + this.getName() + sep;
        while (result.length() < this.getOptions().getStatusSpacing()) {
            result = result + " ";
        }
        result = result + sep;
        result = result + "Position: ";
        result = result + df.format(this.getXPosition()) + ", ";
        result = result + df.format(this.getYPosition()) + sep;
        return result;
    }

    private String ind(int level) {
        if (level > 0) {
            return XMLUtilities.getIndent() + XMLUtilities.getIndent();
        }
        return "";
    }

    public String toXML() {
        return this.toXML(0);
    }

    public String toXML(int level) {
        String s = "";
        String sep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        String t = XMLUtilities.getIndent();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat df = new DecimalFormat("0.0");
        df.setDecimalFormatSymbols(dfs);
        if (level == 10) {
            return s;
        }
        sb.append(this.ind(level) + "<AntiMatterTorpedo");
        if (level >= 1) {
            sb.append(" id=\"" + this.getId() + "\">" + sep);
        } else {
            sb.append(">" + sep);
        }
        if (level >= 1) {
            sb.append(this.ind(level) + t + "<Position ");
            sb.append("x=\"" + df.format(this.getXPosition()) + "\" ");
            sb.append("y=\"" + df.format(this.getYPosition()) + "\"/>" + sep);
            sb.append(this.ind(level) + t);
            sb.append("<Heading heading=\"" + this.getHeading() + "\"/>" + sep);
            sb.append(this.ind(level) + t);
            sb.append("<Race>" + this.getRace() + "</Race>" + sep);
            if (this.getIconFamily() != null) {
                sb.append(this.ind(level)).append(t);
                sb.append("<IconFamily value=\"");
                sb.append(this.getIconFamily());
                sb.append("\"/>").append(sep);
            }
            sb.append(this.ind(level) + t);
            sb.append("<Ship id=\"" + this.getLaunchingShipId());
            sb.append("\"/>" + sep);
            sb.append(this.ind(level) + t);
            sb.append("<Launcher id=\"" + this.getLauncherId());
            sb.append("\"/>" + sep);
            if (this.getTargetId() != 0) {
                sb.append(this.ind(level) + t);
                sb.append("<Target id=\"" + this.getTargetId());
                sb.append("\"/>" + sep);
            }
        }
        sb.append(this.ind(level) + "</AntiMatterTorpedo>" + sep);
        return sb.toString();
    }

    public String movementOrdersToXML() {
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        String t = XMLUtilities.getIndent();
        sb.append(t + t + "<LaunchAMT ");
        sb.append("shipId=\"" + this.getLaunchingShipId() + "\" ");
        sb.append("launcherId=\"" + this.getLauncherId() + "\" ");
        sb.append("x=\"" + this.getXPosition() + "\" ");
        sb.append("y=\"" + this.getYPosition() + "\" ");
        sb.append("heading=\"" + this.getHeading() + "\"/>");
        sb.append(sep);
        return sb.toString();
    }
}

