/*
 * Decompiled with CFR 0.152.
 */
package ftjava.server;

import ftjava.mailman.MailToServer;
import ftjava.server.ServerUtilities;
import ftjava.std.GameEngine;
import ftjava.std.Player;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.mail.MessagingException;

public class ServerQuery {
    static boolean debug = false;

    public static void sendHelp(String to) {
        String help = "";
        String sep = System.getProperty("line.separator");
        help = help + sep;
        help = help + "FTJava Server help commands" + sep + sep;
        help = help + "The FTJava server responds to a number of query commands found" + sep;
        help = help + "in the subject line of a message that it receives." + sep + sep;
        help = help + "HELP" + sep + sep;
        help = help + "Send this message." + sep + sep + sep;
        help = help + "STATUS Game####" + sep + sep;
        help = help + "Send the status of the game denoted by the Game# syntax.";
        help = help + "This command" + sep;
        help = help + "will report if the game is active, the current turn and";
        help = help + " the orders " + sep;
        help = help + "required for continued processing, and any other pertinent game " + sep;
        help = help + "information. The syntax of the game string is case sensitive.  A" + sep;
        help = help + "query for game 30 could read 'Status Game30' or 'status Game30' " + sep;
        help = help + "or 'STATUS Game30'.  'status GAME 30' or 'status game30' would  " + sep;
        help = help + "not be accepted." + sep + sep + sep;
        help = help + "RESEND Game####" + sep + sep;
        help = help + "Resends the game file for the respective player by matching the" + sep;
        help = help + "From: field on the query to a player in the game.  The resent XML" + sep;
        help = help + "will be sent to the e-mail address denoted in the gamefile." + sep;
        help = help + sep + sep;
        help = help + "Thanks for playing!" + sep + sep;
        help = help + "FTJava Game Master" + sep;
        try {
            MailToServer.sendSimpleMail(to, "FTJava Help", help, "Server reply");
        }
        catch (MessagingException me) {
            me.printStackTrace();
        }
    }

    public static void sendNoGameFound(String to, String command) {
        String msg = "";
        String sep = System.getProperty("line.separator");
        msg = msg + sep;
        msg = msg + "::: " + command + " :::" + sep + sep;
        msg = msg + "No game name was found in your query." + sep + sep;
        msg = msg + "FTJava Game Master" + sep;
        try {
            MailToServer.sendSimpleMail(to, "FTJava Reply", msg, "Server reply");
        }
        catch (MessagingException me) {
            me.printStackTrace();
        }
    }

    public static void sendNotAnActiveGame(String to, String gameId) {
        String msg = "";
        String sep = System.getProperty("line.separator");
        String subj = "FTJava Reply Re: " + gameId;
        msg = msg + sep;
        msg = msg + "The game, " + gameId + ", is not an active game." + sep + sep;
        msg = msg + "FTJava Game Master" + sep;
        try {
            MailToServer.sendSimpleMail(to, subj, msg, "Server reply");
        }
        catch (MessagingException me) {
            me.printStackTrace();
        }
    }

    public static void sendUnableToFindGame(String to, String gameId) {
        String msg = "";
        String sep = System.getProperty("line.separator");
        String subj = "FTJava Reply Re: " + gameId;
        msg = msg + sep;
        msg = msg + "The game, " + gameId + ", cannot be found." + sep + sep;
        msg = msg + "FTJava Game Master" + sep;
        try {
            MailToServer.sendSimpleMail(to, subj, msg, "Server reply");
        }
        catch (MessagingException me) {
            me.printStackTrace();
        }
    }

    public static void sendStatus(String to, String gameId, String status) {
        String msg = "";
        String sep = System.getProperty("line.separator");
        String subj = "FTJava Reply Re: " + gameId;
        msg = msg + status + sep + sep;
        msg = msg + "FTJava Game Master" + sep;
        try {
            MailToServer.sendSimpleMail(to, subj, msg, "Server reply");
        }
        catch (MessagingException me) {
            me.printStackTrace();
        }
    }

    public static void sendActiveGames(String to, String postOffice) throws Exception {
        String msg = "";
        String sep = System.getProperty("line.separator");
        File postOfficeDir = new File(postOffice);
        if (!postOfficeDir.exists()) {
            throw new Exception("Missing Post office directory!");
        }
        msg = msg + sep + "All active games" + sep + sep;
        Object[] gameList = postOfficeDir.list();
        Arrays.sort(gameList);
        for (int i = 0; i < gameList.length; ++i) {
            if (((String)gameList[i]).indexOf("Game") != 0) continue;
            msg = msg + "   " + (String)gameList[i] + sep;
        }
        try {
            MailToServer.sendSimpleMail(to, "FTJava Reply - All Active Games", msg, "Server reply");
        }
        catch (MessagingException me) {
            me.printStackTrace();
        }
    }

    public static void sendAllStatus(String to, String status) {
        String msg = "";
        String sep = System.getProperty("line.separator");
        msg = msg + sep + status + sep + sep;
        msg = msg + "FTJava Game Master" + sep;
        try {
            MailToServer.sendSimpleMail(to, "FTJava Reply - Status - All Games", msg, "Server reply");
        }
        catch (MessagingException me) {
            me.printStackTrace();
        }
    }

    public static void sendNotPlayer(String to, String gameId) {
        String msg = "";
        String sep = System.getProperty("line.separator");
        String subj = "FTJava Reply Re: " + gameId;
        msg = msg + sep;
        msg = msg + "Unable to resend game due to mail address mismatch." + sep;
        msg = msg + sep;
        msg = msg + "FTJava Game Master" + sep;
        try {
            MailToServer.sendSimpleMail(to, subj, msg, "Server reply");
        }
        catch (MessagingException me) {
            me.printStackTrace();
        }
    }

    public static void resendGame(int playerNumber, String postOffice, String gameId) {
        GameEngine game = ServerUtilities.getLatestGame(postOffice, gameId);
        Player p = game.getPlayerById(playerNumber);
        game.sendGameEngine(p);
    }

    public static void resendAllGame(String postOffice, String gameId) {
        GameEngine game = ServerUtilities.getLatestGame(postOffice, gameId);
        ArrayList players = game.getPlayers();
        for (int i = 0; i < players.size(); ++i) {
            Player p = game.getPlayer(i);
            if (p.isPlayerDead() || p.isPlayerRobot()) continue;
            game.sendGameEngine(p);
        }
    }

    public static String helpMessage() {
        StringBuffer help = new StringBuffer();
        String sep = System.getProperty("line.separator");
        help.append(sep);
        help.append("For help, send 'help' as the subject in an e-mail ");
        help.append("to your FTJava Server.");
        help.append(sep);
        return help.toString();
    }
}

