/*
 * Decompiled with CFR 0.152.
 */
package ftjava.server;

import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.QPDecoderStream;
import com.sun.mail.util.SharedByteArrayInputStream;
import ftjava.mailman.MailToServer;
import ftjava.server.AutomaticGameStart;
import ftjava.server.ProcessDeadline;
import ftjava.server.ProcessFinishGame;
import ftjava.server.ProcessGame;
import ftjava.server.ProcessQuery;
import ftjava.server.ServerQuery;
import ftjava.std.GameMaster;
import ftjava.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.AndTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.HeaderTerm;
import javax.mail.search.SearchTerm;

public class Server
extends TimerTask {
    private static int counter = 0;
    private static int messageCount = 0;
    private static int deadlineCheck = 120;
    private static int completionCheck = 60;
    private static boolean debug = false;
    private static String sep = System.getProperty("line.separator");
    public static Properties props = new Properties();
    private static GameMaster gm = new GameMaster();
    private static HashMap authStarters = new HashMap();
    private static String startersFile = "starters.txt";

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: ftjava.server.Server <props>");
            System.exit(1);
        }
        Server.loadPropertiesFile(args[0]);
        String debugMe = props.getProperty("debug");
        if (debugMe != null && debugMe.equals("true")) {
            debug = true;
        }
        authStarters = Server.loadAuthorizedGameStarters(startersFile);
        Server s = new Server();
        Timer timer = new Timer();
        long period = Long.parseLong(props.getProperty("FetchInterval"));
        timer.schedule((TimerTask)s, 0L, period);
    }

    public void run() {
        ++counter;
        try {
            this.fetchMailAndProcess();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                StringBuffer sb = new StringBuffer();
                sb.append(e.toString()).append(sep).append(sep);
                sb.append(StringUtils.traceToString(e));
                MailToServer.sendSimpleMail(gm.getEmail(), "FTJava Server Exception", sb.toString(), "Server error");
            }
            catch (MessagingException me) {
                me.printStackTrace();
                System.out.println("We're really hosed");
            }
        }
        if (counter % completionCheck == 2) {
            System.out.println("-------- Completion check ----------");
            ProcessFinishGame.execute();
        }
        if (counter % deadlineCheck == 6) {
            System.out.println("---------- Deadline check ----------");
            ProcessDeadline.execute();
        }
    }

    public void fetchMailAndProcess() throws Exception {
        Calendar currentTime = Calendar.getInstance();
        Runtime rt = Runtime.getRuntime();
        boolean didSomeWork = false;
        Session session = Session.getDefaultInstance((Properties)props, null);
        Store store = session.getStore();
        String protocol = props.getProperty("mail.store.protocol");
        String host = props.getProperty("mail." + protocol + ".host");
        String user = props.getProperty("mail." + protocol + ".user");
        String password = props.getProperty("mail." + protocol + ".password");
        String fName = props.getProperty("mail." + protocol + ".folder");
        store.connect(host, user, password);
        Folder folder = store.getDefaultFolder();
        folder = folder.getFolder(fName);
        folder.open(2);
        Flags flags = new Flags();
        flags.add(Flags.Flag.FLAGGED);
        FlagTerm flagterm = new FlagTerm(flags, false);
        HeaderTerm headerterm = new HeaderTerm("FTJava-PBEM", "Client");
        AndTerm term = new AndTerm((SearchTerm)flagterm, (SearchTerm)headerterm);
        Message[] messages = folder.search((SearchTerm)headerterm);
        messages = folder.getMessages();
        System.out.print(currentTime.getTime().toString());
        if (messages.length == 1) {
            System.out.print("  Found: " + messages.length + " Message ");
        } else {
            System.out.print("  Found: " + messages.length + " Messages");
        }
        System.out.println(" - " + counter + "." + (messageCount += messages.length));
        HashSet<String> modifiedGames = new HashSet<String>();
        for (int i = 0; i < messages.length; ++i) {
            Object messageContent;
            String messageSubject;
            boolean saved;
            HashMap games;
            String replyTo;
            String gameDirectory;
            boolean newGame;
            block20: {
                didSomeWork = true;
                newGame = false;
                gameDirectory = "";
                replyTo = "";
                games = new HashMap();
                saved = true;
                messageSubject = "bogus";
                messageContent = null;
                try {
                    Address[] from = messages[i].getFrom();
                    replyTo = from[0].toString();
                    if (from[0] == null) break block20;
                    System.out.println("    Receiving message from " + from[0]);
                }
                catch (AddressException ae) {
                    messageSubject = "bogus";
                    messageContent = null;
                    messages[i].setFlag(Flags.Flag.DELETED, true);
                    Server.mailException((Exception)((Object)ae));
                    continue;
                }
            }
            try {
                messageSubject = messages[i].getSubject();
                messageContent = messages[i].getContent();
            }
            catch (Exception e) {
                messageSubject = "bogus";
                messageContent = null;
                messages[i].setFlag(Flags.Flag.DELETED, true);
                Server.mailException(e);
                continue;
            }
            ProcessQuery.execute(replyTo, messageSubject, messageContent);
            boolean processAGame = true;
            try {
                processAGame = Server.processContent(replyTo, messageSubject, messageContent, games);
            }
            catch (Exception e) {
                messageSubject = "bogus";
                messageContent = null;
                messages[i].setFlag(Flags.Flag.DELETED, true);
                Server.mailException(e);
                continue;
            }
            if (processAGame) {
                Iterator keys = games.keySet().iterator();
                while (keys.hasNext()) {
                    String filename = (String)keys.next();
                    String contents = (String)games.get(filename);
                    StringTokenizer st = new StringTokenizer(filename, "_", false);
                    gameDirectory = st.nextToken();
                    if (gameDirectory.equals(filename)) {
                        StringTokenizer st2 = new StringTokenizer(filename, ".", false);
                        gameDirectory = st2.nextToken();
                        newGame = true;
                    }
                    File directory = new File(props.getProperty("PostOfficeDirectory"), gameDirectory);
                    try {
                        if (newGame) {
                            directory.mkdirs();
                        }
                        if (!directory.exists()) {
                            System.out.println("   Non-existant game!");
                            continue;
                        }
                        File gamefile = new File(directory, filename);
                        PrintWriter fout = new PrintWriter(new BufferedWriter(new FileWriter(gamefile)));
                        fout.print(contents);
                        fout.close();
                        modifiedGames.add(gameDirectory);
                        saved = true;
                    }
                    catch (Exception e) {
                        System.out.println("   Failed to save message");
                        saved = false;
                    }
                    String subject = "FTJava: " + gameDirectory;
                    String rc = "";
                    String timeStamp = currentTime.getTime().toString();
                    if (newGame) {
                        replyTo = gm.getEmail();
                        rc = rc + "\n";
                        rc = rc + "A new game message for " + gameDirectory;
                        rc = rc + " has been received at " + timeStamp + ".";
                    } else {
                        String gameTurn = st.nextToken();
                        rc = rc + "Your ";
                        rc = filename.indexOf("MOrders") != -1 ? rc + "movement " : rc + "combat ";
                        rc = rc + "orders for " + gameTurn;
                        rc = rc + " have been received at " + timeStamp + ".";
                        File checkDir = new File(props.getProperty("PostOfficeDirectory"), gameDirectory);
                        rc = rc + sep + sep + ProcessGame.waitingOn(checkDir);
                        rc = rc + ServerQuery.helpMessage();
                    }
                    MailToServer.sendSimpleMail(replyTo, subject, rc, "Server acknowledgement");
                }
            }
            messages[i].setFlag(Flags.Flag.DELETED, true);
        }
        Iterator modifiedGame = modifiedGames.iterator();
        boolean runGames = false;
        while (modifiedGame.hasNext()) {
            runGames = true;
            String s = (String)modifiedGame.next();
            System.out.println(sep + sep + "Processing: " + s);
            File directory = new File(props.getProperty("PostOfficeDirectory"), s);
            ProcessGame.process(directory);
        }
        folder.close(true);
        if (didSomeWork) {
            System.out.println("    Sleeping...");
        }
    }

    public static boolean processContent(String sender, String subject, Object o, HashMap games) throws Exception {
        String newStart = "New FTJava game request";
        String signUp = "infobot@firedrake.org";
        String start = "new game";
        int gameId = 0;
        boolean autoStart = false;
        boolean processed = false;
        boolean result = false;
        String[] headers = new String[]{"FTJava-PBEM"};
        if (Server.debugMode()) {
            System.out.println(o.getClass().getName());
        }
        if (o instanceof MimeMultipart) {
            MimeMultipart mmp = (MimeMultipart)o;
            if (Server.debugMode()) {
                System.out.println("Found MimeMultiPart: Count = " + mmp.getCount());
            }
            int count = mmp.getCount();
            for (int i = 0; i < count; ++i) {
                result = Server.processContent(sender, subject, mmp.getBodyPart(i), games);
                if (!result) continue;
                processed = true;
            }
            return processed;
        }
        if (o instanceof MimeBodyPart) {
            String gameName;
            String search;
            MimeBodyPart mbp = (MimeBodyPart)o;
            String disp = mbp.getDisposition();
            String filename = mbp.getFileName();
            if (Server.debugMode()) {
                System.out.println("Found MimeBodyPart: " + mbp.getContentType());
                System.out.println("      File:         " + filename);
                System.out.println("      Disp:         " + disp);
            }
            if (!(mbp.isMimeType("text/xml") && mbp.isMimeType("application/octet") || !debug)) {
                System.out.println("Wrong Mime type");
            }
            if (filename == null) {
                if (Server.debugMode()) {
                    System.out.println("No file attached");
                }
                return processed;
            }
            if (filename.indexOf("/") != -1 || filename.indexOf("\\") != -1) {
                StringTokenizer sd = new StringTokenizer(filename, "\\/");
                while (sd.hasMoreTokens()) {
                    filename = sd.nextToken();
                }
            }
            if (Server.debugMode()) {
                System.out.println("      File2:        " + filename);
            }
            if ((search = filename.toUpperCase()).indexOf("GAME") != 0) {
                System.out.println("No Game ID");
                return processed;
            }
            boolean starterNewStart = Server.isANewStart(sender, subject);
            if (starterNewStart) {
                gameId = AutomaticGameStart.getGameNumber();
                gameName = new String("Game" + gameId);
                filename = gameName + ".xml";
                System.out.println("::: Automatic start process");
                System.out.println("::: Sender:   " + sender);
                System.out.println("::: Subject:  " + subject);
                System.out.println("::: Game:     " + gameName);
                System.out.println();
                AutomaticGameStart.incrementGameNumber();
                autoStart = true;
            } else {
                StringTokenizer gst = new StringTokenizer(filename, "_", false);
                gameName = gst.nextToken();
                String password = props.getProperty("server.password");
                if (gameName.equals(filename)) {
                    System.out.println();
                    System.out.println("::: Subject:  " + subject);
                    System.out.println("::: Game:     " + gameName);
                    System.out.println();
                    if (subject.indexOf(password) == -1) {
                        System.out.println("Password not found");
                        System.out.println();
                        return processed;
                    }
                }
            }
            Object o1 = mbp.getContent();
            if (debug) {
                System.out.println(o1.getClass().getName());
            }
            if (mbp.getContent() instanceof String) {
                System.out.println("    Found File: " + filename);
                StringTokenizer st = new StringTokenizer(filename, "_", false);
                if (!st.hasMoreTokens()) {
                    return processed;
                }
                if (autoStart) {
                    StringBuffer orig = new StringBuffer((String)mbp.getContent());
                    String filter = AutomaticGameStart.gameFilter(gameId, orig);
                    games.put(filename, filter);
                } else {
                    games.put(filename, (String)mbp.getContent());
                }
            } else if (mbp.getContent() instanceof QPDecoderStream) {
                System.out.println("    Found File: " + filename);
                StringTokenizer st = new StringTokenizer(filename, "_", false);
                if (!st.hasMoreTokens()) {
                    return processed;
                }
                int b = 0;
                int i = 0;
                int cap = 1000;
                StringBuffer sb = new StringBuffer(cap);
                QPDecoderStream qp = (QPDecoderStream)mbp.getContent();
                try {
                    while ((b = qp.read()) != -1) {
                        sb.append((char)b);
                        if (++i != cap - 1) continue;
                        sb.ensureCapacity(cap *= 2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(0);
                }
                if (autoStart) {
                    String filter = AutomaticGameStart.gameFilter(gameId, sb);
                    games.put(filename, filter);
                } else {
                    games.put(filename, sb.toString());
                }
            } else if (mbp.getContent() instanceof SharedByteArrayInputStream) {
                System.out.println("    Found File: " + filename);
                StringTokenizer st = new StringTokenizer(filename, "_", false);
                if (!st.hasMoreTokens()) {
                    return processed;
                }
                int b = 0;
                int i = 0;
                int cap = 1000;
                StringBuffer sb = new StringBuffer(cap);
                SharedByteArrayInputStream is = (SharedByteArrayInputStream)mbp.getContent();
                try {
                    while ((b = is.read()) != -1) {
                        sb.append((char)b);
                        if (++i != cap - 1) continue;
                        sb.ensureCapacity(cap *= 2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(0);
                }
                if (autoStart) {
                    String filter = AutomaticGameStart.gameFilter(gameId, sb);
                    games.put(filename, filter);
                } else {
                    games.put(filename, sb.toString());
                }
            } else if (mbp.getContent() instanceof BASE64DecoderStream) {
                System.out.println("    Found File: " + filename);
                StringTokenizer st = new StringTokenizer(filename, "_", false);
                if (!st.hasMoreTokens()) {
                    return processed;
                }
                int b = 0;
                int i = 0;
                int cap = 1000;
                StringBuffer sb = new StringBuffer(cap);
                BASE64DecoderStream is = (BASE64DecoderStream)mbp.getContent();
                try {
                    while ((b = is.read()) != -1) {
                        sb.append((char)b);
                        if (++i != cap - 1) continue;
                        sb.ensureCapacity(cap *= 2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(0);
                }
                if (autoStart) {
                    String filter = AutomaticGameStart.gameFilter(gameId, sb);
                    games.put(filename, filter);
                } else {
                    games.put(filename, sb.toString());
                }
            }
            processed = true;
            return processed;
        }
        return false;
    }

    public static void loadPropertiesFile(String filename) {
        File propFile = new File(filename);
        try {
            props.load(new FileInputStream(propFile));
        }
        catch (Exception e) {
            System.out.println("Failure to load FTJava Server property file!");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static HashMap loadAuthorizedGameStarters(String filename) {
        File starterFile = new File(filename);
        FileReader fr = null;
        BufferedReader br = null;
        String input = " ";
        String address = null;
        String password = null;
        StringTokenizer st = null;
        HashMap<String, String> starters = new HashMap<String, String>();
        System.out.println("Load authorized starter file");
        try {
            fr = new FileReader(starterFile);
            br = new BufferedReader(fr);
            while (input != null && (input = br.readLine()) != null) {
                if (input.length() == 0) continue;
                st = new StringTokenizer(input);
                address = st.nextToken();
                password = st.nextToken();
                System.out.println("   Authorized starter: " + address);
                starters.put(address, password);
            }
            br.close();
            System.out.println();
        }
        catch (IOException io) {
            System.err.println("IO Exception!");
        }
        return starters;
    }

    public static Properties getProperties() {
        return props;
    }

    public static boolean debugMode() {
        String debugMe = props.getProperty("debug");
        return debugMe != null && debugMe.equals("true");
    }

    public static void mailException(Exception e) {
        e.printStackTrace();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(e.toString()).append(sep).append(sep);
            sb.append(StringUtils.traceToString(e));
            MailToServer.sendSimpleMail(gm.getEmail(), "FTJava Server Exception", sb.toString(), "Server error");
        }
        catch (MessagingException me) {
            me.printStackTrace();
            System.out.println("We're really hosed");
        }
    }

    public static boolean isANewStart(String sender, String subject) {
        String newStart = "New FTJava game request";
        String signUp = "infobot@firedrake.org";
        String start = "new game";
        if (sender == null || subject == null) {
            return false;
        }
        if (sender.equals(signUp) && subject.equals(newStart)) {
            return true;
        }
        sender = sender.toLowerCase();
        sender = Server.cullEMailAddress(sender);
        if ((subject = subject.toLowerCase()).indexOf(start) == -1) {
            return false;
        }
        if (!authStarters.containsKey(sender)) {
            return false;
        }
        String password = (String)authStarters.get(sender);
        return subject.indexOf(password) != -1;
    }

    private static String cullEMailAddress(String a) {
        String result = " ";
        StringTokenizer st = new StringTokenizer(a);
        boolean found = false;
        while (!found && st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.indexOf("@") == -1) continue;
            found = true;
            token = token.replace('<', ' ');
            token = token.replace('>', ' ');
            result = token.trim();
        }
        return result;
    }
}

