/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.util;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Hexagon
implements Cloneable,
Shape {
    public static final int OUTER_RADIUS = 1;
    private double radius;
    private double x0;
    private double y0;
    private Point2D.Double[] points = new Point2D.Double[6];
    static AffineTransform eye = new AffineTransform();

    public Hexagon(double r, double x, double y) {
        this.radius = r;
        this.x0 = x;
        this.y0 = y;
        this.points[0] = new Point2D.Double(r, 0.0);
        this.points[1] = new Point2D.Double(r * 0.5, r * Math.sqrt(3.0) / 2.0);
        this.points[2] = new Point2D.Double(-r * 0.5, r * Math.sqrt(3.0) / 2.0);
        this.points[3] = new Point2D.Double(-r, 0.0);
        this.points[4] = new Point2D.Double(-r * 0.5, -r * Math.sqrt(3.0) / 2.0);
        this.points[5] = new Point2D.Double(r * 0.5, -r * Math.sqrt(3.0) / 2.0);
        AffineTransform t = AffineTransform.getTranslateInstance(this.x0, this.y0);
        for (int i = 0; i < this.points.length; ++i) {
            t.transform(this.points[i], this.points[i]);
        }
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(double x, double y) {
        double d = 0.0;
        double t = x - this.x0;
        d += t * t;
        t = y - this.y0;
        return Math.sqrt(d += t * t) <= this.radius;
    }

    public boolean contains(double x, double y, double w, double h) {
        boolean b = this.contains(x, y);
        b = b && this.contains(x + w, y);
        b = b && this.contains(x, y + h);
        b = b && this.contains(x + w, y + h);
        return b;
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Rectangle2D getBounds2D() {
        double dy = this.radius * Math.sqrt(3.0) / 2.0;
        return new Rectangle2D.Double(this.x0 - this.radius, this.y0 - dy, 2.0 * this.radius, 2.0 * dy);
    }

    public PathIterator getPathIterator(AffineTransform t) {
        return new HexagonPathIterator(t);
    }

    public PathIterator getPathIterator(AffineTransform t, double flatness) {
        return this.getPathIterator(t);
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersects(double x, double y, double w, double h) {
        Rectangle2D.Double r = (Rectangle2D.Double)this.getBounds2D();
        if (x < r.x & y < r.y & x + w > r.x + r.width & y + h > r.y + r.height) {
            return true;
        }
        return this.contains(x, y) | this.contains(x + w, y) | this.contains(x, y + h) | this.contains(x + w, y + h);
    }

    static {
        eye.setToIdentity();
    }

    class HexagonPathIterator
    implements PathIterator {
        AffineTransform transform;
        int segment = 0;
        Point2D.Double curr_point;

        HexagonPathIterator(AffineTransform t) {
            this.transform = t != null ? t : eye;
            this.curr_point = new Point2D.Double();
        }

        public int currentSegment(float[] coords) {
            if (this.segment >= Hexagon.this.points.length) {
                return 4;
            }
            this.transform.transform(Hexagon.this.points[this.segment], this.curr_point);
            coords[0] = (float)this.curr_point.x;
            coords[1] = (float)this.curr_point.y;
            return this.segment == 0 ? 0 : 1;
        }

        public int currentSegment(double[] coords) {
            if (this.segment >= Hexagon.this.points.length) {
                return 4;
            }
            this.transform.transform(Hexagon.this.points[this.segment], this.curr_point);
            coords[0] = this.curr_point.x;
            coords[1] = this.curr_point.y;
            return this.segment == 0 ? 0 : 1;
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return this.segment > Hexagon.this.points.length;
        }

        public void next() {
            ++this.segment;
        }
    }
}

