/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd.variant;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.std.Weapon;
import ftjava.std.variant.LongRangePulseTorpedo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class LongRangePulseTorpedoWidget
extends SystemWidget {
    private static final long serialVersionUID = 1L;
    private static final Dimension PULSE_TORP_BASE_SIZE = new Dimension(41, 71);
    private static final Arc2D FRONT_PORT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 36.0, 36.0, 120.0, 60.0, 2);
    private static final Arc2D FRONT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 36.0, 36.0, 60.0, 60.0, 2);
    private static final Arc2D FRONT_STARBOARD_ARC_AREA = new Arc2D.Double(0.0, 0.0, 36.0, 36.0, 0.0, 60.0, 2);
    private static final Arc2D AFT_STARBOARD_ARC_AREA = new Arc2D.Double(0.0, 0.0, 36.0, 36.0, 300.0, 60.0, 2);
    private static final Arc2D AFT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 36.0, 36.0, 240.0, 60.0, 2);
    private static final Arc2D AFT_PORT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 36.0, 36.0, 180.0, 60.0, 2);
    private static final GeneralPath arc;
    private static final Rectangle2D whiteBlock;
    private static final Rectangle2D darkBlock;

    public LongRangePulseTorpedoWidget(LongRangePulseTorpedo pt) {
        this(pt, false);
    }

    public LongRangePulseTorpedoWidget() {
        this(new LongRangePulseTorpedo(), true);
    }

    public LongRangePulseTorpedoWidget(LongRangePulseTorpedo pt, boolean mutable) {
        super(pt, mutable);
        this.initialisePTMenuItems();
        this.setMinimumSize(PULSE_TORP_BASE_SIZE);
        this.setMaximumSize(PULSE_TORP_BASE_SIZE);
        this.setPreferredSize(PULSE_TORP_BASE_SIZE);
        this.setSize(PULSE_TORP_BASE_SIZE);
        this.setToolTipText(this.getToolTip());
    }

    public void paint(Graphics g_o) {
        int i;
        Graphics2D g = (Graphics2D)g_o;
        int fireArcs = ((Weapon)this.theSystem).getArcs();
        AffineTransform originalTransform = g.getTransform();
        g.translate(LongRangePulseTorpedoWidget.GLYPH_OFFSET.x, LongRangePulseTorpedoWidget.GLYPH_OFFSET.y);
        AffineTransform lastTransform = g.getTransform();
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        boolean isRearFacing = false;
        if (this.mutable) {
            for (i = 0; i < 6; ++i) {
                g.setColor(Color.lightGray);
                g.draw(arc);
                g.rotate(-1.0471975511965976, 18.0, 18.0);
            }
            g.setTransform(lastTransform);
        }
        if ((fireArcs & Weapon.AFT_ARC) != 0) {
            isRearFacing = true;
        }
        if (!isRearFacing && (fireArcs & Weapon.ALL_ARCS) != Weapon.FORE_ARC) {
            for (i = 0; i < 6; ++i) {
                if ((fireArcs >> i + 21 & 1) != 0) {
                    g.setColor(Color.white);
                    g.fill(arc);
                    g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
                    g.draw(arc);
                }
                g.rotate(-1.0471975511965976, 18.0, 18.0);
            }
            g.setTransform(lastTransform);
        }
        g.setColor(Color.white);
        g.fill(whiteBlock);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(whiteBlock);
        g.fill(darkBlock);
        g.draw(darkBlock);
        Font old = g.getFont();
        g.setFont(old.deriveFont(1));
        g.setColor(Color.white);
        g.drawString("L", 16, 28);
        g.setFont(old);
        if (isRearFacing) {
            for (i = 0; i < 6; ++i) {
                if ((fireArcs >> i + 21 & 1) != 0) {
                    g.setColor(Color.white);
                    g.fill(arc);
                    g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
                    g.draw(arc);
                }
                g.rotate(-1.0471975511965976, 18.0, 18.0);
            }
        }
        g.setTransform(originalTransform);
        SSDDrawingTools.indicateStatus(g, this);
    }

    public void mouseClicked(MouseEvent me) {
        super.mouseClicked(me);
        int x = me.getX();
        int y = me.getY();
        int mods = me.getModifiers();
        LongRangePulseTorpedo thePT = (LongRangePulseTorpedo)this.theSystem;
        if ((mods & 1) != 0 && !me.isConsumed()) {
            if (FRONT_ARC_AREA.contains(x, y)) {
                thePT.setArcs(thePT.getArcs() ^ Weapon.FORE_ARC);
            } else if (FRONT_STARBOARD_ARC_AREA.contains(x, y)) {
                thePT.setArcs(thePT.getArcs() ^ Weapon.FORE_STARBOARD_ARC);
            } else if (AFT_STARBOARD_ARC_AREA.contains(x, y)) {
                thePT.setArcs(thePT.getArcs() ^ Weapon.AFT_STARBOARD_ARC);
            } else if (AFT_ARC_AREA.contains(x, y)) {
                thePT.setArcs(thePT.getArcs() ^ Weapon.AFT_ARC);
            } else if (AFT_PORT_ARC_AREA.contains(x, y)) {
                thePT.setArcs(thePT.getArcs() ^ Weapon.AFT_PORT_ARC);
            } else if (FRONT_PORT_ARC_AREA.contains(x, y)) {
                thePT.setArcs(thePT.getArcs() ^ Weapon.FORE_PORT_ARC);
            }
        }
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    public void actionPerformed(ActionEvent ae) {
        LongRangePulseTorpedo thePT = (LongRangePulseTorpedo)this.theSystem;
        String ac = ae.getActionCommand();
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    private void initialisePTMenuItems() {
        if (this.mutable) {
            this.popup.addSeparator();
        }
    }

    private String getToolTip() {
        LongRangePulseTorpedo pt = (LongRangePulseTorpedo)this.theSystem;
        return "Long Range Pulse Torpedo " + pt.getArcsString();
    }

    static {
        whiteBlock = new Rectangle2D.Double(13.0, 33.0, 10.0, 20.0);
        darkBlock = new Rectangle2D.Double(13.0, 13.0, 10.0, 20.0);
        arc = new GeneralPath();
        arc.reset();
        arc.moveTo(9.0f, (float)(18.0 * (1.0 + Math.sqrt(3.0) / 2.0)));
        arc.append(new Arc2D.Float(0.0f, 0.0f, 36.0f, 36.0f, 240.0f, 60.0f, 0), true);
        arc.lineTo(24.0f, (float)(18.0 + 12.0 * Math.sqrt(3.0) / 2.0));
        arc.append(new Arc2D.Float(6.0f, 6.0f, 24.0f, 24.0f, 300.0f, -60.0f, 0), true);
        arc.closePath();
    }
}

