/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.std.VapourShroud;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;

public class VapourShroudWidget
extends SystemWidget {
    private static final long serialVersionUID = 1L;
    private static final Dimension VS_SIZE = new Dimension(34, 34);
    private static final Ellipse2D circle = new Ellipse2D.Double(7.5, 7.5, 15.0, 15.0);
    private static final Ellipse2D dot = new Ellipse2D.Double(12.5, 0.0, 5.0, 5.0);

    public VapourShroudWidget(VapourShroud s) {
        this(s, false);
    }

    public VapourShroudWidget() {
        this(new VapourShroud(), true);
    }

    public VapourShroudWidget(VapourShroud s, boolean m) {
        super(s, m);
        this.setMinimumSize(VS_SIZE);
        this.setMaximumSize(VS_SIZE);
        this.setPreferredSize(VS_SIZE);
        this.setSize(VS_SIZE);
        this.setToolTipText("Vapour Shroud");
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        AffineTransform orgTransform = g.getTransform();
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.translate(2, 2);
        g.fill(circle);
        for (int i = 0; i < 8; ++i) {
            g.fill(dot);
            g.rotate(0.7853981633974483, 15.0, 15.0);
        }
        g.setTransform(orgTransform);
        SSDDrawingTools.indicateStatus(g, this);
    }
}

