/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.std.SubmunitionPack;
import ftjava.std.Weapon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;

public class SubmunitionPackWidget
extends SystemWidget {
    private static final long serialVersionUID = 1L;
    private static final Dimension SMP_SIZE = new Dimension(34, 34);
    private static final Ellipse2D ellipse = new Ellipse2D.Double(9.5, 7.5, 15.0, 15.0);
    private static final GeneralPath triPath = new GeneralPath();

    public SubmunitionPackWidget() {
        this(new SubmunitionPack(), true);
    }

    public SubmunitionPackWidget(SubmunitionPack smp) {
        this(smp, false);
    }

    public SubmunitionPackWidget(SubmunitionPack smp, boolean m) {
        super(smp, m);
        this.setPreferredSize(SMP_SIZE);
        this.setMinimumSize(SMP_SIZE);
        this.setMaximumSize(SMP_SIZE);
        this.setSize(SMP_SIZE);
        this.setToolTipText(this.getToolTip());
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        AffineTransform lastTransform = g.getTransform();
        int fireArcs = ((Weapon)this.theSystem).getArcs() >> 21;
        g.setColor(Color.white);
        g.fill(ellipse);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(ellipse);
        for (int i = 0; i < 6; ++i) {
            if ((fireArcs >> i & 1) == 0) continue;
            g.rotate((double)((i - 3) * -60) * Math.PI / 180.0, 17.0, 15.0);
            break;
        }
        g.fill(triPath);
        g.setTransform(lastTransform);
        SSDDrawingTools.indicateStatus(g, this);
    }

    private String getToolTip() {
        SubmunitionPack sm = (SubmunitionPack)this.theSystem;
        return "Submunition Pack " + sm.getArcsString();
    }

    static {
        triPath.reset();
        triPath.setWindingRule(1);
        triPath.moveTo(9.5f, 0.0f);
        triPath.lineTo(17.0f, 15.0f);
        triPath.lineTo(24.5f, 0.0f);
        triPath.closePath();
    }
}

