/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.Preferences;
import ftjava.gui.ssd.SystemWidget;
import ftjava.gui.util.ImageUtilities;
import ftjava.std.ShipSystem;
import java.awt.BasicStroke;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Properties;

public class SSDDrawingTools {
    private static boolean isInit = false;
    private static Color destroyedColor = Color.red;
    private static Color damagedColor = Color.yellow;
    private static Color expendedColor = Color.blue;
    private static Color okColor = Color.black;
    private static Color crossColor = Color.black;
    public static final int STATUS_BY_COLOR = 1;
    public static final int STATUS_BY_CROSS = 2;
    public static final int STATUS_BY_BOTH = 3;
    public static final int STATUS_BY_ICON = 4;
    public static final RenderingHints ANTIALIASING_ON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private static int statusMode = 1;
    private static AffineTransform lastTransform = null;
    private static BufferedImage damagedIcon = null;
    private static BufferedImage destroyedIcon = null;
    private static BufferedImage expendedIcon = null;
    static final TexturePaint backgroundPaint;
    private static Button dummyButton;

    public static void initialize() {
        int theStatusMode = 5;
        Properties props = Preferences.getPreferences();
        try {
            if (!props.getProperty("System Status by Color").equals("true")) {
                theStatusMode &= 0xFFFFFFFE;
            }
            if (!props.getProperty("System Status by Icon").equals("true")) {
                theStatusMode &= 0xFFFFFFFB;
            }
            if (props.getProperty("System Status by Crosses").equals("true")) {
                theStatusMode |= 2;
            }
        }
        catch (Exception e) {
            System.out.println("Error reading preferences");
        }
        SSDDrawingTools.setStatusMode(theStatusMode);
        SSDDrawingTools.updateColors();
        dummyButton = new Button();
        damagedIcon = ImageUtilities.getImage("Images/ssd_damaged_icon.gif", dummyButton);
        destroyedIcon = ImageUtilities.getImage("Images/ssd_destroyed_icon.gif", dummyButton);
        expendedIcon = ImageUtilities.getImage("Images/ssd_expended_icon.gif", dummyButton);
        isInit = true;
    }

    public static void updateColors() {
        Properties props = Preferences.getPreferences();
        okColor = Preferences.parseColor(props.getProperty("Operational System Color"));
        damagedColor = Preferences.parseColor(props.getProperty("Damaged System Color"));
        expendedColor = Preferences.parseColor(props.getProperty("Expended System Color"));
        destroyedColor = Preferences.parseColor(props.getProperty("Destroyed System Color"));
        crossColor = Preferences.parseColor(props.getProperty("Cross Color"));
    }

    public static Color getDestroyedColor() {
        return destroyedColor;
    }

    public static Color getDamagedColor() {
        return damagedColor;
    }

    public static Color getExpendedColor() {
        return expendedColor;
    }

    public static Color getOKColor() {
        return okColor;
    }

    public static Color getCrossColor() {
        return crossColor;
    }

    public static void setStatusMode(int mode) {
        if (mode < 0 || mode > 7) {
            return;
        }
        statusMode = mode;
        if ((mode & 4) != 0 && damagedIcon == null) {
            dummyButton = new Button();
            damagedIcon = ImageUtilities.getImage("Images/ssd_damaged_icon.gif", dummyButton);
            destroyedIcon = ImageUtilities.getImage("Images/ssd_destroyed_icon.gif", dummyButton);
            expendedIcon = ImageUtilities.getImage("Images/ssd_expended_icon.gif", dummyButton);
        }
    }

    public static Color getSystemColor(ShipSystem sys) {
        if (!isInit) {
            SSDDrawingTools.initialize();
        }
        Color out = okColor;
        if ((statusMode & 1) != 0) {
            if (sys.isDamaged()) {
                out = damagedColor;
            }
            if (sys.isDestroyed()) {
                out = destroyedColor;
            }
            if (sys.isExpended()) {
                out = expendedColor;
            }
        }
        return out;
    }

    public static void indicateStatus(Graphics2D g, SystemWidget sys_w) {
        if (!isInit) {
            SSDDrawingTools.initialize();
        }
        ShipSystem sys = sys_w.getShipSystem();
        Line2D.Double line = new Line2D.Double();
        if ((statusMode & 2) != 0) {
            Dimension glyphSize = sys_w.getSize();
            Stroke lastStroke = g.getStroke();
            BasicStroke l = new BasicStroke(3.0f, 1, 1);
            g.setStroke(l);
            if (sys.isDamaged() || sys.isDestroyed() || sys.isExpended()) {
                line.setLine(0.0, 0.0, glyphSize.width, glyphSize.height);
                g.setColor(crossColor);
                g.draw(line);
            }
            if (sys.isDestroyed() || sys.isExpended()) {
                line.setLine(glyphSize.width, 0.0, 0.0, glyphSize.height);
                g.draw(line);
            }
            g.setStroke(lastStroke);
        }
        if ((statusMode & 4) != 0) {
            if (sys.isDamaged()) {
                g.drawImage((Image)damagedIcon, 0, 0, dummyButton);
            } else if (sys.isDestroyed()) {
                g.drawImage((Image)destroyedIcon, 0, 0, dummyButton);
            } else if (sys.isExpended()) {
                g.drawImage((Image)expendedIcon, 0, 0, dummyButton);
            }
        }
    }

    static {
        dummyButton = null;
        BufferedImage bi = new BufferedImage(10, 10, 1);
        Graphics2D g = bi.createGraphics();
        g.setColor(new Color(0.9f, 0.9f, 0.9f));
        g.fillRect(0, 0, 10, 10);
        g.setColor(Color.white);
        g.drawLine(0, 0, 10, 0);
        g.drawLine(0, 0, 0, 10);
        backgroundPaint = new TexturePaint(bi, new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0));
    }
}

