/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.gui.util.IntegerInputDialog;
import ftjava.std.PlasmaBoltLauncher;
import ftjava.std.Weapon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;

public class PlasmaBoltLauncherWidget
extends SystemWidget {
    private static final Dimension SML_SIZE = new Dimension(31, 31);
    private static final Arc2D FRONT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 60.0, 60.0, 2);
    private static final Arc2D FRONT_STARBOARD_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 0.0, 60.0, 2);
    private static final Arc2D AFT_STARBOARD_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 300.0, 60.0, 2);
    private static final Arc2D AFT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 240.0, 60.0, 2);
    private static final Arc2D AFT_PORT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 180.0, 60.0, 2);
    private static final Arc2D FRONT_PORT_ARC_AREA = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 120.0, 60.0, 2);
    private static final Ellipse2D CENTER_AREA = new Ellipse2D.Double(5.0, 5.0, 20.0, 20.0);
    private static final Arc2D arc = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 240.0, 60.0, 2);
    private static final GeneralPath center;

    public PlasmaBoltLauncherWidget(PlasmaBoltLauncher pbl) {
        this(pbl, false);
    }

    public PlasmaBoltLauncherWidget() {
        this(new PlasmaBoltLauncher(), true);
    }

    public PlasmaBoltLauncherWidget(PlasmaBoltLauncher pbl, boolean mutable) {
        super(pbl, mutable);
        this.initialisePBLMenuItems();
        this.setMinimumSize(SML_SIZE);
        this.setMaximumSize(SML_SIZE);
        this.setPreferredSize(SML_SIZE);
        this.setSize(SML_SIZE);
        this.setToolTipText(this.getToolTip());
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        int fireArcs = ((Weapon)this.theSystem).getArcs() >> 21;
        AffineTransform lastTransform = g.getTransform();
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        for (int i = 0; i < 6; ++i) {
            if ((fireArcs >> i & 1) != 0) {
                g.setColor(Color.white);
                g.fill(arc);
                g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
                g.draw(arc);
            }
            g.rotate(-1.0471975511965976, 15.0, 15.0);
        }
        g.setColor(Color.white);
        g.fill(center);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(center);
        String strength = Integer.toString(((PlasmaBoltLauncher)this.theSystem).getRating());
        FontMetrics fm = g.getFontMetrics(g.getFont());
        g.drawString(strength, 15 - fm.stringWidth(strength) / 2, 15 + fm.getAscent() / 2 - 1);
        g.setTransform(lastTransform);
        SSDDrawingTools.indicateStatus(g, this);
    }

    public void mouseClicked(MouseEvent me) {
        super.mouseClicked(me);
        int x = me.getX();
        int y = me.getY();
        int mods = me.getModifiers();
        PlasmaBoltLauncher pbl = (PlasmaBoltLauncher)this.theSystem;
        if ((mods & 1) != 0 && !me.isConsumed()) {
            if (FRONT_ARC_AREA.contains(x, y)) {
                pbl.setArcs(pbl.getArcs() ^ Weapon.FORE_ARC);
            } else if (FRONT_STARBOARD_ARC_AREA.contains(x, y)) {
                pbl.setArcs(pbl.getArcs() ^ Weapon.FORE_STARBOARD_ARC);
            } else if (AFT_STARBOARD_ARC_AREA.contains(x, y)) {
                pbl.setArcs(pbl.getArcs() ^ Weapon.AFT_STARBOARD_ARC);
            } else if (AFT_ARC_AREA.contains(x, y)) {
                pbl.setArcs(pbl.getArcs() ^ Weapon.AFT_ARC);
            } else if (AFT_PORT_ARC_AREA.contains(x, y)) {
                pbl.setArcs(pbl.getArcs() ^ Weapon.AFT_PORT_ARC);
            } else if (FRONT_PORT_ARC_AREA.contains(x, y)) {
                pbl.setArcs(pbl.getArcs() ^ Weapon.FORE_PORT_ARC);
            }
        }
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    public void actionPerformed(ActionEvent ae) {
        PlasmaBoltLauncher pbl = (PlasmaBoltLauncher)this.theSystem;
        String ac = ae.getActionCommand();
        if (ac.equals("more")) {
            int newRating = IntegerInputDialog.showIntegerInputDialog(JOptionPane.getFrameForComponent(this), pbl.getRating());
            if (newRating >= 0) {
                pbl.setValue("rating", Integer.toString(newRating));
            }
        } else {
            try {
                pbl.setValue("rating", ac);
            }
            catch (NumberFormatException nfe) {
                super.actionPerformed(ae);
                this.repaint();
                return;
            }
        }
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    private void initialisePBLMenuItems() {
        if (this.mutable) {
            JRadioButtonMenuItem mi;
            this.popup.addSeparator();
            ButtonGroup bg = new ButtonGroup();
            for (int i = 1; i <= 4; ++i) {
                mi = new JRadioButtonMenuItem(Integer.toString(i), i == 1);
                mi.setActionCommand(Integer.toString(i));
                mi.addActionListener(this);
                bg.add(mi);
                this.popup.add(mi);
            }
            mi = new JRadioButtonMenuItem("More Sizes...", false);
            mi.setActionCommand("more");
            mi.addActionListener(this);
            bg.add(mi);
            this.popup.add(mi);
        }
    }

    private String getToolTip() {
        PlasmaBoltLauncher pbl = (PlasmaBoltLauncher)this.theSystem;
        return "Plasma Bolt Launcher " + pbl.getArcsString();
    }

    static {
        Point2D.Float p0 = new Point2D.Float(7.0f, 15.0f);
        Point2D.Float p1 = new Point2D.Float(3.0f, 15.0f);
        AffineTransform rt = AffineTransform.getRotateInstance(0.3141592653589793, 15.0, 15.0);
        rt.transform(p1, p1);
        rt = AffineTransform.getRotateInstance(0.6283185307179586, 15.0, 15.0);
        center = new GeneralPath();
        center.moveTo(p0.x, p0.y);
        for (int i = 0; i < 10; ++i) {
            center.lineTo(p0.x, p0.y);
            center.lineTo(p1.x, p1.y);
            rt.transform(p0, p0);
            rt.transform(p1, p1);
        }
        center.closePath();
    }
}

