/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.std.MissileLauncher;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class MissileLauncherWidget
extends SystemWidget {
    private static final Dimension MISSILE_LAUNCHER_SIZE = new Dimension(22, 52);
    private static final GeneralPath path = new GeneralPath();
    private static final GeneralPath empPath;
    private static final Line2D needlePoint;

    public MissileLauncherWidget() {
        this(new MissileLauncher(), true);
    }

    public MissileLauncherWidget(MissileLauncher cls) {
        this(cls, false);
    }

    public MissileLauncherWidget(MissileLauncher cls, boolean m) {
        super(cls, m);
        this.setPreferredSize(MISSILE_LAUNCHER_SIZE);
        this.setMinimumSize(MISSILE_LAUNCHER_SIZE);
        this.setMaximumSize(MISSILE_LAUNCHER_SIZE);
        this.setSize(MISSILE_LAUNCHER_SIZE);
        this.setToolTipText(cls.getSystemName());
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        MissileLauncher ml = (MissileLauncher)this.theSystem;
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        if (ml.getType().equals("Needle")) {
            g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        } else {
            g.setColor(Color.white);
        }
        g.fill(path);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(path);
        if (ml.getType().equals("Needle")) {
            g.draw(needlePoint);
        }
        if (ml.getType().equals("EMP")) {
            g.draw(empPath);
        }
        SSDDrawingTools.indicateStatus(g, this);
    }

    static {
        path.reset();
        path.moveTo(10.0f, 10.0f);
        path.lineTo(7.0f, 20.0f);
        path.lineTo(7.0f, 35.0f);
        path.lineTo(0.0f, 45.0f);
        path.lineTo(7.0f, 45.0f);
        path.lineTo(8.0f, 50.0f);
        path.lineTo(12.0f, 50.0f);
        path.lineTo(13.0f, 45.0f);
        path.lineTo(20.0f, 45.0f);
        path.lineTo(13.0f, 35.0f);
        path.lineTo(13.0f, 20.0f);
        path.lineTo(10.0f, 10.0f);
        path.closePath();
        empPath = new GeneralPath();
        empPath.reset();
        float innerRadius = 5.0f;
        float outerRadius = 10.0f;
        double angleIncrement = 0.5235987755982988;
        for (int i = 0; i <= 6; ++i) {
            float sa = (float)Math.sin(angleIncrement * (double)i);
            float ca = (float)Math.cos(angleIncrement * (double)i);
            empPath.moveTo(10.0f - innerRadius * ca, 12.0f - innerRadius * sa);
            empPath.lineTo(10.0f - outerRadius * ca, 12.0f - outerRadius * sa);
        }
        needlePoint = new Line2D.Float(10.0f, 10.0f, 10.0f, 0.0f);
    }
}

