/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.std.FTLDrive;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;

public class FTLDriveWidget
extends SystemWidget {
    static final Dimension FTL_SIZE = new Dimension(21, 21);
    private static final Rectangle2D rect = new Rectangle2D.Double(0.0, 0.0, 20.0, 20.0);
    private static final QuadCurve2D quad1 = new QuadCurve2D.Double(0.0, 10.0, 5.0, 20.0, 10.0, 10.0);
    private static final QuadCurve2D quad2 = new QuadCurve2D.Double(10.0, 10.0, 15.0, 0.0, 20.0, 10.0);

    public FTLDriveWidget() {
        this(new FTLDrive(), true);
    }

    public FTLDriveWidget(FTLDrive ftl) {
        this(ftl, false);
    }

    public FTLDriveWidget(FTLDrive ftl, boolean m) {
        super(ftl, m);
        this.setPreferredSize(FTL_SIZE);
        this.setMinimumSize(FTL_SIZE);
        this.setMaximumSize(FTL_SIZE);
        this.setSize(FTL_SIZE);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.setToolTipText("FTL Drive");
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        g.setColor(Color.white);
        g.fill(rect);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(rect);
        g.draw(quad1);
        g.draw(quad2);
        SSDDrawingTools.indicateStatus(g, this);
    }
}

