/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui.ssd;

import ftjava.gui.ssd.SSDDrawingTools;
import ftjava.gui.ssd.SystemWidget;
import ftjava.gui.util.IntegerInputDialog;
import ftjava.std.CargoHold;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class CargoHoldWidget
extends SystemWidget {
    private static final long serialVersionUID = 1L;
    private static final Dimension CARGO_HOLD_SIZE = new Dimension(136, 41);
    private static final Rectangle2D holdRect = new Rectangle2D.Double(0.0, 0.0, 30.0, 40.0);

    public CargoHoldWidget(CargoHold ch) {
        this(ch, false);
    }

    public CargoHoldWidget() {
        this(new CargoHold(), true);
    }

    public CargoHoldWidget(CargoHold ch, boolean mutable) {
        super(ch, mutable);
        this.initialiseCargoMenuItems();
        this.setMinimumSize(CARGO_HOLD_SIZE);
        this.setMaximumSize(CARGO_HOLD_SIZE);
        this.setPreferredSize(CARGO_HOLD_SIZE);
        this.setSize(CARGO_HOLD_SIZE);
        this.setToolTipText(this.getToolTip());
    }

    public void paint(Graphics g_o) {
        Graphics2D g = (Graphics2D)g_o;
        CargoHold theHold = (CargoHold)this.theSystem;
        AffineTransform lastT = g.getTransform();
        g.addRenderingHints(SSDDrawingTools.ANTIALIASING_ON);
        String typeChar = theHold.getType().toUpperCase().substring(0, 1);
        int totalSize = theHold.getTotalSize();
        int q = totalSize / 4;
        int r = totalSize % 4;
        int cargoX = 0;
        int cargoY = 0;
        for (int i = 0; i < 4; ++i) {
            int s = q;
            int n = r > 0 ? 1 : 0;
            --r;
            g.translate(cargoX, cargoY);
            this.drawHold(g, s += n, typeChar);
            g.setTransform(lastT);
            cargoX += 35;
        }
    }

    public void actionPerformed(ActionEvent ae) {
        CargoHold theHold = (CargoHold)this.theSystem;
        if (ae.getActionCommand().equals("size")) {
            int newSize = IntegerInputDialog.showIntegerInputDialog(JOptionPane.getFrameForComponent(this), theHold.getTotalSize());
            if (newSize > 0) {
                theHold.setTotalSize(newSize);
            }
        } else if (ae.getActionCommand().equals("type")) {
            try {
                JMenuItem src = (JMenuItem)ae.getSource();
                theHold.setType(src.getText());
            }
            catch (ClassCastException cce) {}
        } else if (ae.getActionCommand().equals("custom")) {
            try {
                String new_type = (String)JOptionPane.showInputDialog(JOptionPane.getFrameForComponent(this), "Enter a hold type", "Hold Type", -1, null, null, theHold.getType());
                if (new_type != null) {
                    theHold.setType(new_type);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.setToolTipText(this.getToolTip());
        this.repaint();
    }

    private void drawHold(Graphics2D g, int size, String typeChar) {
        String sizeStr = Integer.toString(size);
        g.setColor(Color.white);
        g.fill(holdRect);
        g.setColor(SSDDrawingTools.getSystemColor(this.theSystem));
        g.draw(holdRect);
        Font f = g.getFont();
        g.setFont(f.deriveFont(1));
        FontMetrics fm = g.getFontMetrics(g.getFont());
        g.drawString(typeChar, 15 - fm.stringWidth(typeChar) / 2, 20);
        g.setFont(f);
        g.drawString(sizeStr, 15 - fm.stringWidth(sizeStr) / 2, 20 + fm.getAscent());
    }

    private void initialiseCargoMenuItems() {
        if (this.mutable) {
            this.popup.addSeparator();
            JMenuItem mi = new JMenuItem("Change Size...");
            mi.setActionCommand("size");
            mi.addActionListener(this);
            this.popup.add(mi);
            JMenu mm = new JMenu("Change Type");
            mi = new JMenuItem("Cargo Hold");
            mi.setActionCommand("type");
            mi.addActionListener(this);
            mm.add(mi);
            mi = new JMenuItem("Laboratory Hold");
            mi.setActionCommand("type");
            mi.addActionListener(this);
            mm.add(mi);
            mi = new JMenuItem("Troop Hold");
            mi.setActionCommand("type");
            mi.addActionListener(this);
            mm.add(mi);
            mi = new JMenuItem("Passenger Space");
            mi.setActionCommand("type");
            mi.addActionListener(this);
            mm.add(mi);
            mi = new JMenuItem("Custom...");
            mi.setActionCommand("custom");
            mi.addActionListener(this);
            mm.add(mi);
            this.popup.add(mm);
        }
    }

    private String getToolTip() {
        CargoHold theHold = (CargoHold)this.theSystem;
        return "Capacity " + theHold.getTotalSize() + " " + theHold.getType();
    }
}

