/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.std.GameEngine;
import ftjava.std.LogRecord;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TurnReport
extends JFrame {
    private static final long serialVersionUID = 1L;
    private GameEngine engine;
    private DefaultListModel allEventsListModel;
    private DefaultListModel[] turnEventsListModel;
    private JList eventList;
    private JComboBox turnSelector;
    private boolean hasReportThisTurn;

    public TurnReport(GameEngine inengine) {
        int i;
        this.engine = inengine;
        this.setTitle("Turn Report - Game " + this.engine.getId());
        this.hasReportThisTurn = false;
        this.allEventsListModel = new DefaultListModel();
        this.turnEventsListModel = new DefaultListModel[this.engine.getGameTurn() + 1];
        for (int i2 = 0; i2 <= this.engine.getGameTurn(); ++i2) {
            this.turnEventsListModel[i2] = new DefaultListModel();
        }
        ArrayList events = this.engine.getTurnReport();
        for (i = 0; i < events.size(); ++i) {
            this.allEventsListModel.addElement(events.get(i));
            if (!(events.get(i) instanceof LogRecord)) continue;
            LogRecord ev = (LogRecord)events.get(i);
            int turn = ev.getTurn();
            if (turn != 999) {
                this.turnEventsListModel[turn].addElement(ev);
            }
            if (turn != this.engine.getGameTurn()) continue;
            this.hasReportThisTurn = true;
        }
        this.eventList = new JList(this.allEventsListModel);
        this.turnSelector = new JComboBox();
        for (i = 0; i <= this.engine.getGameTurn(); ++i) {
            this.turnSelector.addItem(Integer.toString(i));
        }
        this.turnSelector.addItem("All");
        String turnString = Integer.toString(this.engine.getGameTurn());
        this.turnSelector.setSelectedItem(turnString);
        this.eventList.setModel(this.turnEventsListModel[this.engine.getGameTurn()]);
        this.turnSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String text = "";
                try {
                    text = (String)TurnReport.this.turnSelector.getSelectedItem();
                }
                catch (ClassCastException cce) {
                    // empty catch block
                }
                if (text.equals("All")) {
                    TurnReport.this.eventList.setModel(TurnReport.this.allEventsListModel);
                } else {
                    int t = Integer.parseInt(text);
                    TurnReport.this.eventList.setModel(TurnReport.this.turnEventsListModel[t]);
                }
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(this.eventList), "Center");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("Turn Filter  "));
        p.add(this.turnSelector);
        this.getContentPane().add((Component)p, "North");
        this.pack();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        int screenHeight = d.height;
        int screenWidth = d.width;
        int frameHeight = this.getHeight();
        int frameWidth = this.getWidth();
        int xLoc = screenWidth / 2 - frameWidth / 2;
        int yLoc = screenHeight / 2 - frameHeight / 2;
        this.setLocation(xLoc, yLoc);
        this.setVisible(false);
    }

    public boolean hasCurrentReport() {
        return this.hasReportThisTurn;
    }
}

