/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.std.FireControl;
import ftjava.std.GameEngine;
import ftjava.std.Player;
import ftjava.std.Ship;
import ftjava.std.Weapon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TargetingSummaryDialog {
    private Player thePlayer;
    private GameEngine theEngine;
    private JDialog theDialog = new JDialog();
    private JPanel treePanel;
    private JTree theTree;
    private DefaultTreeModel theTreeModel;
    private TreePath firstPath;
    private int treeHeight = 425;
    private int treeWidth = 300;
    private ArrayList targets;
    private ArrayList shipList;
    private ArrayList myShips;

    public TargetingSummaryDialog(GameEngine engine, Player activePlayer) {
        this.theEngine = engine;
        this.thePlayer = activePlayer;
        String title = "Ship Targeting Summary";
        this.theDialog.setTitle(title);
        this.theDialog.setModal(false);
        this.theDialog.setResizable(true);
        JButton updateButton = new JButton("Update");
        JButton closeButton = new JButton("Close");
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        int screenWidth = d.width;
        this.theDialog.setLocation(screenWidth / 2 + 20, 20);
        this.createTreePanel();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TargetingSummaryDialog.this.updatePressed();
            }
        });
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TargetingSummaryDialog.this.closePressed();
            }
        });
        buttonPanel.add(updateButton);
        buttonPanel.add(closeButton);
        this.theDialog.getContentPane().add((Component)buttonPanel, "South");
        this.theDialog.getRootPane().setDefaultButton(updateButton);
        this.theDialog.pack();
        this.theDialog.setVisible(false);
    }

    private void createTreePanel() {
        this.treePanel = new JPanel();
        this.treePanel.setLayout(new BorderLayout());
        this.treePanel.setSize(this.treeWidth, this.treeHeight);
        this.treePanel.setMinimumSize(new Dimension(this.treeWidth, this.treeHeight));
        this.theTree = new JTree(this.updateTreeModel());
        this.theTree.setSelectionPath(this.firstPath);
        this.theTree.expandPath(this.firstPath);
        this.treePanel.add(new JScrollPane(this.theTree));
        this.treePanel.setVisible(true);
        this.theDialog.getContentPane().add((Component)this.treePanel, "Center");
    }

    public DefaultTreeModel updateTreeModel() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Targets");
        this.theTreeModel = new DefaultTreeModel(top);
        this.targets = new ArrayList();
        this.shipList = this.theEngine.getShips();
        this.myShips = new ArrayList();
        for (int i = 0; i < this.shipList.size(); ++i) {
            Ship s = (Ship)this.shipList.get(i);
            if (s.getPlayer().equals(this.thePlayer)) {
                this.myShips.add(s);
                continue;
            }
            if (s.getPlayer().getTeam().equals(this.thePlayer.getTeam())) continue;
            this.targets.add(s);
        }
        boolean firstNode = true;
        this.firstPath = new TreePath(top);
        for (int i = 0; i < this.targets.size(); ++i) {
            Ship s = (Ship)this.targets.get(i);
            DefaultMutableTreeNode aShipNode = new DefaultMutableTreeNode(s);
            DefaultMutableTreeNode bShipNode = null;
            top.add(aShipNode);
            for (int j = 0; j < this.myShips.size(); ++j) {
                boolean first = true;
                Ship mine = (Ship)this.myShips.get(j);
                ArrayList fireCons = mine.getActiveFireControls();
                for (int k = 0; k < fireCons.size(); ++k) {
                    FireControl fc = (FireControl)fireCons.get(k);
                    if (fc == null || fc.getTargetId() != s.getId()) continue;
                    if (first) {
                        bShipNode = new DefaultMutableTreeNode(mine.toString() + ": range " + (int)(mine.rangeTo(s) + 1.0));
                        aShipNode.add(bShipNode);
                        first = false;
                    }
                    if (fc.getSlavedWeapons() == null) continue;
                    Iterator Weapons = fc.getSlavedWeapons().iterator();
                    while (Weapons.hasNext()) {
                        Weapon w = (Weapon)Weapons.next();
                        DefaultMutableTreeNode aWeaponNode = new DefaultMutableTreeNode(w);
                        bShipNode.add(aWeaponNode);
                        if (!firstNode) continue;
                        firstNode = false;
                        this.firstPath = this.firstPath.pathByAddingChild(aShipNode);
                        this.firstPath = this.firstPath.pathByAddingChild(bShipNode);
                        this.firstPath = this.firstPath.pathByAddingChild(aWeaponNode);
                    }
                }
            }
        }
        return this.theTreeModel;
    }

    public void setVisible(boolean tf) {
        this.theDialog.setVisible(tf);
    }

    public void updatePressed() {
        this.theTree.setModel(this.updateTreeModel());
        this.theTree.setSelectionPath(this.firstPath);
    }

    public void closePressed() {
        this.theDialog.setVisible(false);
    }
}

