/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.ClientProgram;
import ftjava.gui.GUIAdapter;
import ftjava.gui.MapPanel;
import ftjava.gui.Preferences;
import ftjava.gui.ShipGUIAdapter;
import ftjava.gui.SpaceObjectGUIAdapter;
import ftjava.gui.util.ImageUtilities;
import ftjava.std.GameEngine;
import ftjava.std.Ship;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class StarMap
extends JFrame {
    private static final long serialVersionUID = 1L;
    private String titleString;
    private String scaleString;
    private MapPanel mapPanel;
    private GUIAdapter activeSelection;
    private JScrollPane ScrollPane;
    private boolean centerOnShipFlag;

    public StarMap(GameEngine ge, ClientProgram inClient) {
        this.initialize(ge, inClient);
    }

    public void initialize(GameEngine ge, ClientProgram inClient) {
        this.titleString = "Full Thrust - Game " + ge.getId() + " - " + ge.getName();
        this.scaleString = "10:1";
        this.setTitle(this.titleString + " -  Scale " + this.scaleString);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        int screenHeight = d.height;
        int screenWidth = d.width;
        this.setSize(screenWidth / 2, 2 * screenHeight / 3);
        this.setLocation(screenWidth / 2, 0);
        BufferedImage img = ImageUtilities.getImage("Images/fticon.gif", this);
        this.setIconImage(img);
        Container contentPane = this.getContentPane();
        final MapPanel p = this.mapPanel = new MapPanel(ge, inClient, this);
        Iterator i = p.getShipAdapters().iterator();
        while (i.hasNext()) {
            GUIAdapter a;
            Object o = i.next();
            if (o instanceof ShipGUIAdapter) {
                a = (ShipGUIAdapter)o;
                ((ShipGUIAdapter)a).setStarMap(this);
                continue;
            }
            if (!(o instanceof SpaceObjectGUIAdapter)) continue;
            a = (SpaceObjectGUIAdapter)o;
            ((SpaceObjectGUIAdapter)a).setStarMap(this);
        }
        this.activeSelection = null;
        p.calculateBounds();
        this.ScrollPane = new JScrollPane(p);
        p.setParent(this.ScrollPane);
        JScrollBar hBar = this.ScrollPane.getHorizontalScrollBar();
        JScrollBar vBar = this.ScrollPane.getVerticalScrollBar();
        hBar.setUnitIncrement(1);
        vBar.setUnitIncrement(1);
        String centerProp = "Center on Selected Ship";
        this.centerOnShipFlag = Preferences.getPreferences().getProperty(centerProp).equals("true");
        int hMid = (hBar.getMaximum() + hBar.getMinimum()) / 2;
        int vMid = (vBar.getMaximum() + vBar.getMinimum()) / 2;
        hBar.setValue(hMid);
        vBar.setValue(vMid);
        hMid = (hBar.getMaximum() + hBar.getMinimum()) / 2;
        vMid = (vBar.getMaximum() + vBar.getMinimum()) / 2;
        hBar.setValue(Math.max(0, hMid - 360));
        vBar.setValue(Math.max(0, vMid - 360));
        contentPane.add(this.ScrollPane);
        p.setParent(this.ScrollPane);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '-') {
                    p.zoomOut();
                } else if (e.getKeyChar() == '=') {
                    p.zoomIn();
                } else if (e.getKeyChar() == 'z' || e.getKeyChar() == 'Z') {
                    p.clearDisplay();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public MapPanel getMapPanel() {
        return this.mapPanel;
    }

    public TreeSet getAllAdapters() {
        return this.mapPanel.getAllAdapters();
    }

    public TreeSet getShipAdapters() {
        return this.mapPanel.getShipAdapters();
    }

    public TreeSet getSpaceObjectAdapters() {
        return this.mapPanel.getSpaceObjectAdapters();
    }

    public BufferedImage renderImage() {
        double size = Math.max(this.mapPanel.getMapWidth(), this.mapPanel.getMapHeight());
        size = Math.max(size, 128.0);
        BufferedImage image = new BufferedImage((int)size, (int)size, 1);
        this.mapPanel.paintComponent(image.createGraphics());
        return image;
    }

    public void setStarMapTitle(String l) {
        this.setTitle(this.titleString + " -  Scale " + l);
    }

    public void recalculate() {
        this.mapPanel.calculateBounds();
        this.mapPanel.revalidate();
        this.mapPanel.repaint();
    }

    public void setActiveSelection(GUIAdapter a) {
        this.activeSelection = a;
        if (this.centerOnShipFlag) {
            this.mapPanel.centerOnShip(a);
        }
    }

    public void setActiveSelection(Ship s) {
        Iterator i = this.mapPanel.getShipAdapters().iterator();
        while (i.hasNext()) {
            ShipGUIAdapter sga;
            Object o = i.next();
            if (!(o instanceof ShipGUIAdapter) || (sga = (ShipGUIAdapter)o).getShip() != s) continue;
            this.setActiveSelection(sga);
            return;
        }
    }

    public GUIAdapter getActiveSelection() {
        return this.activeSelection;
    }

    public void loadAdapters() {
        this.mapPanel.loadAdapters(true);
    }

    public void loadAdapters(boolean calcBounds) {
        this.mapPanel.loadAdapters(calcBounds);
    }

    public void zoomIn() {
        this.mapPanel.zoomIn();
    }

    public void zoomOut() {
        this.mapPanel.zoomOut();
    }

    public void cleanUp() {
    }

    public boolean getCenterOnShip() {
        return this.centerOnShipFlag;
    }
}

